/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data_federation.model.ServiceDateSummary;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.StopScheduleService;
import org.onebusaway.transit_data_federation.services.beans.AgencyBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopScheduleServiceImpl
implements StopScheduleService {
    private TransitGraphDao _transitGraphDao;
    private BlockIndexService _blockIndexService;
    private ExtendedCalendarService _calendarService;
    private AgencyBeanService _agencyBeanService;

    StopScheduleServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setExtendedCalendarService(ExtendedCalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setAgencyBeanService(AgencyBeanService agencyBeanService) {
        this._agencyBeanService = agencyBeanService;
    }

    @Override
    public List<ServiceDateSummary> getServiceDateSummariesForStop(AgencyAndId stopId, boolean includePrivateService) {
        Set serviceIds;
        StopEntry stop = this._transitGraphDao.getStopEntryForId(stopId, true);
        Set<ServiceIdActivation> allServiceIds = this.getAllServiceIdsForStop(stop, includePrivateService);
        FactoryMap serviceIdsByDate = new FactoryMap(new HashSet());
        for (ServiceIdActivation serviceIdActivation : allServiceIds) {
            Set<ServiceDate> set = this._calendarService.getServiceDatesForServiceIds(serviceIdActivation);
            for (ServiceDate serviceDate : set) {
                ((Set)serviceIdsByDate.get(serviceDate)).add(serviceIdActivation);
            }
        }
        FactoryMap datesByServiceIds = new FactoryMap(new ArrayList());
        for (Map.Entry entry : serviceIdsByDate.entrySet()) {
            ServiceDate serviceDate = (ServiceDate)entry.getKey();
            serviceIds = (Set)entry.getValue();
            ((List)datesByServiceIds.get(serviceIds)).add(serviceDate);
        }
        ArrayList<ServiceDateSummary> arrayList = new ArrayList<ServiceDateSummary>();
        for (Map.Entry entry : datesByServiceIds.entrySet()) {
            serviceIds = (Set)entry.getKey();
            List serviceDates = (List)entry.getValue();
            Collections.sort(serviceDates);
            arrayList.add(new ServiceDateSummary(serviceIds, serviceDates));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private Set<ServiceIdActivation> getAllServiceIdsForStop(StopEntry stop, boolean includePrivateService) {
        HashSet<ServiceIdActivation> allServiceIds = new HashSet<ServiceIdActivation>();
        List<BlockStopTimeIndex> indices = this._blockIndexService.getStopTimeIndicesForStop(stop);
        for (BlockStopTimeIndex blockStopTimeIndex : indices) {
            allServiceIds.add(blockStopTimeIndex.getServiceIds());
        }
        List<FrequencyBlockStopTimeIndex> frequencyIndices = this._blockIndexService.getFrequencyStopTimeIndicesForStop(stop);
        for (FrequencyBlockStopTimeIndex index : frequencyIndices) {
            allServiceIds.add(index.getServiceIds());
        }
        Iterator iterator = allServiceIds.iterator();
        while (iterator.hasNext()) {
            ServiceIdActivation activation = (ServiceIdActivation)iterator.next();
            LocalizedServiceId lsid = activation.getActiveServiceIds().get(0);
            String agencyId = lsid.getId().getAgencyId();
            AgencyBean bean = this._agencyBeanService.getAgencyForId(agencyId);
            if (!bean.isPrivateService() || includePrivateService) continue;
            iterator.remove();
        }
        return allServiceIds;
    }
}

