/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.Counter;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.Max;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.transit_data_federation.model.StopSequence;
import org.onebusaway.transit_data_federation.model.StopSequenceCollection;
import org.onebusaway.transit_data_federation.model.StopSequenceCollectionKey;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.StopSequenceCollectionService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.collections.TreeUnionFind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StopSequenceCollectionServiceImpl
implements StopSequenceCollectionService {
    private static final double SERVICE_PATTERN_TRIP_COUNT_RATIO_MIN = 0.2;
    private static final double STOP_SEQUENCE_MIN_COMMON_RATIO = 0.3;
    private NarrativeService _narrativeService;

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Override
    public List<StopSequenceCollection> getStopSequencesAsCollections(List<StopSequence> sequences) {
        this.pruneEmptyStopSequences(sequences);
        if (sequences.isEmpty()) {
            return new ArrayList<StopSequenceCollection>();
        }
        Map<StopSequence, PatternStats> sequenceStats = this.getStatsForStopSequences(sequences);
        Map<String, List<StopSequence>> sequenceGroups = this.getGroupsForStopSequences(sequences);
        return this.constructCollections(sequenceStats, sequenceGroups);
    }

    private void pruneEmptyStopSequences(List<StopSequence> stopSequences) {
        Iterator<StopSequence> it = stopSequences.iterator();
        while (it.hasNext()) {
            StopSequence st = it.next();
            if (!st.getStops().isEmpty()) continue;
            it.remove();
        }
    }

    private Map<StopSequence, PatternStats> getStatsForStopSequences(List<StopSequence> sequences) {
        HashMap<StopSequence, PatternStats> patternStats = new HashMap<StopSequence, PatternStats>();
        for (StopSequence sequence : sequences) {
            PatternStats stats = new PatternStats();
            stats.tripCounts = sequence.getTripCount();
            stats.segment = this.getSegmentForStopSequence(sequence);
            patternStats.put(sequence, stats);
        }
        return patternStats;
    }

    private Segment getSegmentForStopSequence(StopSequence pattern) {
        Segment segment = new Segment();
        List<StopEntry> stops = pattern.getStops();
        StopEntry prev = null;
        for (StopEntry stop : stops) {
            if (prev == null) {
                segment.fromLat = stop.getStopLat();
                segment.fromLon = stop.getStopLon();
            } else {
                segment.distance += SphericalGeometryLibrary.distance((double)prev.getStopLat(), (double)prev.getStopLon(), (double)stop.getStopLat(), (double)stop.getStopLon());
            }
            segment.toLat = stop.getStopLat();
            segment.toLon = stop.getStopLon();
            prev = stop;
        }
        return segment;
    }

    private Map<String, List<StopSequence>> getGroupsForStopSequences(List<StopSequence> sequences) {
        Map<String, List<StopSequence>> result;
        boolean allSequencesHaveDirectionId = true;
        for (StopSequence sequence : sequences) {
            if (sequence.getDirectionId() != null) continue;
            allSequencesHaveDirectionId = false;
        }
        if (allSequencesHaveDirectionId && (result = this.groupStopSequencesByDirectionIds(sequences)).size() > 0) {
            return result;
        }
        return this.groupStopSequencesByNotDirectionIds(sequences);
    }

    private Map<String, List<StopSequence>> groupStopSequencesByDirectionIds(Iterable<StopSequence> sequences) {
        FactoryMap groups = new FactoryMap(new ArrayList());
        for (StopSequence sequence : sequences) {
            String directionId = sequence.getDirectionId();
            ((List)groups.get(directionId)).add(sequence);
        }
        return groups;
    }

    private Map<String, List<StopSequence>> groupStopSequencesByNotDirectionIds(Iterable<StopSequence> sequences) {
        TreeUnionFind unionFind = new TreeUnionFind();
        for (StopSequence stopSequenceA : sequences) {
            unionFind.find((Object)stopSequenceA);
            for (StopSequence stopSequenceB : sequences) {
                double ratio;
                if (stopSequenceA == stopSequenceB || !((ratio = this.getMaxCommonStopSequenceRatio(stopSequenceA, stopSequenceB)) >= 0.3)) continue;
                unionFind.union((Object)stopSequenceA, (Object)stopSequenceB);
            }
        }
        HashMap<String, List<StopSequence>> results = new HashMap<String, List<StopSequence>>();
        int index = 0;
        for (Set sequencesByDirection : unionFind.getSetMembers()) {
            String key = Integer.toString(index);
            ArrayList asList = new ArrayList(sequencesByDirection);
            results.put(key, asList);
            ++index;
        }
        return results;
    }

    private List<StopSequenceCollection> constructCollections(Map<StopSequence, PatternStats> sequenceStats, Map<String, List<StopSequence>> sequencesByGroupId) {
        Object direction;
        this.computeContinuations(sequenceStats, sequencesByGroupId);
        HashSet<String> allNames = new HashSet<String>();
        HashMap<Object, String> directionToName = new HashMap<Object, String>();
        HashMap<Object, Segment> segments = new HashMap<Object, Segment>();
        for (Map.Entry<String, List<StopSequence>> entry : sequencesByGroupId.entrySet()) {
            direction = entry.getKey();
            List<StopSequence> sequences = entry.getValue();
            Max maxTripCount = new Max();
            Counter names = new Counter();
            for (StopSequence sequence : sequences) {
                maxTripCount.add((double)sequence.getTripCount(), (Object)sequence);
                for (BlockTripEntry blockTrip : sequence.getTrips()) {
                    String headsign;
                    TripEntry trip = blockTrip.getTrip();
                    TripNarrative tripNarrative = this._narrativeService.getTripForId(trip.getId());
                    if (tripNarrative == null || (headsign = tripNarrative.getTripHeadsign()) == null || headsign.length() <= 0) continue;
                    names.increment((Object)headsign);
                }
            }
            String dName = (String)names.getMax();
            RecursiveStats rs = new RecursiveStats();
            rs.maxTripCount = (long)maxTripCount.getMaxValue();
            this.exploreStopSequences(rs, sequenceStats, sequences, "");
            allNames.add(dName);
            directionToName.put(direction, dName);
            segments.put(direction, (Segment)rs.longestSegment.getMaxElement());
        }
        if (allNames.size() < directionToName.size()) {
            for (Map.Entry<String, List<StopSequence>> entry : directionToName.entrySet()) {
                direction = entry.getKey();
                String name = (String)((Object)entry.getValue());
                direction = ((String)direction).charAt(0) + ((String)direction).substring(1).toLowerCase();
                entry.setValue((List<StopSequence>)((Object)(name + " - " + (String)direction)));
            }
        }
        ArrayList<StopSequenceCollection> blocks = new ArrayList<StopSequenceCollection>();
        for (Map.Entry entry : directionToName.entrySet()) {
            String direction2 = (String)entry.getKey();
            String name = (String)entry.getValue();
            List<StopSequence> patterns = sequencesByGroupId.get(direction2);
            Segment segment = (Segment)segments.get(direction2);
            StopSequenceCollection block = new StopSequenceCollection();
            if (segment.fromLat == 0.0) {
                throw new IllegalStateException("what?");
            }
            StopSequenceCollectionKey key = new StopSequenceCollectionKey(null, direction2);
            block.setId(key);
            block.setPublicId(direction2);
            block.setDescription(name);
            block.setStopSequences(patterns);
            block.setStartLat(segment.fromLat);
            block.setStartLon(segment.fromLon);
            block.setEndLat(segment.toLat);
            block.setEndLon(segment.toLon);
            blocks.add(block);
        }
        return blocks;
    }

    private void computeContinuations(Map<StopSequence, PatternStats> sequenceStats, Map<String, List<StopSequence>> sequencesByGroupId) {
        HashMap stopSequencesByTrip = new HashMap();
        HashMap<StopSequence, String> stopSequenceGroupIds = new HashMap<StopSequence, String>();
        for (Map.Entry<String, List<StopSequence>> entry : sequencesByGroupId.entrySet()) {
            String id = entry.getKey();
            for (StopSequence sequence : entry.getValue()) {
                stopSequenceGroupIds.put(sequence, id);
            }
        }
        for (StopSequence sequence : sequenceStats.keySet()) {
            String groupId = (String)stopSequenceGroupIds.get((Object)sequence);
            for (BlockTripEntry trip : sequence.getTrips()) {
                String prevGroupId;
                StopSequence prevSequence;
                BlockTripEntry prevTrip = trip.getPreviousTrip();
                if (prevTrip == null || (prevSequence = (StopSequence)((Object)stopSequencesByTrip.get(prevTrip))) == null || prevSequence.equals((Object)sequence) || !groupId.equals(prevGroupId = (String)stopSequenceGroupIds.get((Object)prevSequence))) continue;
                StopEntry prevStop = prevSequence.getStops().get(prevSequence.getStops().size() - 1);
                StopEntry nextStop = sequence.getStops().get(0);
                double d = SphericalGeometryLibrary.distance((double)prevStop.getStopLat(), (double)prevStop.getStopLon(), (double)nextStop.getStopLat(), (double)nextStop.getStopLon());
                if (!(d < 1320.0)) continue;
                PatternStats stats = sequenceStats.get((Object)prevSequence);
                stats.continuations.add(sequence);
            }
        }
    }

    private void exploreStopSequences(RecursiveStats rs, Map<StopSequence, PatternStats> patternStats, Iterable<StopSequence> patterns, String depth) {
        Segment prevSegment = rs.prevSegment;
        for (StopSequence pattern : patterns) {
            if (rs.visited.contains((Object)pattern)) continue;
            PatternStats stats = patternStats.get((Object)pattern);
            double count = stats.tripCounts;
            double ratio = count / (double)rs.maxTripCount;
            if (ratio < 0.2) continue;
            Segment segment = stats.segment;
            if (prevSegment != null) {
                segment = new Segment(prevSegment, segment, prevSegment.distance + segment.distance);
            }
            rs.longestSegment.add(segment.distance, (Object)segment);
            Set<StopSequence> nextPatterns = stats.continuations;
            if (nextPatterns.isEmpty()) continue;
            rs.visited.add(pattern);
            rs.prevSegment = segment;
            this.exploreStopSequences(rs, patternStats, nextPatterns, depth + "  ");
            rs.visited.remove((Object)pattern);
        }
    }

    private double getMaxCommonStopSequenceRatio(StopSequence a, StopSequence b) {
        Set<Pair<StopEntry>> pairsA = this.getStopSequenceAsStopPairSet(a);
        Set<Pair<StopEntry>> pairsB = this.getStopSequenceAsStopPairSet(b);
        int common = 0;
        for (Pair<StopEntry> pairA : pairsA) {
            if (!pairsB.contains(pairA)) continue;
            ++common;
        }
        double ratioA = (double)common / (double)pairsA.size();
        double ratioB = (double)common / (double)pairsB.size();
        return Math.max(ratioA, ratioB);
    }

    private Set<Pair<StopEntry>> getStopSequenceAsStopPairSet(StopSequence stopSequence) {
        HashSet<Pair<StopEntry>> pairs = new HashSet<Pair<StopEntry>>();
        StopEntry prev = null;
        for (StopEntry stop : stopSequence.getStops()) {
            if (prev != null) {
                Pair pair = Tuples.pair((Object)prev, (Object)stop);
                pairs.add((Pair<StopEntry>)pair);
            }
            prev = stop;
        }
        return pairs;
    }

    private static class Segment {
        double fromLon;
        double fromLat;
        double toLon;
        double toLat;
        double distance;

        public Segment() {
        }

        public Segment(Segment prevSegment, Segment toSegment, double d) {
            this.fromLat = prevSegment.fromLat;
            this.fromLon = prevSegment.fromLon;
            this.toLat = toSegment.toLat;
            this.toLon = toSegment.toLon;
            this.distance = d;
        }
    }

    private static class RecursiveStats {
        Max<Segment> longestSegment = new Max();
        Set<StopSequence> visited = new HashSet<StopSequence>();
        long maxTripCount;
        Segment prevSegment;

        private RecursiveStats() {
        }
    }

    private static class PatternStats {
        long tripCounts;
        Segment segment;
        Set<StopSequence> continuations = new HashSet<StopSequence>();

        private PatternStats() {
        }
    }
}

