/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.transit_data.model.trips.TimepointPredictionBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.services.PredictionHelperService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrivialPredictionHelperService
implements PredictionHelperService {
    private static Logger _log = LoggerFactory.getLogger(TrivialPredictionHelperService.class);
    @Autowired
    private TransitDataService _transitDataService;

    @Override
    public List<TimepointPredictionRecord> getPredictionRecordsForTrip(String agencyId, TripStatusBean tripStatus) {
        ArrayList<TimepointPredictionRecord> records = null;
        if (agencyId == null) {
            return records;
        }
        if (tripStatus == null) {
            return records;
        }
        if (!tripStatus.isPredicted()) {
            return records;
        }
        if ("CANCELED".equals(tripStatus.getStatus())) {
            return records;
        }
        records = new ArrayList<TimepointPredictionRecord>();
        List beans = tripStatus.getTimepointPredictions();
        if (beans != null && beans.size() > 0) {
            for (TimepointPredictionBean bean : beans) {
                if (!tripStatus.getActiveTrip().getId().equals(bean.getTripId())) {
                    _log.debug("timepoint for non-active trip {}", (Object)bean.getTripId());
                }
                TimepointPredictionRecord tpr = new TimepointPredictionRecord();
                tpr.setTimepointId(AgencyAndIdLibrary.convertFromString((String)bean.getTimepointId()));
                tpr.setTimepointScheduledTime(bean.getTimepointScheduledTime());
                tpr.setTimepointPredictedArrivalTime(bean.getTimepointPredictedArrivalTime());
                tpr.setTimepointPredictedDepartureTime(bean.getTimepointPredictedDepartureTime());
                tpr.setStopSequence(bean.getStopSequence());
                tpr.setTripId(AgencyAndIdLibrary.convertFromString((String)bean.getTripId()));
                tpr.setScheduleRealtionship(bean.getScheduleRelationship().getValue());
                tpr.setActualTrack(bean.getActualTrack());
                tpr.setScheduledTrack(bean.getScheduledTrack());
                tpr.setStatus(bean.getStatus());
                records.add(tpr);
            }
            return records;
        }
        TimepointPredictionRecord tpr = new TimepointPredictionRecord();
        tpr.setTimepointId(AgencyAndIdLibrary.convertFromString((String)tripStatus.getNextStop().getId()));
        tpr.setTimepointScheduledTime(tripStatus.getLastUpdateTime() + (long)(tripStatus.getNextStopTimeOffset() * 1000));
        tpr.setTimepointPredictedArrivalTime((long)((double)tpr.getTimepointScheduledTime() + tripStatus.getScheduleDeviation()));
        tpr.setTimepointPredictedDepartureTime((long)((double)tpr.getTimepointScheduledTime() + tripStatus.getScheduleDeviation()));
        if (tpr.getScheduleRelationship() != null) {
            tpr.setScheduleRealtionship(tpr.getScheduleRelationship().getValue());
        } else {
            _log.info("no schedule relationship for trip " + tripStatus.getActiveTrip().getId());
            tpr.setScheduleRealtionship(TimepointPredictionRecord.ScheduleRelationship.SKIPPED.getValue());
        }
        records.add(tpr);
        return records;
    }
}

