/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.services.beans.GeospatialBeanService;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class WhereGeospatialServiceImpl
implements GeospatialBeanService {
    private static Logger _log = LoggerFactory.getLogger(WhereGeospatialServiceImpl.class);
    private TransitGraphDao _transitGraphDao;
    private STRtree _tree;

    WhereGeospatialServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @PostConstruct
    @Refreshable(dependsOn={"stopGeospatialIndex"})
    public void initialize() {
        List<StopEntry> stops = this._transitGraphDao.getAllStops();
        if (stops.size() == 0) {
            this._tree = null;
            return;
        }
        this._tree = new STRtree(stops.size());
        for (StopEntry stop : stops) {
            float x = (float)stop.getStopLon();
            float y = (float)stop.getStopLat();
            Envelope env = new Envelope((double)x, (double)x, (double)y, (double)y);
            this._tree.insert(env, (Object)stop.getId());
        }
        this._tree.build();
    }

    @Override
    public List<AgencyAndId> getStopsByBounds(CoordinateBounds bounds) {
        if (this._tree == null) {
            _log.warn("Stop tree is empty!");
            return Collections.emptyList();
        }
        double xMin = bounds.getMinLon();
        double yMin = bounds.getMinLat();
        double xMax = bounds.getMaxLon();
        double yMax = bounds.getMaxLat();
        TreeVisistor v = new TreeVisistor();
        this._tree.query(new Envelope(xMin, xMax, yMin, yMax), (ItemVisitor)v);
        return v.getIdsInRange();
    }

    private class TreeVisistor
    implements ItemVisitor {
        private List<AgencyAndId> _idsInRange = new ArrayList<AgencyAndId>();

        private TreeVisistor() {
        }

        public List<AgencyAndId> getIdsInRange() {
            return this._idsInRange;
        }

        public void visitItem(Object obj) {
            this._idsInRange.add((AgencyAndId)obj);
        }
    }
}

