/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.realtime.HistogramBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data_federation.impl.beans.FrequencyBeanLibrary;
import org.onebusaway.transit_data_federation.impl.realtime.apc.VehicleOccupancyRecordCache;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeNegativeArrivals;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.model.bundle.HistoricalRidership;
import org.onebusaway.transit_data_federation.model.narrative.StopTimeNarrative;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureQuery;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureService;
import org.onebusaway.transit_data_federation.services.RidershipService;
import org.onebusaway.transit_data_federation.services.beans.ArrivalsAndDeparturesBeanService;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopsBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripDetailsBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureInstance;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.RealTimeHistoryService;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationHistogram;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(value="org.onebusaway.transit_data_federation.impl.beans:name=ArrivalsAndDeparturesBeanServiceImpl")
public class ArrivalsAndDeparturesBeanServiceImpl
implements ArrivalsAndDeparturesBeanService {
    private static Logger _log = LoggerFactory.getLogger(ArrivalsAndDeparturesBeanServiceImpl.class);
    private TransitGraphDao _transitGraphDao;
    private ArrivalAndDepartureService _arrivalAndDepartureService;
    private NarrativeService _narrativeService;
    private TripBeanService _tripBeanService;
    private StopBeanService _stopBeanService;
    private StopsBeanService _stopsBeanService;
    private TripDetailsBeanService _tripDetailsBeanService;
    private ServiceAlertsBeanService _serviceAlertsBeanService;
    private RealTimeHistoryService _realTimeHistoryService;
    private GtfsRealtimeNegativeArrivals _gtfsRealtimeNegativeArrivals;
    private RidershipService _ridershipService;
    private VehicleOccupancyRecordCache _vehicleOccupancyRecordCache;
    private AtomicInteger _stopTimesTotal = new AtomicInteger();
    private AtomicInteger _stopTimesWithPredictions = new AtomicInteger();
    private boolean useScheduleDeviationHistory = true;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setArrivalAndDepartureService(ArrivalAndDepartureService arrivalAndDepartureService) {
        this._arrivalAndDepartureService = arrivalAndDepartureService;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setTripBeanService(TripBeanService tripBeanService) {
        this._tripBeanService = tripBeanService;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setStopsBeanService(StopsBeanService stopsBeanService) {
        this._stopsBeanService = stopsBeanService;
    }

    @Autowired
    public void setRidershipService(RidershipService ridershipService) {
        this._ridershipService = ridershipService;
    }

    @Autowired
    public void setVehicleOccupancyRecordCache(VehicleOccupancyRecordCache cache) {
        this._vehicleOccupancyRecordCache = cache;
    }

    @Autowired
    public void setTripDetailsBeanService(TripDetailsBeanService tripDetailsBeanService) {
        this._tripDetailsBeanService = tripDetailsBeanService;
    }

    @Autowired
    public void setServiceAlertsBeanService(ServiceAlertsBeanService serviceAlertsBeanService) {
        this._serviceAlertsBeanService = serviceAlertsBeanService;
    }

    @Autowired
    public void setRealTimeHistoryService(RealTimeHistoryService realTimeHistoryService) {
        this._realTimeHistoryService = realTimeHistoryService;
    }

    @Autowired
    public void setGtfsRealtimeNegativeArrivals(GtfsRealtimeNegativeArrivals _gtfsRealtimeNegativeArrivals) {
        this._gtfsRealtimeNegativeArrivals = _gtfsRealtimeNegativeArrivals;
    }

    @ManagedAttribute
    public int getStopTimesTotal() {
        return this._stopTimesTotal.intValue();
    }

    @ManagedAttribute
    public int getStopTimesWithPredictions() {
        return this._stopTimesWithPredictions.intValue();
    }

    public void setScheduleDeviationHistory(boolean useScheduleDeviationHistory) {
        this.useScheduleDeviationHistory = useScheduleDeviationHistory;
    }

    @Override
    public List<ArrivalAndDepartureBean> getArrivalsAndDeparturesByStopId(AgencyAndId stopId, ArrivalsAndDeparturesQueryBean query) {
        StopEntry stop = this._transitGraphDao.getStopEntryForId(stopId, true);
        long time = query.getTime();
        int minutesBefore = Math.max(query.getMinutesBefore(), query.getFrequencyMinutesBefore());
        int minutesAfter = Math.max(query.getMinutesAfter(), query.getFrequencyMinutesAfter());
        long fromTime = time - (long)(minutesBefore * 60 * 1000);
        long toTime = time + (long)(minutesAfter * 60 * 1000);
        long nonFrequencyFromTime = time - (long)(query.getMinutesBefore() * 60 * 1000);
        long nonFrequencyToTime = time + (long)(query.getMinutesAfter() * 60 * 1000);
        long frequencyFromTime = time - (long)(query.getFrequencyMinutesBefore() * 60 * 1000);
        long frequencyToTime = time + (long)(query.getFrequencyMinutesAfter() * 60 * 1000);
        TargetTime target = new TargetTime(time, time);
        List<ArrivalAndDepartureInstance> instances = this._arrivalAndDepartureService.getArrivalsAndDeparturesForStopInTimeRange(stop, target, fromTime, toTime);
        ArrayList<ArrivalAndDepartureBean> beans = new ArrayList<ArrivalAndDepartureBean>();
        HashMap<AgencyAndId, StopBean> stopBeanCache = new HashMap<AgencyAndId, StopBean>();
        for (ArrivalAndDepartureInstance instance : instances) {
            long to;
            String agency = instance.getBlockInstance().getBlock().getBlock().getId().getAgencyId();
            HashSet agenciesExcludingScheduled = query.getAgenciesExcludingScheduled();
            if (!instance.isPredictedArrivalTimeSet() && !instance.isPredictedDepartureTimeSet() && query.getAgenciesExcludingScheduled().contains(instance.getBlockInstance().getBlock().getBlock().getId().getAgencyId())) continue;
            FrequencyEntry frequency = instance.getFrequency();
            long from = frequency != null ? frequencyFromTime : nonFrequencyFromTime;
            long l = to = frequency != null ? frequencyToTime : nonFrequencyToTime;
            if (!this.isArrivalAndDepartureInRange(instance, from, to)) continue;
            ArrivalAndDepartureBean bean = this.getStopTimeInstanceAsBean(time, instance, stopBeanCache, query.getServiceInterval());
            this.applyBlockLocationToBean(instance, bean, time);
            Boolean isNegativeScheduledArrivalsEnabled = this._gtfsRealtimeNegativeArrivals.getShowNegativeScheduledArrivalByAgencyId(instance.getBlockTrip().getTrip().getId().getAgencyId());
            if (isNegativeScheduledArrivalsEnabled != null && !isNegativeScheduledArrivalsEnabled.booleanValue() && bean.getNumberOfStopsAway() < 0 && bean.getPredictedArrivalTime() <= 0L) continue;
            this.applySituationsToBean(time, instance, bean);
            if (!query.getSystemFilterChain().matches(bean) || !query.getInstanceFilterChain().matches(bean)) continue;
            beans.add(bean);
        }
        Collections.sort(beans, new ArrivalAndDepartureComparator());
        return beans;
    }

    @Override
    public ArrivalAndDepartureBean getArrivalAndDepartureForStop(ArrivalAndDepartureQuery query, AgencyServiceInterval serviceInterval) {
        long time = query.getTime();
        ArrivalAndDepartureInstance instance = this._arrivalAndDepartureService.getArrivalAndDepartureForStop(query);
        if (instance == null) {
            return null;
        }
        ArrivalAndDepartureBean bean = this.getStopTimeInstanceAsBean(time, instance, new HashMap<AgencyAndId, StopBean>(), serviceInterval);
        this.applyBlockLocationToBean(instance, bean, time);
        this.applySituationsToBean(time, instance, bean);
        boolean hideCanceled = this._arrivalAndDepartureService.getHideCanceledTrips();
        if (hideCanceled && "CANCELED".equals(bean.getStatus())) {
            return null;
        }
        if (!this.useScheduleDeviationHistory) {
            return bean;
        }
        int step = 120;
        ScheduleDeviationHistogram histo = this._realTimeHistoryService.getScheduleDeviationHistogramForArrivalAndDepartureInstance(instance, step);
        if (histo != null) {
            int[] sds = histo.getScheduleDeviations();
            double[] values = new double[sds.length];
            String[] labels = new String[sds.length];
            for (int i = 0; i < sds.length; ++i) {
                int sd = sds[i];
                values[i] = sd;
                labels[i] = Integer.toString(sd / 60);
            }
            HistogramBean hb = new HistogramBean();
            hb.setValues(values);
            hb.setCounts(histo.getCounts());
            hb.setLabels(labels);
            bean.setScheduleDeviationHistogram(hb);
        }
        return bean;
    }

    private ArrivalAndDepartureBean getStopTimeInstanceAsBean(long time, ArrivalAndDepartureInstance instance, Map<AgencyAndId, StopBean> stopBeanCache, AgencyServiceInterval serviceInterval) {
        List<HistoricalRidership> occ;
        StopBean stopBean;
        ArrivalAndDepartureBean pab = new ArrivalAndDepartureBean();
        pab.setServiceDate(instance.getServiceDate());
        BlockStopTimeEntry blockStopTime = instance.getBlockStopTime();
        BlockTripEntry blockTrip = blockStopTime.getTrip();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        StopEntry stop = stopTime.getStop();
        TripEntry trip = stopTime.getTrip();
        TripBean tripBean = this._tripBeanService.getTripForId(trip.getId());
        pab.setTrip(tripBean);
        pab.setBlockTripSequence((int)blockTrip.getSequence());
        pab.setArrivalEnabled(stopTime.getSequence() > 0);
        pab.setDepartureEnabled(stopTime.getSequence() + 1 < trip.getStopTimes().size());
        StopTimeNarrative stopTimeNarrative = this._narrativeService.getStopTimeForEntry(stopTime);
        if (stopTimeNarrative == null) {
            stopTimeNarrative = this._narrativeService.getStopTimeNarrativeForPattern(trip.getRoute().getId(), stop.getId(), trip.getDirectionId());
        }
        TripNarrative tripNarrative = this._narrativeService.getTripForId(trip.getId());
        if (stopTimeNarrative == null) {
            pab.setRouteShortName(tripNarrative.getRouteShortName());
            pab.setTripHeadsign(tripNarrative.getTripHeadsign());
        } else {
            if (tripNarrative != null) {
                pab.setRouteShortName(tripNarrative.getRouteShortName());
            } else {
                pab.setRouteShortName(stopTimeNarrative.getRouteShortName());
            }
            pab.setTripHeadsign(stopTimeNarrative.getStopHeadsign());
        }
        if (pab.getTrip() != null && pab.getTrip().getRoute() != null && pab.getTrip().getRoute().getShortName() == null) {
            pab.getTrip().setRoute(this.createRouteBean(pab, trip));
        }
        if ((stopBean = stopBeanCache.get(stop.getId())) == null) {
            stopBean = this._stopBeanService.getStopForId(stop.getId(), serviceInterval);
            stopBeanCache.put(stop.getId(), stopBean);
        }
        pab.setStop(stopBean);
        pab.setStopSequence(stopTime.getSequence());
        pab.setTotalStopsInTrip(stopTime.getTotalStopsInTrip());
        pab.setStatus("default");
        if (instance.getStatus() != null && instance.getStatus().length() > 0) {
            pab.setStatus(instance.getStatus());
        }
        pab.setScheduledArrivalTime(instance.getScheduledArrivalTime());
        pab.setScheduledDepartureTime(instance.getScheduledDepartureTime());
        pab.setActualTrack(instance.getActualTrack());
        pab.setScheduledTrack(instance.getScheduledTrack());
        FrequencyEntry frequency = instance.getFrequencyLabel();
        pab.setFrequency(null);
        if (frequency != null) {
            FrequencyBean fb = FrequencyBeanLibrary.getBeanForFrequency(instance.getServiceDate(), frequency);
            pab.setFrequency(fb);
        }
        if (this._ridershipService != null && (occ = this._ridershipService.getHistoricalRiderships(trip.getRoute().getId(), trip.getId(), stop.getId(), pab.getServiceDate())) != null && occ.size() > 0) {
            pab.setHistoricalOccupancy(OccupancyStatus.toEnum((double)occ.get(0).getLoadFactor()));
        }
        return pab;
    }

    private RouteBean createRouteBean(ArrivalAndDepartureBean pab, TripEntry trip) {
        RouteBean oldBean = pab.getTrip().getRoute();
        RouteBean.Builder trb = RouteBean.builder();
        trb.setAgency(oldBean.getAgency());
        trb.setId(oldBean.getId());
        if (pab.getRouteShortName() != null) {
            trb.setShortName(pab.getRouteShortName());
        } else {
            trb.setShortName(oldBean.getLongName());
        }
        trb.setLongName(oldBean.getLongName());
        trb.setType(oldBean.getType());
        trb.setColor(oldBean.getColor());
        trb.setTextColor(oldBean.getTextColor());
        RouteBean routeBean = trb.create();
        if (routeBean.getId() == null) {
            System.out.println("whoa!");
        }
        return routeBean;
    }

    private void applyBlockLocationToBean(ArrivalAndDepartureInstance instance, ArrivalAndDepartureBean bean, long targetTime) {
        TripStatusBean tripStatusBean;
        double distanceFromStop;
        boolean hasFrequency = instance.getFrequency() != null;
        boolean isCanceled = "CANCELED".equals(instance.getStatus());
        if (!isCanceled) {
            if (instance.isPredictedArrivalTimeSet()) {
                bean.setPredictedArrivalTime(instance.getPredictedArrivalTime());
                if (hasFrequency) {
                    bean.setScheduledArrivalTime(bean.getPredictedArrivalTime());
                }
            }
            if (instance.isPredictedDepartureTimeSet()) {
                bean.setPredictedDepartureTime(instance.getPredictedDepartureTime());
                if (hasFrequency) {
                    bean.setScheduledDepartureTime(bean.getPredictedDepartureTime());
                }
            }
        } else {
            bean.setStatus("CANCELED");
        }
        BlockStopTimeEntry stopTime = instance.getBlockStopTime();
        BlockLocation blockLocation = instance.getBlockLocation();
        if (blockLocation == null) {
            return;
        }
        if (!isCanceled) {
            bean.setPredicted(blockLocation.isPredicted());
        } else {
            bean.setPredicted(false);
        }
        if (blockLocation.isDistanceAlongBlockSet()) {
            distanceFromStop = stopTime.getDistanceAlongBlock() - blockLocation.getDistanceAlongBlock();
            bean.setDistanceFromStop(distanceFromStop);
        } else {
            distanceFromStop = stopTime.getDistanceAlongBlock() - blockLocation.getScheduledDistanceAlongBlock();
            bean.setDistanceFromStop(distanceFromStop);
        }
        if (blockLocation.getNextStop() != null) {
            BlockStopTimeEntry nextStopTime = blockLocation.getNextStop();
            bean.setNumberOfStopsAway(stopTime.getBlockSequence() - nextStopTime.getBlockSequence());
        }
        if (blockLocation.getLastUpdateTime() > 0L) {
            bean.setLastUpdateTime(Long.valueOf(blockLocation.getLastUpdateTime()));
        }
        if (blockLocation.getVehicleId() != null && !isCanceled) {
            VehicleOccupancyRecord vor;
            bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)blockLocation.getVehicleId()));
            if (this._vehicleOccupancyRecordCache != null && blockLocation.getActiveTrip() != null && (vor = this._vehicleOccupancyRecordCache.getRecordForVehicleIdAndRoute(AgencyAndIdLibrary.convertFromString((String)bean.getVehicleId()), blockLocation.getActiveTrip().getTrip().getRoute().getId().toString(), blockLocation.getActiveTrip().getTrip().getDirectionId())) != null) {
                bean.setOccupancyStatus(vor.getOccupancyStatus());
            }
        }
        if ("CANCELED".equals((tripStatusBean = this._tripDetailsBeanService.getBlockLocationAsStatusBean(blockLocation, targetTime)).getStatus())) {
            if (!this._arrivalAndDepartureService.getHideCanceledTrips()) {
                bean.setTripStatus(tripStatusBean);
            }
        } else {
            bean.setTripStatus(tripStatusBean);
        }
    }

    private void applySituationsToBean(long time, ArrivalAndDepartureInstance instance, ArrivalAndDepartureBean bean) {
        List<ServiceAlertBean> situations;
        BlockInstance blockInstance = instance.getBlockInstance();
        AgencyAndId vehicleId = null;
        BlockLocation blockLocation = instance.getBlockLocation();
        if (blockLocation != null) {
            vehicleId = blockLocation.getVehicleId();
        }
        if (!(situations = this._serviceAlertsBeanService.getServiceAlertsForStopCall(time, blockInstance, instance.getBlockStopTime(), vehicleId)).isEmpty()) {
            bean.setSituations(situations);
        }
    }

    private boolean isArrivalAndDepartureInRange(ArrivalAndDepartureInstance instance, long timeFrom, long timeTo) {
        if (timeFrom <= instance.getScheduledArrivalTime() && instance.getScheduledArrivalTime() <= timeTo) {
            return true;
        }
        if (timeFrom <= instance.getScheduledDepartureTime() && instance.getScheduledDepartureTime() <= timeTo) {
            return true;
        }
        if (instance.isPredictedArrivalTimeSet() && timeFrom <= instance.getPredictedArrivalTime() && instance.getPredictedArrivalTime() <= timeTo) {
            return true;
        }
        return instance.isPredictedDepartureTimeSet() && timeFrom <= instance.getPredictedDepartureTime() && instance.getPredictedDepartureTime() <= timeTo;
    }

    private static class ArrivalAndDepartureComparator
    implements Comparator<ArrivalAndDepartureBean> {
        private ArrivalAndDepartureComparator() {
        }

        @Override
        public int compare(ArrivalAndDepartureBean o1, ArrivalAndDepartureBean o2) {
            long t1 = o1.getScheduledArrivalTime();
            if (o1.hasPredictedArrivalTime()) {
                t1 = o1.getPredictedArrivalTime();
            }
            long t2 = o2.getScheduledArrivalTime();
            if (o2.hasPredictedArrivalTime()) {
                t2 = o2.getPredictedArrivalTime();
            }
            return (int)(t1 - t2);
        }
    }
}

