/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.TimeZone;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.transit_data.model.blocks.BlockBean;
import org.onebusaway.transit_data.model.blocks.BlockConfigurationBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.BlockStopTimeBean;
import org.onebusaway.transit_data.model.blocks.BlockTripBean;
import org.onebusaway.transit_data.model.blocks.ScheduledBlockLocationBean;
import org.onebusaway.transit_data.model.schedule.StopTimeBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.beans.BlockBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopTimeBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocationService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockBeanServiceImpl
implements BlockBeanService {
    private TransitGraphDao _graph;
    private TripBeanService _tripBeanService;
    private StopTimeBeanService _stopTimeBeanService;
    private BlockCalendarService _blockCalendarService;
    private ScheduledBlockLocationService _scheduledBlockLocationService;
    private AgencyService _agencyService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setTripBeanService(TripBeanService tripBeanService) {
        this._tripBeanService = tripBeanService;
    }

    @Autowired
    public void setStopTimeBeanService(StopTimeBeanService stopTimeBeanService) {
        this._stopTimeBeanService = stopTimeBeanService;
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setScheduledBlockLocationService(ScheduledBlockLocationService scheduledBlockLocationService) {
        this._scheduledBlockLocationService = scheduledBlockLocationService;
    }

    @Autowired
    public void setAgencyService(AgencyService agencyService) {
        this._agencyService = agencyService;
    }

    @Override
    @Cacheable
    public BlockBean getBlockForId(AgencyAndId blockId) {
        BlockEntry blockEntry = this._graph.getBlockEntryForId(blockId);
        if (blockEntry == null) {
            return null;
        }
        BlockBean bean = new BlockBean();
        bean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)blockEntry.getId()));
        ArrayList<BlockConfigurationBean> configBeans = new ArrayList<BlockConfigurationBean>();
        for (BlockConfigurationEntry blockConfiguration : blockEntry.getConfigurations()) {
            BlockConfigurationBean configBean = this.getBlockConfigurationAsBean(blockConfiguration);
            configBeans.add(configBean);
        }
        bean.setConfigurations(configBeans);
        return bean;
    }

    @Override
    public BlockTripBean getBlockTripAsBean(BlockTripEntry blockTrip) {
        TripEntry trip = blockTrip.getTrip();
        TripBean tripBean = this._tripBeanService.getTripForId(trip.getId());
        if (tripBean == null) {
            throw new IllegalStateException("unknown trip: " + trip.getId());
        }
        BlockTripBean bean = new BlockTripBean();
        bean.setTrip(tripBean);
        bean.setAccumulatedSlackTime(blockTrip.getAccumulatedSlackTime());
        bean.setDistanceAlongBlock(blockTrip.getDistanceAlongBlock());
        ArrayList<BlockStopTimeBean> blockStopTimes = new ArrayList<BlockStopTimeBean>();
        for (BlockStopTimeEntry blockStopTime : blockTrip.getStopTimes()) {
            BlockStopTimeBean blockStopTimeAsBean = this.getBlockStopTimeAsBean(blockStopTime);
            blockStopTimes.add(blockStopTimeAsBean);
        }
        bean.setBlockStopTimes(blockStopTimes);
        return bean;
    }

    @Override
    public BlockInstanceBean getBlockInstance(AgencyAndId blockId, long serviceDate) {
        BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(blockId, serviceDate);
        if (blockInstance == null) {
            return null;
        }
        return this.getBlockInstanceAsBean(blockInstance);
    }

    @Override
    public ScheduledBlockLocationBean getScheduledBlockLocationFromScheduledTime(AgencyAndId blockId, long serviceDate, int scheduledTime) {
        BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(blockId, serviceDate);
        if (blockInstance == null) {
            return null;
        }
        ScheduledBlockLocation blockLocation = this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockInstance.getBlock(), scheduledTime);
        if (blockLocation == null) {
            return null;
        }
        return this.getBlockLocationAsBean(blockLocation);
    }

    @Override
    public BlockInstanceBean getBlockInstanceAsBean(BlockInstance blockInstance) {
        BlockInstanceBean bean = new BlockInstanceBean();
        BlockConfigurationBean blockConfig = this.getBlockConfigurationAsBean(blockInstance.getBlock());
        bean.setBlockId(blockConfig.getBlockId());
        bean.setBlockConfiguration(blockConfig);
        long serviceDate = blockInstance.getServiceDate();
        bean.setServiceDate(serviceDate);
        return bean;
    }

    private ScheduledBlockLocationBean getBlockLocationAsBean(ScheduledBlockLocation blockLocation) {
        ScheduledBlockLocationBean bean = new ScheduledBlockLocationBean();
        if (blockLocation.getActiveTrip() != null) {
            BlockTripBean activeTrip = this.getBlockTripAsBean(blockLocation.getActiveTrip());
            bean.setActiveTrip(activeTrip);
        }
        bean.setDistanceAlongBlock(blockLocation.getDistanceAlongBlock());
        bean.setInService(blockLocation.isInService());
        bean.setLocation(blockLocation.getLocation());
        bean.setScheduledTime(blockLocation.getScheduledTime());
        bean.setStopTimeIndex(blockLocation.getStopTimeIndex());
        return bean;
    }

    private BlockConfigurationBean getBlockConfigurationAsBean(BlockConfigurationEntry blockConfiguration) {
        BlockConfigurationBean bean = new BlockConfigurationBean();
        ServiceIdActivation serviceIds = blockConfiguration.getServiceIds();
        AgencyAndId blockId = blockConfiguration.getBlock().getId();
        bean.setBlockId(AgencyAndIdLibrary.convertToString((AgencyAndId)blockId));
        ArrayList<String> activeServiceIds = new ArrayList<String>();
        for (LocalizedServiceId localizedServiceId : serviceIds.getActiveServiceIds()) {
            activeServiceIds.add(AgencyAndIdLibrary.convertToString((AgencyAndId)localizedServiceId.getId()));
        }
        bean.setActiveServiceIds(activeServiceIds);
        ArrayList<String> inactiveServiceIds = new ArrayList<String>();
        for (LocalizedServiceId localizedServiceId : serviceIds.getInactiveServiceIds()) {
            inactiveServiceIds.add(AgencyAndIdLibrary.convertToString((AgencyAndId)localizedServiceId.getId()));
        }
        bean.setInactiveServiceIds(inactiveServiceIds);
        ArrayList<BlockTripBean> arrayList = new ArrayList<BlockTripBean>();
        for (BlockTripEntry blockTrip : blockConfiguration.getTrips()) {
            arrayList.add(this.getBlockTripAsBean(blockTrip));
        }
        bean.setTrips(arrayList);
        TimeZone timeZone = this._agencyService.getTimeZoneForAgencyId(blockId.getAgencyId());
        bean.setTimeZone(timeZone.getID());
        return bean;
    }

    private BlockStopTimeBean getBlockStopTimeAsBean(BlockStopTimeEntry blockStopTime) {
        BlockStopTimeBean bean = new BlockStopTimeBean();
        bean.setAccumulatedSlackTime((double)blockStopTime.getAccumulatedSlackTime());
        bean.setBlockSequence(blockStopTime.getBlockSequence());
        bean.setDistanceAlongBlock(blockStopTime.getDistanceAlongBlock());
        StopTimeBean stopTimeAsBean = this._stopTimeBeanService.getStopTimeAsBean(blockStopTime.getStopTime());
        bean.setStopTime(stopTimeAsBean);
        return bean;
    }
}

