/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.MetricsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.bundle.RealtimeSourceServiceImpl;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.transit_data_federation.services.beans.MetricsBeanService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricsBeanServiceImpl
implements MetricsBeanService {
    @Autowired
    private TransitDataService _transitDataService;
    @Autowired
    private RealtimeSourceServiceImpl _sourceService;
    protected static Logger _log = LoggerFactory.getLogger(MetricsBeanServiceImpl.class);

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Autowired
    public void setRealtimeSourceServiceImpl(RealtimeSourceServiceImpl sourceService) {
        this._sourceService = sourceService;
    }

    protected List<MonitoredDataSource> getDataSources() {
        ArrayList<MonitoredDataSource> dataSources = new ArrayList<MonitoredDataSource>();
        for (GtfsRealtimeSource source : this._sourceService.getSources()) {
            if (!(source instanceof MonitoredDataSource)) continue;
            dataSources.add(source);
        }
        return dataSources;
    }

    @Override
    public MetricsBean getMetrics() {
        MetricsBean bean = new MetricsBean();
        this.populateAgencyFields(bean);
        this.populateStopFields(bean);
        this.populateRealtimeTripFields(bean);
        this.populateTotalRecordsFields(bean);
        bean.setScheduledTripsCount(this.getScheduledTrips());
        bean.setTimeSinceLastRealtimeUpdate(this.getLastUpdateDelta());
        return bean;
    }

    private void populateAgencyFields(MetricsBean bean) {
        List agencies = this._transitDataService.getAgenciesWithCoverage();
        bean.setAgenciesWithCoverageCount(agencies.size());
        ArrayList<String> agencyIDs = new ArrayList<String>();
        for (AgencyWithCoverageBean a : agencies) {
            agencyIDs.add(a.getAgency().getId());
        }
        bean.setAgencyIDs((String[])agencyIDs.toArray(String[]::new));
    }

    private void populateRealtimeTripFields(MetricsBean bean) {
        bean.setRealtimeTripIDsUnmatched(this.getRealtimeTripIDsUnmatched());
        bean.setRealtimeTripCountsUnmatched(this.getUnmatchedTripCounts());
        bean.setRealtimeTripCountsMatched(this.getRealtimeTripCountsMatched());
    }

    private HashMap<String, Integer> getScheduledTrips() {
        HashMap<String, Integer> tripCountMap = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            tripCountMap.put(id, this.getScheduledTrips(id, null));
        }
        return tripCountMap;
    }

    private int getScheduledTrips(String agencyId, String routeId) {
        HashSet<TripDetailsBean> agencyTrips = new HashSet<TripDetailsBean>();
        TripsForAgencyQueryBean query = new TripsForAgencyQueryBean();
        query.setAgencyId(agencyId);
        query.setMaxCount(Integer.MAX_VALUE);
        ListBean tripsForAgency = this._transitDataService.getTripsForAgency(query);
        if (tripsForAgency == null) {
            return 0;
        }
        AgencyAndId routeAndId = new AgencyAndId(agencyId, routeId);
        for (TripDetailsBean trip : tripsForAgency.getList()) {
            if (trip == null || trip.getTripId() == null || !trip.getTripId().startsWith(agencyId + "_") || routeId != null && !routeAndId.toString().equals(trip.getTrip().getRoute().getId())) continue;
            agencyTrips.add(trip);
        }
        _log.debug("scheduledTrips for (" + agencyId + ", " + routeId + "): " + agencyTrips.size() + " matched trips");
        return agencyTrips.size();
    }

    private HashMap<String, ArrayList<String>> getRealtimeTripIDsUnmatched() {
        HashMap<String, ArrayList<String>> unmatchedTrips = new HashMap<String, ArrayList<String>>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            unmatchedTrips.put(id, this.getUnmatchedTripIds(id, null));
        }
        return unmatchedTrips;
    }

    private ArrayList<String> getUnmatchedTripIds(String agencyId, String feedId) {
        try {
            ArrayList<String> unmatchedTripIds = new ArrayList<String>();
            List<MonitoredDataSource> dataSources = this.getDataSources();
            if (dataSources == null || dataSources.isEmpty()) {
                _log.error("no configured data sources");
                return new ArrayList<String>();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedTripIds.addAll(result.getUnmatchedTripIds());
                }
            }
            return unmatchedTripIds;
        }
        catch (Exception e) {
            _log.error("getUnmatchedTripIds broke", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private HashMap<String, Integer> getUnmatchedTripCounts() {
        HashMap<String, Integer> unmatchedTripCounts = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            unmatchedTripCounts.put(id, this.getUnmatchedTripIds(id, null).size());
        }
        return unmatchedTripCounts;
    }

    private void populateStopFields(MetricsBean bean) {
        bean.setStopIDsUnmatched(this.getUnmatchedStops());
        bean.setStopIDsUnmatchedCount(this.getUnmatchedStopIdsCount());
        bean.setStopIDsMatchedCount(this.getMatchedStopIdsCount());
    }

    private void populateTotalRecordsFields(MetricsBean bean) {
        bean.setRealtimeRecordsTotal(this.getTotalRecordsCounts());
    }

    private HashMap<String, Integer> getTotalRecordsCounts() {
        HashMap<String, Integer> totalRecordsCounts = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String agencyId = agency.getAgency().getId();
            int totalRecordsCount = this.getTotalRecordCount(agencyId, null);
            totalRecordsCounts.put(agencyId, totalRecordsCount);
        }
        return totalRecordsCounts;
    }

    private int getTotalRecordCount(String agencyId, String feedId) {
        int totalRecords = 0;
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
            for (String mAgencyId : result.getAgencyIds()) {
                if (!agencyId.equals(mAgencyId)) continue;
                totalRecords += result.getRecordsTotal();
            }
        }
        return totalRecords;
    }

    private HashMap<String, ArrayList<String>> getUnmatchedStops() {
        HashMap<String, ArrayList<String>> unmatchedStops = new HashMap<String, ArrayList<String>>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            unmatchedStops.put(id, this.getUnmatchedStopIds(id, null));
        }
        return unmatchedStops;
    }

    private ArrayList<String> getUnmatchedStopIds(String agencyId, String feedId) {
        try {
            ArrayList<String> unmatchedStopIds = new ArrayList<String>();
            List<MonitoredDataSource> dataSources = this.getDataSources();
            if (dataSources == null || dataSources.isEmpty()) {
                _log.error("no configured data sources");
                return new ArrayList<String>();
            }
            for (MonitoredDataSource mds : dataSources) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedStopIds.addAll(result.getUnmatchedStopIds());
                }
            }
            return unmatchedStopIds;
        }
        catch (Exception e) {
            _log.error("getUnmatchedStopIds broke", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private HashMap<String, Integer> getUnmatchedStopIdsCount() {
        HashMap<String, Integer> unmatchedStopIdsCountMap = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            unmatchedStopIdsCountMap.put(id, this.getUnmatchedStopsCount(id, null));
        }
        return unmatchedStopIdsCountMap;
    }

    private int getUnmatchedStopsCount(String agencyId, String feedId) {
        try {
            int unmatchedStops = 0;
            List<MonitoredDataSource> dataSources = this.getDataSources();
            if (dataSources == null || dataSources.isEmpty()) {
                _log.error("no configured data sources");
                return 0;
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    _log.debug("examining agency=" + mAgencyId + " with unmatched stops=" + result.getUnmatchedStopIds().size());
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedStops += result.getUnmatchedStopIds().size();
                }
            }
            return unmatchedStops;
        }
        catch (Exception e) {
            _log.error("getUnmatchedStops broke", (Throwable)e);
            return 0;
        }
    }

    private HashMap<String, Integer> getRealtimeTripCountsMatched() {
        HashMap<String, Integer> matchedTripCounts = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String agencyId = agency.getAgency().getId();
            int matchedTripCount = this.getValidRealtimeTripIds(agencyId, null).size();
            matchedTripCounts.put(agencyId, matchedTripCount);
        }
        return matchedTripCounts;
    }

    private List<String> getValidRealtimeTripIds(String agencyId, String feedId) {
        HashSet<String> tripIds = new HashSet<String>();
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId()) || agencyId == null) continue;
            for (String tripId : result.getMatchedTripIds()) {
                AgencyAndId matchedTripId;
                if (tripId == null || (matchedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(matchedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
            for (String tripId : result.getAddedTripIds()) {
                AgencyAndId addedTripId;
                if (tripId == null || (addedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(addedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
            for (String tripId : result.getDuplicatedTripIds()) {
                AgencyAndId duplicatedTripId;
                if (tripId == null || (duplicatedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(duplicatedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
        }
        return new ArrayList<String>(tripIds);
    }

    private HashMap<String, Integer> getMatchedStopIdsCount() {
        HashMap<String, Integer> matchedStopIdsCountMap = new HashMap<String, Integer>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            matchedStopIdsCountMap.put(id, this.getMatchedStopIdsList(id, null).size());
        }
        return matchedStopIdsCountMap;
    }

    private ArrayList<String> getMatchedStopIdsList(String agencyId, String feedId) {
        ArrayList<String> matchedStopIds = new ArrayList<String>();
        List<MonitoredDataSource> dataSources = this.getDataSources();
        try {
            if (dataSources == null || dataSources.isEmpty()) {
                _log.error("no configured data sources");
                return new ArrayList<String>();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    matchedStopIds.addAll(result.getMatchedStopIds());
                }
            }
            return matchedStopIds;
        }
        catch (Exception e) {
            _log.error("getMatchedStopCount broke", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private HashMap<String, Long> getLastUpdateDelta() {
        HashMap<String, Long> lastUpdateDelta = new HashMap<String, Long>();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            String id = agency.getAgency().getId();
            lastUpdateDelta.put(id, this.getLastUpdateDelta(id, null));
        }
        return lastUpdateDelta;
    }

    private Long getLastUpdateDelta(String agencyId, String feedId) {
        long lastUpdate = 0L;
        try {
            List<MonitoredDataSource> dataSources = this.getDataSources();
            if (dataSources == null || dataSources.isEmpty()) {
                throw new Exception("no configured data sources");
            }
            for (MonitoredDataSource mds : dataSources) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    lastUpdate += result.getLastUpdate();
                }
            }
        }
        catch (Exception e) {
            _log.error("getLastUpdateDelta broke", (Throwable)e);
            lastUpdate = 0L;
        }
        return (SystemTime.currentTimeMillis() - lastUpdate) / 1000L;
    }
}

