/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.NameBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data_federation.impl.DirectedGraph;
import org.onebusaway.transit_data_federation.impl.ServiceIntervalHelper;
import org.onebusaway.transit_data_federation.impl.StopGraphComparator;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.impl.beans.StopBeanIdComparator;
import org.onebusaway.transit_data_federation.model.StopSequence;
import org.onebusaway.transit_data_federation.model.StopSequenceCollection;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.RouteService;
import org.onebusaway.transit_data_federation.services.StopSequenceCollectionService;
import org.onebusaway.transit_data_federation.services.StopSequencesService;
import org.onebusaway.transit_data_federation.services.beans.AgencyBeanService;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.ShapeBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RouteBeanServiceImpl
implements RouteBeanService {
    private TransitGraphDao _transitGraphDao;
    private NarrativeService _narrativeService;
    private AgencyBeanService _agencyBeanService;
    private StopBeanService _stopBeanService;
    private ShapeBeanService _shapeBeanService;
    private RouteService _routeService;
    private StopSequencesService _stopSequencesService;
    private StopSequenceCollectionService _stopSequenceBlocksService;
    private BlockIndexService _blockIndexService;
    private CalendarService _calendarService;
    private ExtendedCalendarService _extCalendarService;
    private ServiceIntervalHelper _helper = new ServiceIntervalHelper();
    private List<String> _doNotSortRouteIdList = new ArrayList<String>();

    RouteBeanServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setAgencyBeanService(AgencyBeanService agencyBeanService) {
        this._agencyBeanService = agencyBeanService;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setShapeBeanService(ShapeBeanService shapeBeanService) {
        this._shapeBeanService = shapeBeanService;
    }

    @Autowired
    public void setRouteService(RouteService routeService) {
        this._routeService = routeService;
    }

    @Autowired
    public void setStopSequencesLibrary(StopSequencesService service) {
        this._stopSequencesService = service;
    }

    @Autowired
    public void setStopSequencesBlocksService(StopSequenceCollectionService stopSequenceBlocksService) {
        this._stopSequenceBlocksService = stopSequenceBlocksService;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setExtCalendarService(ExtendedCalendarService extCalendarService) {
        this._extCalendarService = extCalendarService;
    }

    public void setDoNotSortRouteIdList(String doNotSortRouteIds) {
        if (doNotSortRouteIds == null) {
            this._doNotSortRouteIdList = new ArrayList<String>();
        } else if (!doNotSortRouteIds.contains(",")) {
            this._doNotSortRouteIdList = new ArrayList<String>();
            this._doNotSortRouteIdList.add(doNotSortRouteIds);
        } else {
            this._doNotSortRouteIdList = Arrays.asList(doNotSortRouteIds.split(","));
        }
    }

    @Override
    @Cacheable
    public RouteBean getRouteForId(AgencyAndId id) {
        RouteCollectionNarrative rc = this._narrativeService.getRouteCollectionForId(id);
        if (rc == null) {
            return null;
        }
        return this.getRouteBeanForRouteCollection(id, rc);
    }

    @Override
    @Cacheable
    public StopsForRouteBean getStopsForRoute(AgencyAndId routeId) {
        RouteCollectionEntry routeCollectionEntry = this._transitGraphDao.getRouteCollectionForId(routeId);
        RouteCollectionNarrative narrative = this._narrativeService.getRouteCollectionForId(routeId);
        if (routeCollectionEntry == null || narrative == null) {
            return null;
        }
        return this.getStopsForRouteCollectionAndNarrative(routeCollectionEntry, narrative, null);
    }

    @Override
    @Cacheable
    public StopsForRouteBean getStopsForRouteForServiceInterval(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        RouteCollectionEntry routeCollectionEntry = this._transitGraphDao.getRouteCollectionForId(routeId);
        RouteCollectionNarrative narrative = this._narrativeService.getRouteCollectionForId(routeId);
        if (routeCollectionEntry == null || narrative == null) {
            return null;
        }
        return this.getStopsForRouteCollectionAndNarrative(routeCollectionEntry, narrative, serviceInterval);
    }

    private RouteBean getRouteBeanForRouteCollection(AgencyAndId id, RouteCollectionNarrative rc) {
        RouteBean.Builder bean = RouteBean.builder();
        bean.setId(ApplicationBeanLibrary.getId(id));
        bean.setShortName(rc.getShortName());
        bean.setLongName(rc.getLongName());
        bean.setColor(rc.getColor());
        bean.setDescription(rc.getDescription());
        bean.setTextColor(rc.getTextColor());
        bean.setType(rc.getType());
        bean.setUrl(rc.getUrl());
        AgencyBean agency = this._agencyBeanService.getAgencyForId(id.getAgencyId());
        bean.setAgency(agency);
        return bean.create();
    }

    private List<StopBean> getStopBeansForRoute(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        Collection<AgencyAndId> stopIds = serviceInterval == null ? this._routeService.getStopsForRouteCollection(routeId) : this._routeService.getStopsForRouteCollectionForServiceInterval(routeId, serviceInterval);
        ArrayList<StopBean> stops = new ArrayList<StopBean>();
        for (AgencyAndId stopId : stopIds) {
            StopBean stop = this._stopBeanService.getStopForId(stopId, serviceInterval);
            stops.add(stop);
        }
        return stops;
    }

    private StopsForRouteBean getStopsForRouteCollectionAndNarrative(RouteCollectionEntry routeCollection, RouteCollectionNarrative narrative, AgencyServiceInterval serviceInterval) {
        StopsForRouteBean result = new StopsForRouteBean();
        AgencyAndId routeCollectionId = routeCollection.getId();
        result.setRoute(this.getRouteBeanForRouteCollection(routeCollectionId, narrative));
        result.setStops(this.getStopBeansForRoute(routeCollectionId, serviceInterval));
        result.setPolylines(this.getEncodedPolylinesForRoute(routeCollection, serviceInterval));
        StopGroupingBean directionGrouping = new StopGroupingBean();
        directionGrouping.setType("direction");
        ArrayList<StopGroupBean> directionGroups = new ArrayList<StopGroupBean>();
        directionGrouping.setStopGroups(directionGroups);
        directionGrouping.setOrdered(true);
        result.addGrouping(directionGrouping);
        List<BlockTripIndex> blockIndices = this._blockIndexService.getBlockTripIndicesForRouteCollectionId(routeCollectionId);
        List<FrequencyBlockTripIndex> frequencyBlockIndices = this._blockIndexService.getFrequencyBlockTripIndicesForRouteCollectionId(routeCollectionId);
        ArrayList<BlockTripEntry> blockTripsUnfiltered = new ArrayList<BlockTripEntry>();
        ArrayList<BlockTripEntry> blockTrips = new ArrayList<BlockTripEntry>();
        this.getBlockTripsForIndicesMatchingRouteCollection(blockIndices, routeCollectionId, blockTripsUnfiltered);
        this.getBlockTripsForIndicesMatchingRouteCollection(frequencyBlockIndices, routeCollectionId, blockTripsUnfiltered);
        if (serviceInterval == null) {
            blockTrips.addAll(blockTripsUnfiltered);
        } else {
            for (BlockTripEntry blockTrip : blockTripsUnfiltered) {
                ServiceIdActivation serviceIds = blockTrip.getBlockConfiguration().getServiceIds();
                for (LocalizedServiceId activeServiceId : serviceIds.getActiveServiceIds()) {
                    ServiceInterval scheduledService = this._helper.getServiceIntervalForTrip(blockTrip);
                    boolean isActiveTrip = this._blockIndexService.isDynamicTrip(blockTrip.getTrip()) ? this._helper.isServiceIntervalActiveInRange(activeServiceId, scheduledService, serviceInterval) : this._calendarService.isLocalizedServiceIdActiveInRange(activeServiceId, scheduledService, serviceInterval);
                    if (!isActiveTrip) continue;
                    blockTrips.add(blockTrip);
                }
            }
        }
        List<StopSequence> sequences = this._stopSequencesService.getStopSequencesForTrips(blockTrips);
        List<StopSequenceCollection> blocks = this._stopSequenceBlocksService.getStopSequencesAsCollections(sequences);
        for (StopSequenceCollection block : blocks) {
            NameBean name = new NameBean("destination", new String[]{block.getDescription()});
            List<StopEntry> stops = this.getStopsInOrder(routeCollection.getId(), block);
            ArrayList<String> groupStopIds = new ArrayList<String>();
            for (StopEntry stop : stops) {
                groupStopIds.add(ApplicationBeanLibrary.getId(stop.getId()));
            }
            Set<AgencyAndId> shapeIds = this.getShapeIdsForStopSequenceBlock(block);
            List<EncodedPolylineBean> polylines = this._shapeBeanService.getMergedPolylinesForShapeIds(shapeIds);
            StopGroupBean group = new StopGroupBean();
            group.setId(block.getPublicId());
            group.setName(name);
            group.setStopIds(groupStopIds);
            group.setPolylines(polylines);
            directionGroups.add(group);
        }
        this.sortResult(result);
        return result;
    }

    private <T extends AbstractBlockTripIndex> void getBlockTripsForIndicesMatchingRouteCollection(List<T> blockIndices, AgencyAndId routeCollectionId, List<BlockTripEntry> resultingTrips) {
        for (AbstractBlockTripIndex blockIndex : blockIndices) {
            for (BlockTripEntry blockTrip : blockIndex.getTrips()) {
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId rcId = trip.getRouteCollection().getId();
                if (!rcId.equals((Object)routeCollectionId)) continue;
                resultingTrips.add(blockTrip);
            }
        }
    }

    private List<EncodedPolylineBean> getEncodedPolylinesForRoute(RouteCollectionEntry routeCollection, AgencyServiceInterval serviceInterval) {
        HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
        for (RouteEntry route : routeCollection.getChildren()) {
            for (TripEntry trip : route.getTrips()) {
                if (trip.getShapeId() == null) continue;
                if (serviceInterval == null) {
                    shapeIds.add(trip.getShapeId());
                    continue;
                }
                ServiceInterval scheduledService = this._helper.getServiceIntervalForTrip(trip);
                boolean isActiveTrip = this._blockIndexService.isDynamicTrip(trip) ? this._helper.isServiceIntervalActiveInRange(trip.getServiceId(), scheduledService, serviceInterval) : this._calendarService.isLocalizedServiceIdActiveInRange(trip.getServiceId(), scheduledService, serviceInterval);
                if (!isActiveTrip) continue;
                shapeIds.add(trip.getShapeId());
            }
        }
        return this._shapeBeanService.getMergedPolylinesForShapeIds(shapeIds);
    }

    private List<StopEntry> getStopsInOrder(AgencyAndId routeId, StopSequenceCollection block) {
        ArrayList<StopEntry> stopsInDefaultOrder = new ArrayList<StopEntry>();
        DirectedGraph<StopEntry> graph = new DirectedGraph<StopEntry>();
        for (StopSequence sequence : block.getStopSequences()) {
            StopEntry prev = null;
            for (StopEntry stop : sequence.getStops()) {
                if (prev != null && !graph.isConnected(stop, prev)) {
                    graph.addEdge(prev, stop);
                    stopsInDefaultOrder.add(stop);
                }
                prev = stop;
            }
        }
        if (this._doNotSortRouteIdList.contains(routeId.toString())) {
            return stopsInDefaultOrder;
        }
        StopGraphComparator c = new StopGraphComparator(graph);
        return graph.getTopologicalSort(c);
    }

    private Set<AgencyAndId> getShapeIdsForStopSequenceBlock(StopSequenceCollection block) {
        HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
        for (StopSequence sequence : block.getStopSequences()) {
            for (BlockTripEntry blockTrip : sequence.getTrips()) {
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId shapeId = trip.getShapeId();
                if (shapeId == null || !shapeId.hasValues()) continue;
                shapeIds.add(shapeId);
            }
        }
        return shapeIds;
    }

    private void sortResult(StopsForRouteBean result) {
        Collections.sort(result.getStops(), new StopBeanIdComparator());
        Collections.sort(result.getStopGroupings(), new Comparator<StopGroupingBean>(){

            @Override
            public int compare(StopGroupingBean o1, StopGroupingBean o2) {
                return o1.getType().compareTo(o2.getType());
            }
        });
        for (StopGroupingBean grouping : result.getStopGroupings()) {
            Collections.sort(grouping.getStopGroups(), new Comparator<StopGroupBean>(){

                @Override
                public int compare(StopGroupBean o1, StopGroupBean o2) {
                    return this.getName(o1).compareTo(this.getName(o2));
                }

                private String getName(StopGroupBean bean) {
                    StringBuilder b = new StringBuilder();
                    for (String name : bean.getName().getNames()) {
                        b.append(name);
                    }
                    return b.toString();
                }
            });
        }
    }
}

