/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.lucene.queryparser.classic.ParseException;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.exceptions.InvalidArgumentServiceException;
import org.onebusaway.exceptions.NoSuchAgencyServiceException;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data_federation.impl.beans.BeanServiceSupport;
import org.onebusaway.transit_data_federation.impl.beans.RouteBeanIdComparator;
import org.onebusaway.transit_data_federation.model.SearchResult;
import org.onebusaway.transit_data_federation.services.RouteCollectionSearchService;
import org.onebusaway.transit_data_federation.services.RouteService;
import org.onebusaway.transit_data_federation.services.beans.GeospatialBeanService;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.RoutesBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.transit_graph.AgencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RoutesBeanServiceImpl
implements RoutesBeanService {
    private static Logger _log = LoggerFactory.getLogger(RoutesBeanServiceImpl.class);
    @Autowired
    private RouteService _routeService;
    @Autowired
    private RouteCollectionSearchService _searchService;
    @Autowired
    private GeospatialBeanService _whereGeospatialService;
    @Autowired
    private RouteBeanService _routeBeanService;
    @Autowired
    private StopBeanService _stopService;
    @Autowired
    private TransitGraphDao _graphDao;
    private Map<AgencyAndId, STRtree> _stopTreesByRouteId = new HashMap<AgencyAndId, STRtree>();

    RoutesBeanServiceImpl() {
    }

    @Refreshable(dependsOn={"narrativeData"})
    @PostConstruct
    public synchronized void setup() {
        this._stopTreesByRouteId.clear();
        for (StopEntry stop : this._graphDao.getAllStops()) {
            Set<AgencyAndId> routeIds = this._routeService.getRouteCollectionIdsForStop(stop.getId());
            for (AgencyAndId routeId : routeIds) {
                STRtree tree = this._stopTreesByRouteId.get(routeId);
                if (tree == null) {
                    tree = new STRtree();
                    this._stopTreesByRouteId.put(routeId, tree);
                }
                double x = stop.getStopLon();
                double y = stop.getStopLat();
                Envelope env = new Envelope(x, x, y, y);
                tree.insert(env, (Object)routeId);
            }
        }
        for (STRtree tree : this._stopTreesByRouteId.values()) {
            tree.build();
        }
    }

    @Override
    public RoutesBean getRoutesForQuery(SearchQueryBean query) throws ServiceException {
        if (query.getQuery() != null) {
            return this.getRoutesWithRouteNameQuery(query);
        }
        return this.getRoutesWithoutRouteNameQuery(query);
    }

    @Override
    @Cacheable
    public ListBean<String> getRouteIdsForAgencyId(String agencyId) {
        AgencyEntry agency = this._graphDao.getAgencyForId(agencyId);
        if (agency == null) {
            throw new NoSuchAgencyServiceException(agencyId);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (RouteCollectionEntry routeCollection : agency.getRouteCollections()) {
            AgencyAndId id = routeCollection.getId();
            ids.add(AgencyAndIdLibrary.convertToString((AgencyAndId)id));
        }
        return new ListBean(ids, false);
    }

    @Override
    @Cacheable
    public ListBean<RouteBean> getRoutesForAgencyId(String agencyId) {
        AgencyEntry agency = this._graphDao.getAgencyForId(agencyId);
        if (agency == null) {
            throw new NoSuchAgencyServiceException(agencyId);
        }
        ArrayList<RouteBean> routes = new ArrayList<RouteBean>();
        for (RouteCollectionEntry routeCollection : agency.getRouteCollections()) {
            AgencyAndId routeId = routeCollection.getId();
            RouteBean route = this._routeBeanService.getRouteForId(routeId);
            routes.add(route);
        }
        return new ListBean(routes, false);
    }

    private RoutesBean getRoutesWithoutRouteNameQuery(SearchQueryBean query) {
        CoordinateBounds bounds = query.getBounds();
        List<AgencyAndId> stops = this._whereGeospatialService.getStopsByBounds(bounds);
        HashSet routes = new HashSet();
        for (AgencyAndId stopId : stops) {
            StopBean stop = this._stopService.getStopForId(stopId, null);
            routes.addAll(stop.getRoutes());
        }
        ArrayList<RouteBean> routeBeans = new ArrayList<RouteBean>(routes);
        boolean limitExceeded = BeanServiceSupport.checkLimitExceeded(routeBeans, query.getMaxCount());
        return this.constructResult(routeBeans, limitExceeded);
    }

    private RoutesBean getRoutesWithRouteNameQuery(SearchQueryBean query) throws ServiceException {
        SearchResult<AgencyAndId> result = this.searchForRoutes(query);
        ArrayList<RouteBean> routeBeans = new ArrayList<RouteBean>();
        CoordinateBounds bounds = query.getBounds();
        for (AgencyAndId id : result.getResults()) {
            STRtree tree = this._stopTreesByRouteId.get(id);
            if (tree == null) {
                _log.warn("stop tree not found for routeId=" + id);
                continue;
            }
            Envelope env = new Envelope(bounds.getMinLon(), bounds.getMaxLon(), bounds.getMinLat(), bounds.getMaxLat());
            HasItemsVisitor v = new HasItemsVisitor();
            tree.query(env, (ItemVisitor)v);
            if (!v.hasItems()) continue;
            RouteBean routeBean = this._routeBeanService.getRouteForId(id);
            routeBeans.add(routeBean);
        }
        boolean limitExceeded = BeanServiceSupport.checkLimitExceeded(routeBeans, query.getMaxCount());
        return this.constructResult(routeBeans, limitExceeded);
    }

    private SearchResult<AgencyAndId> searchForRoutes(SearchQueryBean query) throws ServiceException, InvalidArgumentServiceException {
        try {
            return this._searchService.searchForRoutesByName(query.getQuery(), query.getMaxCount() + 1, query.getMinScoreToKeep());
        }
        catch (IOException e) {
            throw new ServiceException();
        }
        catch (ParseException e) {
            throw new InvalidArgumentServiceException("query", "queryParseError");
        }
    }

    private RoutesBean constructResult(List<RouteBean> routeBeans, boolean limitExceeded) {
        Collections.sort(routeBeans, new RouteBeanIdComparator());
        RoutesBean result = new RoutesBean();
        result.setRoutes(routeBeans);
        result.setLimitExceeded(limitExceeded);
        return result;
    }

    private static class HasItemsVisitor
    implements ItemVisitor {
        private boolean _hasItems = false;

        private HasItemsVisitor() {
        }

        public boolean hasItems() {
            return this._hasItems;
        }

        public void visitItem(Object arg0) {
            this._hasItems = true;
        }
    }
}

