/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.alerts.impl.ServiceAlertBeanHelper;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.service.ServiceAlertsService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertRecordBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ServiceAlertsBeanServiceImpl
implements ServiceAlertsBeanService {
    private ServiceAlertsService _serviceAlertsService;

    ServiceAlertsBeanServiceImpl() {
    }

    @Autowired
    public void setServiceAlertsService(ServiceAlertsService serviceAlertsService) {
        this._serviceAlertsService = serviceAlertsService;
    }

    @Override
    public ServiceAlertBean createServiceAlert(String agencyId, ServiceAlertBean situationBean) {
        ServiceAlertRecord serviceAlertRecord = ServiceAlertBeanHelper.getServiceAlertRecordFromServiceAlertBean((ServiceAlertBean)situationBean, (String)agencyId);
        serviceAlertRecord = this._serviceAlertsService.createOrUpdateServiceAlert(serviceAlertRecord);
        return ServiceAlertBeanHelper.getServiceAlertAsBean((ServiceAlertRecord)serviceAlertRecord);
    }

    @Override
    public void updateServiceAlert(ServiceAlertBean situationBean) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)situationBean.getId());
        ServiceAlertRecord serviceAlertRecord = ServiceAlertBeanHelper.getServiceAlertRecordFromServiceAlertBean((ServiceAlertBean)situationBean, (String)id.getAgencyId());
        ServiceAlertRecord dbServiceAlertRecord = this._serviceAlertsService.getServiceAlertForId(id);
        if (dbServiceAlertRecord != null) {
            serviceAlertRecord.setCopy(dbServiceAlertRecord.isCopy());
        }
        this._serviceAlertsService.createOrUpdateServiceAlert(serviceAlertRecord);
    }

    @Override
    public ServiceAlertBean copyServiceAlert(String agencyId, ServiceAlertBean situationBeanToCopy) {
        situationBeanToCopy.setId(null);
        ServiceAlertRecord serviceAlertRecordCopy = ServiceAlertBeanHelper.getServiceAlertRecordFromServiceAlertBean((ServiceAlertBean)situationBeanToCopy, (String)agencyId);
        serviceAlertRecordCopy = this._serviceAlertsService.copyServiceAlert(serviceAlertRecordCopy);
        return ServiceAlertBeanHelper.getServiceAlertAsBean((ServiceAlertRecord)serviceAlertRecordCopy);
    }

    @Override
    public void removeServiceAlert(AgencyAndId situationId) {
        this._serviceAlertsService.removeServiceAlert(situationId);
    }

    @Override
    public ServiceAlertBean getServiceAlertForId(AgencyAndId situationId) {
        ServiceAlertRecord serviceAlert = this._serviceAlertsService.getServiceAlertForId(situationId);
        if (serviceAlert == null) {
            return null;
        }
        return ServiceAlertBeanHelper.getServiceAlertAsBean((ServiceAlertRecord)serviceAlert);
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForFederatedAgencyId(String agencyId) {
        List serviceAlerts = this._serviceAlertsService.getServiceAlertsForFederatedAgencyId(agencyId);
        return ServiceAlertBeanHelper.list((List)serviceAlerts);
    }

    @Override
    public List<ServiceAlertRecordBean> getServiceAlertRecordsForFederatedAgencyId(String agencyId) {
        List serviceAlerts = this._serviceAlertsService.getServiceAlertsForFederatedAgencyId(agencyId);
        return ServiceAlertBeanHelper.listRecordBeans((List)serviceAlerts);
    }

    @Override
    public void removeAllServiceAlertsForFederatedAgencyId(String agencyId) {
        this._serviceAlertsService.removeAllServiceAlertsForFederatedAgencyId(agencyId);
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForStopId(long time, AgencyAndId stopId) {
        List serviceAlerts = this._serviceAlertsService.getServiceAlertsForStopId(time, stopId);
        return ServiceAlertBeanHelper.list((List)serviceAlerts);
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForStopCall(long time, BlockInstance blockInstance, BlockStopTimeEntry blockStopTime, AgencyAndId vehicleId) {
        HashSet alerts = new HashSet();
        BlockTripEntry blockTrip = blockStopTime.getTrip();
        TripEntry trip = blockTrip.getTrip();
        AgencyAndId tripId = trip.getId();
        AgencyAndId lineId = trip.getRouteCollection().getId();
        String directionId = trip.getDirectionId();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        StopEntry stop = stopTime.getStop();
        AgencyAndId stopId = stop.getId();
        HashSet serviceAlertIds = new HashSet();
        alerts.addAll(this._serviceAlertsService.getServiceAlertsForRouteId(time, lineId));
        alerts.addAll(this._serviceAlertsService.getServiceAlertsForRouteAndStopId(time, lineId, stopId));
        if (directionId != null) {
            alerts.addAll(this._serviceAlertsService.getServiceAlertsForRouteAndDirection(time, lineId, stopId, directionId));
        }
        alerts.addAll(this._serviceAlertsService.getServiceAlertsForTripAndStopId(time, tripId, stopId));
        return ServiceAlertBeanHelper.list(new ArrayList(alerts));
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForVehicleJourney(long time, BlockTripInstance blockTripInstance, AgencyAndId vehicleId) {
        HashSet alerts = new HashSet();
        BlockTripEntry blockTrip = blockTripInstance.getBlockTrip();
        TripEntry trip = blockTrip.getTrip();
        AgencyAndId lineId = trip.getRouteCollection().getId();
        alerts.addAll(this._serviceAlertsService.getServiceAlertsForRouteAndDirection(time, lineId, trip.getId(), trip.getDirectionId()));
        return ServiceAlertBeanHelper.list(new ArrayList(alerts));
    }

    @Override
    public List<ServiceAlertBean> getServiceAlerts(SituationQueryBean query) {
        List serviceAlerts = this._serviceAlertsService.getServiceAlerts(query);
        return ServiceAlertBeanHelper.list((List)serviceAlerts);
    }
}

