/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.services.ConsolidatedStopsService;
import org.onebusaway.transit_data_federation.services.RouteService;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.text.NaturalStringOrder;
import org.onebusaway.utility.text.StringLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopBeanServiceImpl
implements StopBeanService {
    private static RouteBeanComparator _routeBeanComparator = new RouteBeanComparator();
    private TransitGraphDao _transitGraphDao;
    private RouteService _routeService;
    private RouteBeanService _routeBeanService;
    private NarrativeService _narrativeService;
    private ConsolidatedStopsService _consolidatedStopsService;

    StopBeanServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setRouteService(RouteService routeService) {
        this._routeService = routeService;
    }

    @Autowired
    public void setRouteBeanService(RouteBeanService routeBeanService) {
        this._routeBeanService = routeBeanService;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setConsolidatedStopsService(ConsolidatedStopsService consolidatedStopsService) {
        this._consolidatedStopsService = consolidatedStopsService;
    }

    @Override
    @Cacheable
    public StopBean getStopForId(AgencyAndId id, AgencyServiceInterval serviceInterval) {
        return this.getStopForIdForServiceDate(id, serviceInterval);
    }

    @Override
    public boolean matchesRouteTypeFilter(RouteBean route, List<Integer> routeTypesFilter) {
        if (routeTypesFilter == null || routeTypesFilter.isEmpty()) {
            return true;
        }
        for (Integer routeType : routeTypesFilter) {
            if (routeType.intValue() != route.getType()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Cacheable
    public StopBean getStopForIdForServiceDate(AgencyAndId id, AgencyServiceInterval serviceInterval) {
        StopEntry stop = this._transitGraphDao.getStopEntryForId(id);
        StopNarrative narrative = this._narrativeService.getStopForId(id);
        if (stop == null) {
            AgencyAndId consolidatedId = this._consolidatedStopsService.getConsolidatedStopIdForHiddenStopId(id);
            if (consolidatedId != null) {
                return this.getStopForId(consolidatedId, serviceInterval);
            }
            throw new NoSuchStopServiceException(AgencyAndIdLibrary.convertToString((AgencyAndId)id));
        }
        StopBean sb = new StopBean();
        this.fillStopBean(stop, narrative, sb);
        if (stop.getParent() != null) {
            AgencyAndId parentId = stop.getParent();
            StopBean parentBean = new StopBean();
            StopNarrative parentNarrative = this._narrativeService.getStopForId(parentId);
            StopEntry parent = this._transitGraphDao.getStopEntryForId(parentId);
            this.fillStopBean(parent, parentNarrative, parentBean);
            this.fillRoutesForStopBean(parent, parentBean, serviceInterval);
            sb.setParent(parentBean);
        }
        this.fillRoutesForStopBean(stop, sb, serviceInterval);
        this.fillTransfersForStopBean(stop, narrative, sb);
        return sb;
    }

    private void fillTransfersForStopBean(StopEntry stop, StopNarrative narrative, StopBean bean) {
        List<AgencyAndId> staticRoutes = this._narrativeService.getStaticRoutes(stop.getId());
        if (staticRoutes == null) {
            bean.setStaticRoutes(bean.getRoutes());
            return;
        }
        ArrayList<RouteBean> routeBeans = new ArrayList<RouteBean>(staticRoutes.size());
        for (AgencyAndId routeId : staticRoutes) {
            RouteBean staticRouteBean = this._routeBeanService.getRouteForId(routeId);
            routeBeans.add(staticRouteBean);
        }
        bean.setStaticRoutes(routeBeans);
    }

    private void fillRoutesForStopBean(StopEntry stop, StopBean sb, AgencyServiceInterval serviceInterval) {
        Set<AgencyAndId> routeCollectionIds = serviceInterval != null ? this._routeService.getRouteCollectionIdsForStopForServiceDate(stop.getId(), serviceInterval) : this._routeService.getRouteCollectionIdsForStop(stop.getId());
        ArrayList<RouteBean> routeBeans = new ArrayList<RouteBean>(routeCollectionIds.size());
        for (AgencyAndId routeCollectionId : routeCollectionIds) {
            RouteBean bean = this._routeBeanService.getRouteForId(routeCollectionId);
            routeBeans.add(bean);
        }
        Collections.sort(routeBeans, _routeBeanComparator);
        sb.setRoutes(routeBeans);
    }

    private void fillStopBean(StopEntry stop, StopNarrative narrative, StopBean bean) {
        bean.setId(ApplicationBeanLibrary.getId(stop.getId()));
        bean.setLat(stop.getStopLat());
        bean.setLon(stop.getStopLon());
        bean.setName(narrative.getName());
        bean.setCode(StringLibrary.getBestName((String[])new String[]{narrative.getCode(), stop.getId().getId()}));
        bean.setLocationType(narrative.getLocationType());
        bean.setDirection(narrative.getDirection());
        bean.setWheelchairBoarding(stop.getWheelchairBoarding());
    }

    private static String getRouteBeanName(RouteBean bean) {
        return bean.getShortName() == null ? bean.getLongName() : bean.getShortName();
    }

    private static class RouteBeanComparator
    implements Comparator<RouteBean> {
        private RouteBeanComparator() {
        }

        @Override
        public int compare(RouteBean o1, RouteBean o2) {
            String name1 = StopBeanServiceImpl.getRouteBeanName(o1);
            String name2 = StopBeanServiceImpl.getRouteBeanName(o2);
            return NaturalStringOrder.compareNatural((String)name1, (String)name2);
        }
    }
}

