/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.onebusaway.collections.Counter;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopCalendarDayBean;
import org.onebusaway.transit_data.model.StopCalendarDaysBean;
import org.onebusaway.transit_data.model.StopRouteDirectionScheduleBean;
import org.onebusaway.transit_data.model.StopRouteScheduleBean;
import org.onebusaway.transit_data.model.StopTimeGroupBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBean;
import org.onebusaway.transit_data.model.schedule.FrequencyInstanceBean;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopScheduleBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyBlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.text.NaturalStringOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopScheduleBeanServiceImpl
implements StopScheduleBeanService {
    private static final int DEFAULT_CONTINUES_AS_THRESHOLD = 420;
    private static StopTimeBeanComparator _stopTimeComparator = new StopTimeBeanComparator();
    private static FrequencyBeanComparator _frequencyComparator = new FrequencyBeanComparator();
    private static DirectionComparator _directionComparator = new DirectionComparator();
    private static StopRouteScheduleBeanComparator _stopRouteScheduleComparator = new StopRouteScheduleBeanComparator();
    private AgencyService _agencyService;
    private TransitGraphDao _graph;
    private ExtendedCalendarService _calendarService;
    private RouteBeanService _routeBeanService;
    private NarrativeService _narrativeService;
    private BlockIndexService _blockIndexService;
    private int _continuesAsThreshold = 420;

    StopScheduleBeanServiceImpl() {
    }

    @Autowired
    public void setAgencyService(AgencyService agencyService) {
        this._agencyService = agencyService;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setCalendarService(ExtendedCalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setRouteBeanService(RouteBeanService routeBeanService) {
        this._routeBeanService = routeBeanService;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    public void setContinuesAsThreshold(int continuesAsThreshold) {
        this._continuesAsThreshold = continuesAsThreshold;
    }

    @Override
    @Cacheable
    public StopCalendarDaysBean getCalendarForStop(AgencyAndId stopId) {
        TimeZone timeZone = this._agencyService.getTimeZoneForAgencyId(stopId.getAgencyId());
        StopEntry stopEntry = this._graph.getStopEntryForId(stopId);
        HashSet<ServiceIdActivation> serviceIds = new HashSet<ServiceIdActivation>();
        for (BlockStopTimeIndex blockStopTimeIndex : this._blockIndexService.getStopTimeIndicesForStop(stopEntry)) {
            serviceIds.add(blockStopTimeIndex.getServiceIds());
        }
        for (FrequencyBlockStopTimeIndex frequencyBlockStopTimeIndex : this._blockIndexService.getFrequencyStopTimeIndicesForStop(stopEntry)) {
            serviceIds.add(frequencyBlockStopTimeIndex.getServiceIds());
        }
        SortedMap<ServiceDate, Set<ServiceIdActivation>> serviceIdsByDate = this.getServiceIdsByDate(serviceIds);
        Counter counter = new Counter();
        for (Set<ServiceIdActivation> ids : serviceIdsByDate.values()) {
            counter.increment(ids);
        }
        int total = counter.size();
        HashMap<Set, Integer> idsToGroup = new HashMap<Set, Integer>();
        for (Set ids : counter.getSortedKeys()) {
            idsToGroup.put(ids, total--);
        }
        ArrayList<StopCalendarDayBean> beans = new ArrayList<StopCalendarDayBean>(serviceIdsByDate.size());
        for (Map.Entry<ServiceDate, Set<ServiceIdActivation>> entry : serviceIdsByDate.entrySet()) {
            StopCalendarDayBean bean = new StopCalendarDayBean();
            ServiceDate serviceDate = entry.getKey();
            Date date = serviceDate.getAsDate(timeZone);
            bean.setDate(date);
            Integer indexId = (Integer)idsToGroup.get(entry.getValue());
            bean.setGroup(indexId.intValue());
            beans.add(bean);
        }
        return new StopCalendarDaysBean(timeZone.getID(), beans);
    }

    @Override
    @Cacheable
    public List<StopRouteScheduleBean> getScheduledArrivalsForStopAndDate(AgencyAndId stopId, ServiceDate date) {
        StopEntry stopEntry = this._graph.getStopEntryForId(stopId);
        FactoryMap stopTimesByRouteCollectionId = new FactoryMap(new ArrayList());
        FactoryMap frequenciesByRouteCollectionId = new FactoryMap(new ArrayList());
        this.groupStopTimeInstancesByRouteCollectionId(stopEntry, date, (Map<AgencyAndId, List<StopTimeInstance>>)stopTimesByRouteCollectionId, (Map<AgencyAndId, List<StopTimeInstance>>)frequenciesByRouteCollectionId);
        this.groupFrequencyInstancesByRouteCollectionId(stopEntry, date, (Map<AgencyAndId, List<StopTimeInstance>>)frequenciesByRouteCollectionId);
        HashSet routeIds = new HashSet();
        routeIds.addAll(stopTimesByRouteCollectionId.keySet());
        routeIds.addAll(frequenciesByRouteCollectionId.keySet());
        ArrayList<StopRouteScheduleBean> beans = new ArrayList<StopRouteScheduleBean>();
        for (AgencyAndId routeId : routeIds) {
            TripEntry trip;
            StopRouteScheduleBean routeScheduleBean = new StopRouteScheduleBean();
            beans.add(routeScheduleBean);
            RouteBean route = this._routeBeanService.getRouteForId(routeId);
            routeScheduleBean.setRoute(route);
            FactoryMap stopTimesByDirection = new FactoryMap((Object)new StopTimeByDirectionEntry());
            List stopTimesForRoute = (List)stopTimesByRouteCollectionId.get(routeId);
            for (StopTimeInstance sti : stopTimesForRoute) {
                BlockStopTimeEntry bst = sti.getStopTime();
                BlockTripEntry blockTrip = sti.getTrip();
                BlockConfigurationEntry blockConfig = blockTrip.getBlockConfiguration();
                trip = blockTrip.getTrip();
                AgencyAndId tripId = trip.getId();
                AgencyAndId serviceId = trip.getServiceId().getId();
                TripNarrative narrative = this._narrativeService.getTripForId(tripId);
                StopTimeInstanceBean stiBean = new StopTimeInstanceBean();
                stiBean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripId));
                stiBean.setServiceDate(sti.getServiceDate());
                stiBean.setArrivalTime(sti.getArrivalTime());
                stiBean.setDepartureTime(sti.getDepartureTime());
                stiBean.setServiceId(AgencyAndIdLibrary.convertToString((AgencyAndId)serviceId));
                stiBean.setArrivalEnabled(bst.getBlockSequence() > 0);
                stiBean.setDepartureEnabled(bst.getBlockSequence() + 1 < blockConfig.getStopTimes().size());
                String directionId = trip.getDirectionId();
                if (directionId == null) {
                    directionId = "0";
                }
                String tripHeadsign = narrative.getTripHeadsign();
                TripHeadsignStopTimeGroupKey groupKey = new TripHeadsignStopTimeGroupKey(tripHeadsign);
                ContinuesAsStopTimeGroupKey continuesAsGroupKey = this.getContinuesAsGroupKeyForStopTimeInstance(sti);
                StopTimeByDirectionEntry stopTimesForDirection = (StopTimeByDirectionEntry)stopTimesByDirection.get(directionId);
                stopTimesForDirection.addEntry(stiBean, tripHeadsign, groupKey, continuesAsGroupKey);
            }
            List frequenciesForRoute = (List)frequenciesByRouteCollectionId.get(routeId);
            for (StopTimeInstance sti : frequenciesForRoute) {
                BlockStopTimeEntry blockStopTime = sti.getStopTime();
                BlockTripEntry blockTrip = blockStopTime.getTrip();
                trip = blockTrip.getTrip();
                BlockConfigurationEntry blockConfig = blockTrip.getBlockConfiguration();
                AgencyAndId tripId = trip.getId();
                AgencyAndId serviceId = trip.getServiceId().getId();
                TripNarrative narrative = this._narrativeService.getTripForId(tripId);
                FrequencyInstanceBean bean = new FrequencyInstanceBean();
                bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripId));
                bean.setServiceDate(sti.getServiceDate());
                bean.setStartTime(sti.getServiceDate() + (long)(sti.getFrequency().getStartTime() * 1000));
                bean.setEndTime(sti.getServiceDate() + (long)(sti.getFrequency().getEndTime() * 1000));
                bean.setHeadwaySecs(sti.getFrequency().getHeadwaySecs());
                bean.setServiceId(AgencyAndIdLibrary.convertToString((AgencyAndId)serviceId));
                bean.setArrivalEnabled(blockStopTime.getBlockSequence() > 0);
                bean.setDepartureEnabled(blockStopTime.getBlockSequence() + 1 < blockConfig.getStopTimes().size());
                String directionId = trip.getDirectionId();
                if (directionId == null) {
                    directionId = "0";
                }
                StopTimeByDirectionEntry stopTimesForDirection = (StopTimeByDirectionEntry)stopTimesByDirection.get(directionId);
                stopTimesForDirection.addEntry(bean, narrative.getTripHeadsign());
            }
            for (StopTimeByDirectionEntry stopTimesForDirection : stopTimesByDirection.values()) {
                StopRouteDirectionScheduleBean directionBean = new StopRouteDirectionScheduleBean();
                directionBean.getStopTimes().addAll(stopTimesForDirection.getStopTimes());
                directionBean.getFrequencies().addAll(stopTimesForDirection.getFrequencies());
                String headsign = stopTimesForDirection.getBestHeadsign();
                directionBean.setTripHeadsign(headsign);
                Collections.sort(directionBean.getStopTimes(), _stopTimeComparator);
                Collections.sort(directionBean.getFrequencies(), _frequencyComparator);
                ArrayList<StopTimeGroupBean> groups = new ArrayList<StopTimeGroupBean>();
                this.applyTripHeadsignStopTimeGroups(stopTimesForDirection, groups);
                this.applyContinuesAsStopTimeGroups(stopTimesForDirection, groups);
                directionBean.setGroups(groups);
                routeScheduleBean.getDirections().add(directionBean);
            }
            Collections.sort(routeScheduleBean.getDirections(), _directionComparator);
        }
        Collections.sort(beans, _stopRouteScheduleComparator);
        return beans;
    }

    private SortedMap<ServiceDate, Set<ServiceIdActivation>> getServiceIdsByDate(Set<ServiceIdActivation> allServiceIds) {
        TreeMap<ServiceDate, Set<ServiceIdActivation>> serviceIdsByDate = new TreeMap();
        serviceIdsByDate = FactoryMap.createSorted(serviceIdsByDate, new HashSet());
        for (ServiceIdActivation serviceIds : allServiceIds) {
            Set<ServiceDate> dates = this._calendarService.getServiceDatesForServiceIds(serviceIds);
            for (ServiceDate date : dates) {
                ((Set)serviceIdsByDate.get(date)).add(serviceIds);
            }
        }
        return serviceIdsByDate;
    }

    private void groupStopTimeInstancesByRouteCollectionId(StopEntry stopEntry, ServiceDate date, Map<AgencyAndId, List<StopTimeInstance>> stopTimesByRouteCollectionId, Map<AgencyAndId, List<StopTimeInstance>> frequenciesByRouteCollectionId) {
        FactoryMap frequencyLabelsByRouteCollectionId = new FactoryMap(new HashSet());
        for (BlockStopTimeIndex index : this._blockIndexService.getStopTimeIndicesForStop(stopEntry)) {
            ServiceIdActivation serviceIds = index.getServiceIds();
            Set<ServiceDate> serviceDates = this._calendarService.getServiceDatesForServiceIds(serviceIds);
            if (!serviceDates.contains(date)) continue;
            Date serviceDate = date.getAsDate(serviceIds.getTimeZone());
            for (BlockStopTimeEntry stopTime : index.getStopTimes()) {
                BlockTripEntry blockTrip = stopTime.getTrip();
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId routeCollectionId = trip.getRouteCollection().getId();
                FrequencyEntry frequencyLabel = trip.getFrequencyLabel();
                InstanceState state = new InstanceState(serviceDate.getTime(), frequencyLabel);
                StopTimeInstance sti = new StopTimeInstance(stopTime, state);
                if (frequencyLabel == null) {
                    stopTimesByRouteCollectionId.get(routeCollectionId).add(sti);
                    continue;
                }
                if (!((Set)frequencyLabelsByRouteCollectionId.get(routeCollectionId)).add(frequencyLabel)) continue;
                frequenciesByRouteCollectionId.get(routeCollectionId).add(sti);
            }
        }
    }

    private void groupFrequencyInstancesByRouteCollectionId(StopEntry stopEntry, ServiceDate date, Map<AgencyAndId, List<StopTimeInstance>> frequenciesByRouteCollectionId) {
        for (FrequencyBlockStopTimeIndex index : this._blockIndexService.getFrequencyStopTimeIndicesForStop(stopEntry)) {
            ServiceIdActivation serviceIds = index.getServiceIds();
            Set<ServiceDate> serviceDates = this._calendarService.getServiceDatesForServiceIds(serviceIds);
            if (!serviceDates.contains(date)) continue;
            Date serviceDate = date.getAsDate(serviceIds.getTimeZone());
            for (FrequencyBlockStopTimeEntry entry : index.getFrequencyStopTimes()) {
                BlockStopTimeEntry stopTime = entry.getStopTime();
                BlockTripEntry blockTrip = stopTime.getTrip();
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId routeCollectionId = trip.getRouteCollection().getId();
                InstanceState state = new InstanceState(serviceDate.getTime(), entry.getFrequency());
                StopTimeInstance sti = new StopTimeInstance(stopTime, state);
                frequenciesByRouteCollectionId.get(routeCollectionId).add(sti);
            }
        }
    }

    private ContinuesAsStopTimeGroupKey getContinuesAsGroupKeyForStopTimeInstance(StopTimeInstance instance) {
        BlockTripEntry blockTrip = instance.getTrip();
        AgencyAndId lineId = this.getContinuesAsLineId(blockTrip);
        return new ContinuesAsStopTimeGroupKey(lineId);
    }

    private AgencyAndId getContinuesAsLineId(BlockTripEntry blockTrip) {
        AgencyAndId nextLineId;
        BlockTripEntry nextTrip = blockTrip.getNextTrip();
        if (nextTrip == null) {
            return null;
        }
        TripEntry prevTrip = blockTrip.getTrip();
        AgencyAndId prevLineId = prevTrip.getRouteCollection().getId();
        if (prevLineId.equals((Object)(nextLineId = nextTrip.getTrip().getRouteCollection().getId()))) {
            return null;
        }
        List<BlockStopTimeEntry> stopTimes = blockTrip.getStopTimes();
        BlockStopTimeEntry prevStopTime = stopTimes.get(stopTimes.size() - 1);
        List<BlockStopTimeEntry> nextStopTimes = nextTrip.getStopTimes();
        BlockStopTimeEntry nextStopTime = nextStopTimes.get(0);
        int prevTime = prevStopTime.getStopTime().getDepartureTime();
        int nextTime = nextStopTime.getStopTime().getArrivalTime();
        if (nextTime - prevTime > this._continuesAsThreshold) {
            return null;
        }
        return nextLineId;
    }

    private void applyTripHeadsignStopTimeGroups(StopTimeByDirectionEntry stopTimesForDirection, List<StopTimeGroupBean> groups) {
        Counter<TripHeadsignStopTimeGroupKey> keyCounts = stopTimesForDirection.getTripHeadsignKeyCounts();
        List sortedKeys = keyCounts.getSortedKeys();
        for (int i = 0; i < sortedKeys.size() - 1; ++i) {
            TripHeadsignStopTimeGroupKey key = (TripHeadsignStopTimeGroupKey)sortedKeys.get(i);
            StopTimeGroupBean group = new StopTimeGroupBean();
            String groupId = Integer.toString(groups.size());
            group.setId(groupId);
            String tripHeadsign = key.getTripHeadsign();
            group.setTripHeadsign(tripHeadsign);
            this.applyGroupIdForGroupKey(stopTimesForDirection, key, groupId);
            groups.add(group);
        }
    }

    private void applyContinuesAsStopTimeGroups(StopTimeByDirectionEntry stopTimesForDirection, List<StopTimeGroupBean> groups) {
        Counter<ContinuesAsStopTimeGroupKey> keyCounts = stopTimesForDirection.getContinuesAsKeyCounts();
        List sortedKeys = keyCounts.getSortedKeys();
        for (ContinuesAsStopTimeGroupKey key : sortedKeys) {
            AgencyAndId lineId = key.getLineId();
            if (lineId == null) continue;
            StopTimeGroupBean group = new StopTimeGroupBean();
            String groupId = Integer.toString(groups.size());
            group.setId(groupId);
            RouteBean route = this._routeBeanService.getRouteForId(lineId);
            group.setContinuesAs(route);
            this.applyGroupIdForGroupKey(stopTimesForDirection, key, groupId);
            groups.add(group);
        }
    }

    private void applyGroupIdForGroupKey(StopTimeByDirectionEntry stopTimesForDirection, Object key, String groupId) {
        List<StopTimeInstanceBean> stopTimesForGroup = stopTimesForDirection.getStopTimesForGroupKey(key);
        for (StopTimeInstanceBean stiBean : stopTimesForGroup) {
            ArrayList<String> groupIds = stiBean.getGroupIds();
            if (groupIds == null) {
                groupIds = new ArrayList<String>();
                stiBean.setGroupIds(groupIds);
            }
            groupIds.add(groupId);
        }
    }

    private static class ContinuesAsStopTimeGroupKey {
        private final AgencyAndId _lineId;

        public ContinuesAsStopTimeGroupKey(AgencyAndId lineId) {
            this._lineId = lineId;
        }

        public AgencyAndId getLineId() {
            return this._lineId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._lineId == null ? 0 : this._lineId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContinuesAsStopTimeGroupKey other = (ContinuesAsStopTimeGroupKey)obj;
            return !(this._lineId == null ? other._lineId != null : !this._lineId.equals((Object)other._lineId));
        }
    }

    private static class TripHeadsignStopTimeGroupKey {
        private final String tripHeadsign;

        public TripHeadsignStopTimeGroupKey(String tripHeadsign) {
            this.tripHeadsign = tripHeadsign;
        }

        public String getTripHeadsign() {
            return this.tripHeadsign;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tripHeadsign == null ? 0 : this.tripHeadsign.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TripHeadsignStopTimeGroupKey other = (TripHeadsignStopTimeGroupKey)obj;
            return !(this.tripHeadsign == null ? other.tripHeadsign != null : !this.tripHeadsign.equals(other.tripHeadsign));
        }
    }

    public static class StopTimeByDirectionEntry {
        private List<StopTimeInstanceBean> _stopTimes = new ArrayList<StopTimeInstanceBean>();
        private List<FrequencyInstanceBean> _frequencies = new ArrayList<FrequencyInstanceBean>();
        private Counter<String> _headsigns = new Counter();
        private Counter<TripHeadsignStopTimeGroupKey> _tripHeadsignKeyCounts = new Counter();
        private Counter<ContinuesAsStopTimeGroupKey> _continuesAsKeyCounts = new Counter();
        private Map<Object, List<StopTimeInstanceBean>> _stopTimesByGroupKey = new FactoryMap(new ArrayList());

        public Collection<? extends StopTimeInstanceBean> getStopTimes() {
            return this._stopTimes;
        }

        public Collection<FrequencyInstanceBean> getFrequencies() {
            return this._frequencies;
        }

        public void addEntry(StopTimeInstanceBean sti, String headsign, TripHeadsignStopTimeGroupKey groupKey, ContinuesAsStopTimeGroupKey continuesAsGroupKey) {
            this._stopTimes.add(sti);
            this._headsigns.increment((Object)headsign);
            this._tripHeadsignKeyCounts.increment((Object)groupKey);
            this._continuesAsKeyCounts.increment((Object)continuesAsGroupKey);
            this._stopTimesByGroupKey.get(groupKey).add(sti);
            this._stopTimesByGroupKey.get(continuesAsGroupKey).add(sti);
        }

        public void addEntry(FrequencyInstanceBean fi, String headsign) {
            this._frequencies.add(fi);
            int rangeInSeconds = (int)((fi.getEndTime() - fi.getStartTime()) / 1000L);
            int count = rangeInSeconds / fi.getHeadwaySecs();
            this._headsigns.increment((Object)headsign, count);
        }

        public String getBestHeadsign() {
            return (String)this._headsigns.getMax();
        }

        public Counter<TripHeadsignStopTimeGroupKey> getTripHeadsignKeyCounts() {
            return this._tripHeadsignKeyCounts;
        }

        public Counter<ContinuesAsStopTimeGroupKey> getContinuesAsKeyCounts() {
            return this._continuesAsKeyCounts;
        }

        public List<StopTimeInstanceBean> getStopTimesForGroupKey(Object key) {
            return this._stopTimesByGroupKey.get(key);
        }
    }

    private static class DirectionComparator
    implements Comparator<StopRouteDirectionScheduleBean> {
        private DirectionComparator() {
        }

        @Override
        public int compare(StopRouteDirectionScheduleBean o1, StopRouteDirectionScheduleBean o2) {
            String tripA = o1.getTripHeadsign();
            String tripB = o2.getTripHeadsign();
            if (tripA == null) {
                tripA = "";
            }
            if (tripB == null) {
                tripB = "";
            }
            return tripA.compareTo(tripB);
        }
    }

    private static class StopRouteScheduleBeanComparator
    implements Comparator<StopRouteScheduleBean> {
        private StopRouteScheduleBeanComparator() {
        }

        @Override
        public int compare(StopRouteScheduleBean o1, StopRouteScheduleBean o2) {
            String a = StopRouteScheduleBeanComparator.getNameForRoute(o1.getRoute());
            String b = StopRouteScheduleBeanComparator.getNameForRoute(o2.getRoute());
            return NaturalStringOrder.compareNatural((String)a, (String)b);
        }

        private static String getNameForRoute(RouteBean route) {
            String name = route.getShortName();
            if (name == null) {
                name = route.getLongName();
            }
            if (name == null) {
                name = route.getId();
            }
            return name;
        }
    }

    private static class FrequencyBeanComparator
    implements Comparator<FrequencyInstanceBean> {
        private FrequencyBeanComparator() {
        }

        @Override
        public int compare(FrequencyInstanceBean o1, FrequencyInstanceBean o2) {
            long t1 = o1.getStartTime();
            long t2 = o2.getStartTime();
            return new Long(t1).compareTo(new Long(t2));
        }
    }

    private static class StopTimeBeanComparator
    implements Comparator<StopTimeInstanceBean> {
        private StopTimeBeanComparator() {
        }

        @Override
        public int compare(StopTimeInstanceBean o1, StopTimeInstanceBean o2) {
            long t1 = o1.getDepartureTime();
            long t2 = o2.getDepartureTime();
            return new Long(t1).compareTo(new Long(t2));
        }
    }
}

