/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.onebusaway.collections.Counter;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.beans.ArrivalsAndDeparturesBeanService;
import org.onebusaway.transit_data_federation.services.beans.NearbyStopsBeanService;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopWithArrivalsAndDeparturesBeanService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopWithArrivalsAndDeparturesBeanServiceImpl
implements StopWithArrivalsAndDeparturesBeanService {
    private static Logger _log = LoggerFactory.getLogger(StopWithArrivalsAndDeparturesBeanServiceImpl.class);
    @Autowired
    private StopBeanService _stopBeanService;
    @Autowired
    private ArrivalsAndDeparturesBeanService _arrivalsAndDeparturesBeanService;
    @Autowired
    private NearbyStopsBeanService _nearbyStopsBeanService;
    @Autowired
    private AgencyService _agencyService;
    @Autowired
    private ServiceAlertsBeanService _serviceAlertsBeanService;

    StopWithArrivalsAndDeparturesBeanServiceImpl() {
    }

    @Override
    public StopWithArrivalsAndDeparturesBean getArrivalsAndDeparturesByStopId(AgencyAndId id, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) {
        StopBean stop = this._stopBeanService.getStopForId(id, serviceInterval);
        if (stop == null) {
            return null;
        }
        List<ArrivalAndDepartureBean> arrivalsAndDepartures = this._arrivalsAndDeparturesBeanService.getArrivalsAndDeparturesByStopId(id, query);
        List<AgencyAndId> nearbyStopIds = this._nearbyStopsBeanService.getNearbyStops(stop, 100.0);
        ArrayList<StopBean> nearbyStops = new ArrayList<StopBean>();
        for (AgencyAndId nearbyStopId : nearbyStopIds) {
            nearbyStops.add(this._stopBeanService.getStopForId(nearbyStopId, serviceInterval));
        }
        List<ServiceAlertBean> situations = this._serviceAlertsBeanService.getServiceAlertsForStopId(query.getTime(), id);
        HashMap<String, ServiceAlertBean> situationsById = new HashMap<String, ServiceAlertBean>();
        this.findServiceAlertsForRouteIds(Collections.singletonList(stop), situationsById);
        HashSet<Object> allSituations = new HashSet<Object>();
        allSituations.addAll(situations);
        allSituations.addAll(situationsById.values());
        return new StopWithArrivalsAndDeparturesBean(stop, arrivalsAndDepartures, nearbyStops, new ArrayList(allSituations));
    }

    @Override
    public StopsWithArrivalsAndDeparturesBean getArrivalsAndDeparturesForStopIds(Set<AgencyAndId> ids, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) throws NoSuchStopServiceException {
        ArrayList<StopBean> stops = new ArrayList<StopBean>();
        List<Object> allArrivalsAndDepartures = new ArrayList<ArrivalAndDepartureBean>();
        HashSet<AgencyAndId> allNearbyStopIds = new HashSet<AgencyAndId>();
        HashMap<String, ServiceAlertBean> situationsById = new HashMap<String, ServiceAlertBean>();
        Counter timeZones = new Counter();
        boolean limitExceeded = false;
        for (AgencyAndId id : ids) {
            StopBean stopBean = this._stopBeanService.getStopForId(id, serviceInterval);
            stops.add(stopBean);
            Object arrivalsAndDepartures = null;
            arrivalsAndDepartures = this._arrivalsAndDeparturesBeanService.getArrivalsAndDeparturesByStopId(id, query);
            if (arrivalsAndDepartures != null && !arrivalsAndDepartures.isEmpty()) {
                stops.add(stopBean);
                allArrivalsAndDepartures.addAll(this.filter((List<ArrivalAndDepartureBean>)arrivalsAndDepartures));
            }
            List<AgencyAndId> nearbyStopIds = this._nearbyStopsBeanService.getNearbyStops(stopBean, 100.0, query.getInstanceFilterChain());
            allNearbyStopIds.addAll(nearbyStopIds);
            TimeZone timeZone = this._agencyService.getTimeZoneForAgencyId(id.getAgencyId());
            timeZones.increment((Object)timeZone);
            List<ServiceAlertBean> situations = this._serviceAlertsBeanService.getServiceAlertsForStopId(query.getTime(), id);
            for (ServiceAlertBean situation : situations) {
                situationsById.put(situation.getId(), situation);
            }
        }
        if (!query.getIncludeInputIdsInNearby()) {
            allNearbyStopIds.removeAll(ids);
        }
        ArrayList<StopBean> nearbyStops = new ArrayList<StopBean>();
        CoordinateBounds bounds = query.getBounds();
        CoordinatePoint center = null;
        if (bounds != null) {
            center = SphericalGeometryLibrary.getCenterOfBounds((CoordinateBounds)bounds);
        }
        for (AgencyAndId id : allNearbyStopIds) {
            StopBean stop = this._stopBeanService.getStopForId(id, serviceInterval);
            if (center != null) {
                double distance = SphericalGeometryLibrary.distance((double)center.getLat(), (double)center.getLon(), (double)stop.getLat(), (double)stop.getLon());
                stop.setDistanceAwayFromQuery(Double.valueOf(distance));
            }
            ArrayList<RouteBean> routeBeans = new ArrayList<RouteBean>();
            for (RouteBean routeBean : stop.getRoutes()) {
                if (!this._stopBeanService.matchesRouteTypeFilter(routeBean, query.getRouteTypes())) continue;
                routeBeans.add(routeBean);
            }
            if (routeBeans.isEmpty()) continue;
            stop.setRoutes(routeBeans);
            nearbyStops.add(stop);
        }
        Collections.sort(nearbyStops, new StopDistanceComparator());
        while (nearbyStops.size() > query.getMaxCount()) {
            nearbyStops.remove(nearbyStops.size() - 1);
            limitExceeded = true;
        }
        TimeZone timeZone = (TimeZone)timeZones.getMax();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        StopsWithArrivalsAndDeparturesBean result = new StopsWithArrivalsAndDeparturesBean();
        while (stops.size() > query.getMaxCount()) {
            stops.remove(stops.size() - 1);
            limitExceeded = true;
        }
        allArrivalsAndDepartures = allArrivalsAndDepartures.stream().sorted((bean1, bean2) -> new StopDistanceComparator().compare(bean1.getStop(), bean2.getStop())).collect(Collectors.toList());
        this.findServiceAlertsForRouteIds(stops, situationsById);
        while (allArrivalsAndDepartures.size() > query.getMaxCount()) {
            allArrivalsAndDepartures.remove(allArrivalsAndDepartures.size() - 1);
            limitExceeded = true;
        }
        result.setStops(stops);
        result.setArrivalsAndDepartures(allArrivalsAndDepartures);
        result.setNearbyStops(nearbyStops);
        result.setSituations(new ArrayList(situationsById.values()));
        result.setTimeZone(timeZone.getID());
        result.setLimitExceeded(limitExceeded);
        return result;
    }

    private void findServiceAlertsForRouteIds(List<StopBean> stops, Map<String, ServiceAlertBean> situationsById) {
        if (stops == null || stops.isEmpty()) {
            return;
        }
        HashSet<AgencyAndId> routeIds = new HashSet<AgencyAndId>();
        for (StopBean stopBean : stops) {
            for (RouteBean routeBean : stopBean.getRoutes()) {
                routeIds.add(AgencyAndIdLibrary.convertFromString((String)routeBean.getId()));
            }
        }
        for (StopBean stopBean : stops) {
            for (RouteBean routeBean : stopBean.getStaticRoutes()) {
                routeIds.add(AgencyAndIdLibrary.convertFromString((String)routeBean.getId()));
            }
        }
        for (AgencyAndId routeId : routeIds) {
            SituationQueryBean query = new SituationQueryBean();
            SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
            query.getAffects().add(affects);
            affects.setRouteId(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId));
            List<ServiceAlertBean> serviceAlerts = this._serviceAlertsBeanService.getServiceAlerts(query);
            for (ServiceAlertBean serviceAlert : serviceAlerts) {
                if (situationsById.containsKey(serviceAlert.getId())) continue;
                situationsById.put(serviceAlert.getId(), serviceAlert);
            }
        }
    }

    private List<ArrivalAndDepartureBean> filter(List<ArrivalAndDepartureBean> arrivalsAndDepartures) {
        ArrayList<ArrivalAndDepartureBean> filtered = new ArrayList<ArrivalAndDepartureBean>();
        for (ArrivalAndDepartureBean arrivalsAndDeparture : arrivalsAndDepartures) {
            if (arrivalsAndDeparture.getTrip().getRoute() == null) {
                _log.error("for A/D {} found a null route bean: {} for trip {}", new Object[]{arrivalsAndDeparture, arrivalsAndDeparture.getTrip().getRoute().getId(), arrivalsAndDeparture.getTrip()});
                continue;
            }
            if (arrivalsAndDeparture.getTrip().getRoute().getShortName() == null) {
                _log.error("for A/D {} found a null route: {}/{}/{} for trip {}", new Object[]{arrivalsAndDeparture, arrivalsAndDeparture.getTrip().getRoute().getId(), arrivalsAndDeparture.getTrip().getRoute().getShortName(), arrivalsAndDeparture.getTrip().getRoute().getLongName(), arrivalsAndDeparture.getTrip().getId()});
                continue;
            }
            filtered.add(arrivalsAndDeparture);
        }
        return filtered;
    }

    private static class StopDistanceComparator
    implements Comparator {
        private StopDistanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            StopBean s1 = (StopBean)o1;
            StopBean s2 = (StopBean)o2;
            if (s1.getDistanceAwayFromQuery() == s2.getDistanceAwayFromQuery()) {
                return 0;
            }
            if (s1.getDistanceAwayFromQuery() == null) {
                return -1;
            }
            if (s2.getDistanceAwayFromQuery() == null) {
                return 1;
            }
            try {
                return Double.compare(s1.getDistanceAwayFromQuery(), s2.getDistanceAwayFromQuery());
            }
            catch (NullPointerException npe) {
                return 0;
            }
        }
    }
}

