/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryparser.classic.ParseException;
import org.onebusaway.collections.Min;
import org.onebusaway.exceptions.InvalidArgumentServiceException;
import org.onebusaway.exceptions.NoSuchAgencyServiceException;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data_federation.impl.beans.BeanServiceSupport;
import org.onebusaway.transit_data_federation.impl.beans.StopBeanIdComparator;
import org.onebusaway.transit_data_federation.model.SearchResult;
import org.onebusaway.transit_data_federation.services.StopSearchService;
import org.onebusaway.transit_data_federation.services.beans.GeospatialBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopsBeanService;
import org.onebusaway.transit_data_federation.services.transit_graph.AgencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopsBeanServiceImpl
implements StopsBeanService {
    private static Logger _log = LoggerFactory.getLogger(StopsBeanServiceImpl.class);
    private static final double MIN_SCORE = 1.0;
    private static final double NAME_MIN_SCORE = 4.0;
    private static final int MAX_STOPS = 10;
    @Autowired
    private StopSearchService _searchService;
    @Autowired
    private StopBeanService _stopBeanService;
    @Autowired
    private GeospatialBeanService _geospatialBeanService;
    @Autowired
    private TransitGraphDao _transitGraphDao;

    StopsBeanServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Override
    public StopsBean getStops(SearchQueryBean queryBean) throws ServiceException {
        String query = queryBean.getQuery();
        if (query == null) {
            return this.getStopsByBounds(queryBean);
        }
        return this.getStopsByBoundsAndQuery(queryBean);
    }

    @Override
    public StopsBean getStopsByName(String stopName) throws ServiceException {
        ArrayList<StopBean> stopBeans = new ArrayList<StopBean>();
        SearchResult<AgencyAndId> results = null;
        try {
            results = this._searchService.searchForStopsByName(stopName, 10, 4.0);
            for (AgencyAndId aid : results.getResultsByTopScore()) {
                StopBean stopBean = this._stopBeanService.getStopForId(aid, null);
                if (stopBean == null) continue;
                stopBeans.add(stopBean);
            }
        }
        catch (Exception e) {
            _log.error("search failed!", (Throwable)e);
            return new StopsBean();
        }
        if (results == null) {
            return new StopsBean();
        }
        return this.constructResult(stopBeans, results.size() == 10);
    }

    private StopsBean getStopsByBounds(SearchQueryBean queryBean) throws ServiceException {
        CoordinateBounds bounds = queryBean.getBounds();
        CoordinatePoint center = SphericalGeometryLibrary.getCenterOfBounds((CoordinateBounds)bounds);
        List<AgencyAndId> stopIds = this._geospatialBeanService.getStopsByBounds(bounds);
        boolean limitExceeded = false;
        if (queryBean != null && queryBean.getType() != null && !queryBean.getType().equals((Object)SearchQueryBean.EQueryType.ORDERED_BY_CLOSEST)) {
            limitExceeded = BeanServiceSupport.checkLimitExceeded(stopIds, queryBean.getMaxCount());
        }
        ArrayList<StopBean> stopBeans = new ArrayList<StopBean>();
        AgencyServiceInterval serviceInterval = null;
        if (queryBean.getServiceInterval() != null) {
            serviceInterval = queryBean.getServiceInterval();
        }
        for (AgencyAndId stopId : stopIds) {
            StopBean stopBean = this._stopBeanService.getStopForId(stopId, serviceInterval);
            if (stopBean == null) {
                throw new ServiceException();
            }
            if (queryBean != null && queryBean.getType() != null && queryBean.getType().equals((Object)SearchQueryBean.EQueryType.ORDERED_BY_CLOSEST)) {
                double distance = SphericalGeometryLibrary.distance((double)center.getLat(), (double)center.getLon(), (double)stopBean.getLat(), (double)stopBean.getLon());
                stopBean.setDistanceAwayFromQuery(Double.valueOf(distance));
            }
            if (stopBean.getRoutes().isEmpty() || !queryBean.getSystemFilterChain().matches(stopBean) || !queryBean.getInstanceFilterChain().matches(stopBean)) continue;
            stopBeans.add(stopBean);
        }
        if (queryBean != null && queryBean.getType() != null && queryBean.getType().equals((Object)SearchQueryBean.EQueryType.ORDERED_BY_CLOSEST)) {
            limitExceeded = stopBeans.size() > queryBean.getMaxCount();
        }
        return this.constructResult(stopBeans, limitExceeded);
    }

    private StopsBean getStopsByBoundsAndQuery(SearchQueryBean queryBean) throws ServiceException {
        SearchResult<AgencyAndId> stops;
        CoordinateBounds bounds = queryBean.getBounds();
        String query = queryBean.getQuery();
        int maxCount = queryBean.getMaxCount();
        CoordinatePoint center = SphericalGeometryLibrary.getCenterOfBounds((CoordinateBounds)bounds);
        try {
            stops = this._searchService.searchForStopsByCode(query, 10, 1.0);
        }
        catch (ParseException e) {
            throw new InvalidArgumentServiceException("query", "queryParseError");
        }
        catch (IOException e) {
            _log.error("error executing stop search: query=" + query, (Throwable)e);
            e.printStackTrace();
            throw new ServiceException();
        }
        Min closest = new Min();
        ArrayList<StopBean> stopBeans = new ArrayList<StopBean>();
        HashMap<String, Double> stopIdToDistanceMap = new HashMap<String, Double>();
        for (AgencyAndId aid : stops.getResults()) {
            StopBean stopBean = this._stopBeanService.getStopForId(aid, null);
            if (bounds.contains(stopBean.getLat(), stopBean.getLon())) {
                stopBeans.add(stopBean);
            }
            double distance = SphericalGeometryLibrary.distance((double)center.getLat(), (double)center.getLon(), (double)stopBean.getLat(), (double)stopBean.getLon());
            stopIdToDistanceMap.put(aid.toString(), distance);
            closest.add(distance, (Object)stopBean);
        }
        boolean limitExceeded = false;
        if (queryBean != null && queryBean.getType() != null && queryBean.getType().equals((Object)SearchQueryBean.EQueryType.ORDERED_BY_CLOSEST)) {
            this.sortByDistance(stopBeans, stopIdToDistanceMap);
            boolean bl = limitExceeded = stopBeans.size() > maxCount;
            while (stopBeans.size() > maxCount) {
                stopBeans.remove(stopBeans.size() - 1);
            }
        } else {
            limitExceeded = BeanServiceSupport.checkLimitExceeded(stopBeans, maxCount);
        }
        if (stopBeans.isEmpty() && !closest.isEmpty()) {
            stopBeans.add((StopBean)closest.getMinElement());
        }
        return this.constructResult(stopBeans, limitExceeded);
    }

    private void sortByDistance(List<StopBean> stopBeans, Map<String, Double> distanceMap) {
        for (StopBean bean : stopBeans) {
            Double distance = distanceMap.get(bean.getId());
            if (distance == null) continue;
            bean.setDistanceAwayFromQuery(distance);
        }
        Collections.sort(stopBeans, new DistanceAwayComparator());
    }

    @Override
    public StopsBean getStopsForAgencyId(String agencyId) {
        AgencyEntry agency = this._transitGraphDao.getAgencyForId(agencyId);
        if (agency == null) {
            throw new NoSuchAgencyServiceException(agencyId);
        }
        ArrayList<StopBean> stopBeans = new ArrayList<StopBean>();
        for (StopEntry stop : agency.getStops()) {
            AgencyAndId id = stop.getId();
            StopBean stopBean = this._stopBeanService.getStopForId(id, null);
            stopBeans.add(stopBean);
        }
        return this.constructResult(stopBeans, false);
    }

    @Override
    public ListBean<String> getStopsIdsForAgencyId(String agencyId) {
        AgencyEntry agency = this._transitGraphDao.getAgencyForId(agencyId);
        if (agency == null) {
            throw new NoSuchAgencyServiceException(agencyId);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (StopEntry stop : agency.getStops()) {
            AgencyAndId id = stop.getId();
            ids.add(AgencyAndIdLibrary.convertToString((AgencyAndId)id));
        }
        return new ListBean(ids, false);
    }

    private StopsBean constructResult(List<StopBean> stopBeans, boolean limitExceeded) {
        Collections.sort(stopBeans, new StopBeanIdComparator());
        StopsBean result = new StopsBean();
        result.setStops(stopBeans);
        result.setLimitExceeded(limitExceeded);
        return result;
    }

    private static class DistanceAwayComparator
    implements Comparator {
        private DistanceAwayComparator() {
        }

        public int compare(Object o1, Object o2) {
            StopBean sb1 = (StopBean)o1;
            StopBean sb2 = (StopBean)o2;
            try {
                return Double.compare(sb1.getDistanceAwayFromQuery(), sb2.getDistanceAwayFromQuery());
            }
            catch (NullPointerException npe) {
                _log.error("missing distance in compare for {} vs {}", (Object)sb1, (Object)sb2);
                return 0;
            }
        }
    }
}

