/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.TripStopTimesBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.trips.TimepointPredictionBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsInclusionBean;
import org.onebusaway.transit_data.model.trips.TripDetailsQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForBoundsQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.impl.beans.FrequencyBeanLibrary;
import org.onebusaway.transit_data_federation.impl.realtime.apc.VehicleOccupancyRecordCache;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureService;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripDetailsBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripStopTimesBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstanceLibrary;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TripStatusBeanServiceImpl
implements TripDetailsBeanService {
    private static Logger _log = LoggerFactory.getLogger(TripStatusBeanServiceImpl.class);
    private TransitGraphDao _transitGraphDao;
    private DynamicGraph _dynamicGraph;
    private BlockStatusService _blockStatusService;
    private TripBeanService _tripBeanService;
    private TripStopTimesBeanService _tripStopTimesBeanService;
    private StopBeanService _stopBeanService;
    private ServiceAlertsBeanService _serviceAlertBeanService;
    private VehicleOccupancyRecordCache _vehicleOccupancyRecordCache;
    private ArrivalAndDepartureService _arrivalAndDepartureService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setDynamicGraph(DynamicGraph dynamicGraph) {
        this._dynamicGraph = dynamicGraph;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    @Autowired
    public void setTripBeanService(TripBeanService tripBeanService) {
        this._tripBeanService = tripBeanService;
    }

    @Autowired
    public void setTripStopTimesBeanService(TripStopTimesBeanService tripStopTimesBeanService) {
        this._tripStopTimesBeanService = tripStopTimesBeanService;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setServiceAlertBeanService(ServiceAlertsBeanService serviceAlertBeanService) {
        this._serviceAlertBeanService = serviceAlertBeanService;
    }

    @Autowired
    public void setVehicleOccupancyRecordCache(VehicleOccupancyRecordCache cache) {
        this._vehicleOccupancyRecordCache = cache;
    }

    @Autowired
    public void setArrivalAndDepartureService(ArrivalAndDepartureService arrivalAndDepartureService) {
        this._arrivalAndDepartureService = arrivalAndDepartureService;
    }

    @Override
    public TripDetailsBean getTripForId(TripDetailsQueryBean query) {
        ListBean<TripDetailsBean> listBean = this.getTripsForId(query);
        List trips = listBean.getList();
        if (trips == null || trips.isEmpty()) {
            return null;
        }
        if (trips.size() == 1) {
            return (TripDetailsBean)trips.get(0);
        }
        return (TripDetailsBean)trips.get(0);
    }

    @Override
    public ListBean<TripDetailsBean> getTripsForId(TripDetailsQueryBean query) {
        AgencyAndId tripId = AgencyAndIdLibrary.convertFromString((String)query.getTripId());
        long serviceDate = query.getServiceDate();
        AgencyAndId vehicleId = AgencyAndIdLibrary.convertFromString((String)query.getVehicleId());
        long time = query.getTime();
        TripEntry tripEntry = this._transitGraphDao.getTripEntryForId(tripId);
        if (tripEntry == null) {
            tripEntry = this._dynamicGraph.getTripEntryForId(tripId);
        }
        if (tripEntry == null) {
            return new ListBean();
        }
        Map<BlockInstance, List<BlockLocation>> locationsByInstance = this._blockStatusService.getBlocks(tripEntry.getBlock().getId(), serviceDate, vehicleId, time);
        ArrayList<TripDetailsBean> tripDetails = new ArrayList<TripDetailsBean>();
        for (Map.Entry<BlockInstance, List<BlockLocation>> entry : locationsByInstance.entrySet()) {
            BlockInstance blockInstance = entry.getKey();
            List<BlockLocation> locations = entry.getValue();
            BlockTripInstance blockTripInstance = BlockTripInstanceLibrary.getBlockTripInstance(blockInstance, tripId);
            if (blockTripInstance == null) {
                throw new IllegalStateException("expected blockTrip for trip=" + tripEntry + " and block=" + blockInstance);
            }
            if (locations.isEmpty()) {
                TripDetailsBean details = this.getTripEntryAndBlockLocationAsTripDetails(blockTripInstance, null, query.getInclusion(), time);
                tripDetails.add(details);
                continue;
            }
            for (BlockLocation location : locations) {
                TripDetailsBean details = this.getBlockLocationAsTripDetails(blockTripInstance, location, query.getInclusion(), time);
                tripDetails.add(details);
            }
        }
        return new ListBean(tripDetails, false);
    }

    @Override
    public TripDetailsBean getTripForVehicle(AgencyAndId vehicleId, long time, TripDetailsInclusionBean inclusion) {
        BlockLocation blockLocation = this._blockStatusService.getBlockForVehicle(vehicleId, time);
        if (blockLocation == null) {
            return null;
        }
        return this.getBlockLocationAsTripDetails(blockLocation.getActiveTripInstance(), blockLocation, inclusion, time);
    }

    @Override
    public ListBean<TripDetailsBean> getTripsForBounds(TripsForBoundsQueryBean query) {
        List<BlockLocation> locations = this._blockStatusService.getBlocksForBounds(query.getBounds(), query.getTime());
        return this.getBlockLocationsAsTripDetails(locations, query.getInclusion(), query.getTime());
    }

    @Override
    public ListBean<TripDetailsBean> getTripsForRoute(TripsForRouteQueryBean query) {
        AgencyAndId routeId = AgencyAndIdLibrary.convertFromString((String)query.getRouteId());
        List<BlockLocation> locations = this._blockStatusService.getBlocksForRoute(routeId, query.getTime());
        return this.getBlockLocationsAsTripDetails(locations, query.getInclusion(), query.getTime());
    }

    @Override
    public ListBean<TripDetailsBean> getTripsForAgency(TripsForAgencyQueryBean query) {
        List<BlockLocation> locations = this._blockStatusService.getActiveBlocksForAgency(query.getAgencyId(), query.getTime());
        return this.getBlockLocationsAsTripDetails(locations, query.getInclusion(), query.getTime());
    }

    @Override
    public TripStatusBean getBlockLocationAsStatusBean(BlockLocation blockLocation, long time) {
        List<ServiceAlertBean> situations;
        String status;
        EVehiclePhase phase;
        BlockStopTimeEntry previousStop;
        BlockStopTimeEntry nextStop;
        TripStatusBean bean = new TripStatusBean();
        bean.setStatus("default");
        if ("CANCELED".equals(blockLocation.getStatus())) {
            if (this._arrivalAndDepartureService.getHideCanceledTrips()) {
                return null;
            }
            bean.setStatus("CANCELED");
        }
        BlockInstance blockInstance = blockLocation.getBlockInstance();
        long serviceDate = blockInstance.getServiceDate();
        bean.setServiceDate(serviceDate);
        bean.setLastUpdateTime(blockLocation.getLastUpdateTime());
        bean.setLastLocationUpdateTime(blockLocation.getLastLocationUpdateTime());
        bean.setLastKnownLocation(blockLocation.getLastKnownLocation());
        bean.setLastKnownOrientation(blockLocation.getLastKnownOrientation());
        bean.setLocation(blockLocation.getLocation());
        bean.setOrientation(blockLocation.getOrientation());
        bean.setLastKnownLocation(blockLocation.getLastKnownLocation());
        if (blockLocation.isLastKnownOrientationSet()) {
            bean.setLastKnownOrientation(blockLocation.getLastKnownOrientation());
        }
        bean.setScheduleDeviation(blockLocation.getScheduleDeviation());
        bean.setVehicleFeatures(blockLocation.getVehicleFeatures());
        BlockTripInstance activeTripInstance = blockLocation.getActiveTripInstance();
        if (activeTripInstance != null) {
            FrequencyEntry frequencyLabel;
            BlockTripEntry activeBlockTrip = activeTripInstance.getBlockTrip();
            bean.setScheduledDistanceAlongTrip(blockLocation.getScheduledDistanceAlongBlock() - activeBlockTrip.getDistanceAlongBlock());
            bean.setDistanceAlongTrip(blockLocation.getDistanceAlongBlock() - activeBlockTrip.getDistanceAlongBlock());
            TripEntry activeTrip = activeBlockTrip.getTrip();
            bean.setTotalDistanceAlongTrip(activeTrip.getTotalTripDistance());
            TripBean activeTripBean = this._tripBeanService.getTripForId(activeTrip.getId());
            bean.setActiveTrip(activeTripBean);
            bean.setBlockTripSequence((int)activeBlockTrip.getSequence());
            StopTimeEntry firstStop = activeBlockTrip.getTrip().getStopTimes().get(0);
            if (firstStop.getArrivalTime() > 0) {
                bean.setTripStartTime(firstStop.getArrivalTime());
            } else if (firstStop.getDepartureTime() > 0) {
                bean.setTripStartTime(firstStop.getDepartureTime());
            }
            if (blockLocation.isLastKnownDistanceAlongBlockSet()) {
                bean.setLastKnownDistanceAlongTrip(blockLocation.getLastKnownDistanceAlongBlock() - activeBlockTrip.getDistanceAlongBlock());
            }
            if ((frequencyLabel = activeTripInstance.getFrequencyLabel()) != null) {
                FrequencyBean fb = FrequencyBeanLibrary.getBeanForFrequency(serviceDate, frequencyLabel);
                bean.setFrequency(fb);
            }
        } else {
            _log.warn("no active block trip for block location: blockInstance=" + blockLocation.getBlockInstance() + " time=" + time);
        }
        BlockStopTimeEntry closestStop = blockLocation.getClosestStop();
        if (closestStop != null) {
            StopTimeEntry stopTime = closestStop.getStopTime();
            StopBean stopBean = this._stopBeanService.getStopForId(stopTime.getStop().getId(), null);
            bean.setClosestStop(stopBean);
            bean.setClosestStopTimeOffset(blockLocation.getClosestStopTimeOffset());
        }
        if ((nextStop = blockLocation.getNextStop()) != null) {
            StopTimeEntry stopTime = nextStop.getStopTime();
            StopBean stopBean = this._stopBeanService.getStopForId(stopTime.getStop().getId(), null);
            bean.setNextStop(stopBean);
            bean.setNextStopTimeOffset(blockLocation.getNextStopTimeOffset());
            bean.setNextStopDistanceFromVehicle(blockLocation.getNextStop().getDistanceAlongBlock() - blockLocation.getDistanceAlongBlock());
        }
        if ((previousStop = blockLocation.getPreviousStop()) != null) {
            StopTimeEntry stopTime = previousStop.getStopTime();
            StopBean stopBean = this._stopBeanService.getStopForId(stopTime.getStop().getId(), null);
            bean.setPreviousStop(stopBean);
            bean.setPreviousStopTimeOffset(blockLocation.getPreviousStopTimeOffset());
            bean.setPreviousStopDistanceFromVehicle(blockLocation.getPreviousStop().getDistanceAlongBlock() - blockLocation.getDistanceAlongBlock());
        }
        if ((phase = blockLocation.getPhase()) != null) {
            bean.setPhase(phase.toLabel());
        }
        if ((status = blockLocation.getStatus()) != null) {
            bean.setStatus(status);
        }
        if (blockLocation.getVehicleType() != null) {
            bean.setVehicleType(blockLocation.getVehicleType().toLabel());
        }
        bean.setPredicted(blockLocation.isPredicted());
        AgencyAndId vid = blockLocation.getVehicleId();
        if (vid != null) {
            bean.setVehicleId(ApplicationBeanLibrary.getId(vid));
        }
        if (activeTripInstance != null && !(situations = this._serviceAlertBeanService.getServiceAlertsForVehicleJourney(time, activeTripInstance, blockLocation.getVehicleId())).isEmpty()) {
            bean.setSituations(situations);
        }
        if (blockLocation.getTimepointPredictions() != null && blockLocation.getTimepointPredictions().size() > 0) {
            ArrayList<TimepointPredictionBean> timepointPredictions = new ArrayList<TimepointPredictionBean>();
            for (TimepointPredictionRecord tpr : blockLocation.getTimepointPredictions()) {
                TimepointPredictionBean tpb = new TimepointPredictionBean();
                if (tpr.isSkipped()) {
                    tpb.setScheduleRealtionship(TimepointPredictionBean.ScheduleRelationship.SKIPPED.getValue());
                } else {
                    tpb.setScheduleRealtionship(TimepointPredictionBean.ScheduleRelationship.SCHEDULED.getValue());
                }
                tpb.setTimepointId(tpr.getTimepointId().toString());
                tpb.setTripId(tpr.getTripId().toString());
                tpb.setStopSequence(tpr.getStopSequence());
                tpb.setTimepointPredictedArrivalTime(tpr.getTimepointPredictedArrivalTime());
                tpb.setTimepointPredictedDepartureTime(tpr.getTimepointPredictedDepartureTime());
                timepointPredictions.add(tpb);
            }
            bean.setTimepointPredictions(timepointPredictions);
        }
        if (blockLocation.getVehicleId() != null && blockLocation.getActiveTrip() != null) {
            VehicleOccupancyRecord vor = this._vehicleOccupancyRecordCache.getRecordForVehicleIdAndRoute(blockLocation.getVehicleId(), blockLocation.getActiveTrip().getTrip().getRoute().getId().toString(), blockLocation.getActiveTrip().getTrip().getDirectionId());
            if (vor != null) {
                bean.setOccupancyStatus(vor.getOccupancyStatus());
                bean.setOccupancyCount(vor.getRawCount());
                if (vor.getCapacity() != null && vor.getCapacity() > 0) {
                    bean.setOccupancyCapacity(vor.getCapacity());
                } else {
                    bean.setOccupancyCapacity(Integer.valueOf(-1));
                }
            } else {
                bean.setOccupancyCount(Integer.valueOf(-1));
                bean.setOccupancyCapacity(Integer.valueOf(-1));
            }
        }
        return bean;
    }

    private ListBean<TripDetailsBean> getBlockLocationsAsTripDetails(List<BlockLocation> locations, TripDetailsInclusionBean inclusion, long time) {
        ArrayList<TripDetailsBean> tripDetails = new ArrayList<TripDetailsBean>();
        for (BlockLocation location : locations) {
            TripDetailsBean details = this.getBlockLocationAsTripDetails(location.getActiveTripInstance(), location, inclusion, time);
            if (tripDetails == null) continue;
            tripDetails.add(details);
        }
        return new ListBean(tripDetails, false);
    }

    private TripDetailsBean getBlockLocationAsTripDetails(BlockTripInstance targetBlockTrip, BlockLocation blockLocation, TripDetailsInclusionBean inclusion, long time) {
        if (targetBlockTrip == null || blockLocation == null) {
            return null;
        }
        return this.getTripEntryAndBlockLocationAsTripDetails(targetBlockTrip, blockLocation, inclusion, time);
    }

    private TripDetailsBean getTripEntryAndBlockLocationAsTripDetails(BlockTripInstance blockTripInstance, BlockLocation blockLocation, TripDetailsInclusionBean inclusion, long time) {
        TripBean trip = null;
        long serviceDate = blockTripInstance.getServiceDate();
        FrequencyBean frequency = null;
        TripStopTimesBean stopTimes = null;
        TripStatusBean status = null;
        AgencyAndId vehicleId = null;
        boolean missing = false;
        FrequencyEntry frequencyLabel = blockTripInstance.getFrequencyLabel();
        if (frequencyLabel != null) {
            frequency = FrequencyBeanLibrary.getBeanForFrequency(serviceDate, frequencyLabel);
        }
        BlockTripEntry blockTrip = blockTripInstance.getBlockTrip();
        TripEntry tripEntry = blockTrip.getTrip();
        if (inclusion.isIncludeTripBean() && (trip = this._tripBeanService.getTripForId(tripEntry.getId())) == null) {
            missing = true;
        }
        if (inclusion.isIncludeTripSchedule() && (stopTimes = this._tripStopTimesBeanService.getStopTimesForBlockTrip(blockTripInstance)) == null) {
            missing = true;
        }
        if (inclusion.isIncludeTripStatus() && blockLocation != null && (status = this.getBlockLocationAsStatusBean(blockLocation, time)) != null) {
            vehicleId = AgencyAndIdLibrary.convertFromString((String)status.getVehicleId());
        }
        List<ServiceAlertBean> situations = this._serviceAlertBeanService.getServiceAlertsForVehicleJourney(time, blockTripInstance, vehicleId);
        if (missing) {
            return null;
        }
        String tripId = AgencyAndIdLibrary.convertToString((AgencyAndId)tripEntry.getId());
        TripDetailsBean bean = new TripDetailsBean();
        bean.setTripId(tripId);
        bean.setServiceDate(serviceDate);
        bean.setFrequency(frequency);
        bean.setTrip(trip);
        bean.setSchedule(stopTimes);
        bean.setStatus(status);
        bean.setSituations(situations);
        return bean;
    }
}

