/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.collections.Min;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.blocks.LayoverIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicTripEntryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BlockCalendarServiceImpl
implements BlockCalendarService {
    private ExtendedCalendarService _calendarService;
    private BlockIndexService _blockIndexService;
    private TransitGraphDao _transitGraphDao;
    private DynamicGraph _dynamicGraph;

    BlockCalendarServiceImpl() {
    }

    @Autowired
    public void setCalendarService(ExtendedCalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setDynamicGraph(DynamicGraph dynamicGraph) {
        this._dynamicGraph = dynamicGraph;
    }

    @Override
    @Cacheable(isValueSerializable=false)
    public BlockInstance getBlockInstance(AgencyAndId blockId, long serviceDate) {
        BlockEntry block = this._transitGraphDao.getBlockEntryForId(blockId);
        if (block == null && this._dynamicGraph != null) {
            block = this._dynamicGraph.getBlockEntryForId(blockId);
        }
        if (block == null) {
            return null;
        }
        List<BlockConfigurationEntry> configurations = block.getConfigurations();
        int index = 0;
        Date date = new Date(serviceDate);
        InstanceState state = new InstanceState(serviceDate);
        for (BlockConfigurationEntry configuration : configurations) {
            if (this._blockIndexService.isDynamicBlock(configuration.getBlock()) || this.allServiceIdsAreActiveForServiceDate(configuration, date)) {
                return new BlockInstance(configuration, state);
            }
            ++index;
        }
        return null;
    }

    @Override
    public List<BlockInstance> getActiveBlocks(AgencyAndId blockId, long timeFrom, long timeTo) {
        List<BlockTripIndex> indices = this._blockIndexService.getBlockTripIndicesForBlock(blockId);
        List<BlockLayoverIndex> layoverIndices = this._blockIndexService.getBlockLayoverIndicesForBlock(blockId);
        List<FrequencyBlockTripIndex> frequencyIndices = this._blockIndexService.getFrequencyBlockTripIndicesForBlock(blockId);
        return this.getActiveBlocksInTimeRange(indices, layoverIndices, frequencyIndices, timeFrom, timeTo);
    }

    @Override
    public List<BlockInstance> getClosestActiveBlocks(AgencyAndId blockId, long time) {
        Date timeAsDate = new Date(time);
        Min m = new Min();
        BlockEntry blockEntry = this._transitGraphDao.getBlockEntryForId(blockId);
        if (blockEntry == null) {
            blockEntry = this._dynamicGraph.getBlockEntryForId(blockId);
        }
        if (blockEntry == null) {
            return m.getMinElements();
        }
        for (BlockConfigurationEntry blockConfig : blockEntry.getConfigurations()) {
            long delta;
            BlockInstance instance;
            List<Date> serviceDates = this._calendarService.getDatesForServiceIdsAsOrderedList(blockConfig.getServiceIds());
            int index = this.index(Collections.binarySearch(serviceDates, timeAsDate));
            if (index > 0) {
                instance = new BlockInstance(blockConfig, serviceDates.get(index - 1).getTime());
                delta = this.getTimeToBlockInstance(instance, time);
                m.add((double)delta, (Object)instance);
            }
            if (index >= serviceDates.size()) continue;
            instance = new BlockInstance(blockConfig, serviceDates.get(index).getTime());
            delta = this.getTimeToBlockInstance(instance, time);
            m.add((double)delta, (Object)instance);
        }
        return m.getMinElements();
    }

    @Override
    public List<BlockInstance> getActiveBlocksInTimeRange(long timeFrom, long timeTo) {
        List<BlockTripIndex> indices = this._blockIndexService.getBlockTripIndices();
        List<BlockLayoverIndex> layoverIndices = this._blockIndexService.getBlockLayoverIndices();
        List<FrequencyBlockTripIndex> frequencyIndices = this._blockIndexService.getFrequencyBlockTripIndices();
        return this.getActiveBlocksInTimeRange(indices, layoverIndices, frequencyIndices, timeFrom, timeTo);
    }

    @Override
    public List<BlockInstance> getActiveBlocksForAgencyInTimeRange(String agencyId, long timeFrom, long timeTo) {
        List<BlockTripIndex> indices = this._blockIndexService.getBlockTripIndicesForAgencyId(agencyId);
        List<BlockLayoverIndex> layoverIndices = this._blockIndexService.getBlockLayoverIndicesForAgencyId(agencyId);
        List<FrequencyBlockTripIndex> frequencyIndices = this._blockIndexService.getFrequencyBlockTripIndicesForAgencyId(agencyId);
        return this.getActiveBlocksInTimeRange(indices, layoverIndices, frequencyIndices, timeFrom, timeTo);
    }

    @Override
    public List<BlockInstance> getActiveBlocksForRouteInTimeRange(AgencyAndId routeId, long timeFrom, long timeTo) {
        List<BlockTripIndex> indices = this._blockIndexService.getBlockTripIndicesForRouteCollectionId(routeId);
        List<BlockLayoverIndex> layoverIndices = this._blockIndexService.getBlockLayoverIndicesForRouteCollectionId(routeId);
        List<FrequencyBlockTripIndex> frequencyIndices = this._blockIndexService.getFrequencyBlockTripIndicesForRouteCollectionId(routeId);
        return this.getActiveBlocksInTimeRange(indices, layoverIndices, frequencyIndices, timeFrom, timeTo);
    }

    @Override
    public List<BlockInstance> getActiveBlocksInTimeRange(Iterable<BlockTripIndex> indices, Iterable<BlockLayoverIndex> layoverIndices, Iterable<FrequencyBlockTripIndex> frequencyIndices, long timeFrom, long timeTo) {
        HashSet<BlockInstance> instances = new HashSet<BlockInstance>();
        for (BlockTripIndex blockTripIndex : indices) {
            this.getActiveBlocksInTimeRange(blockTripIndex, timeFrom, timeTo, instances);
        }
        for (BlockLayoverIndex blockLayoverIndex : layoverIndices) {
            this.getActiveLayoversInTimeRange(blockLayoverIndex, timeFrom, timeTo, instances);
        }
        for (FrequencyBlockTripIndex frequencyBlockTripIndex : frequencyIndices) {
            this.getActiveFrequencyBlocksInTimeRange(frequencyBlockTripIndex, timeFrom, timeTo, instances);
        }
        return new ArrayList<BlockInstance>(instances);
    }

    private boolean allServiceIdsAreActiveForServiceDate(BlockConfigurationEntry configuration, Date serviceDate) {
        Set<Date> serviceDates = this._calendarService.getDatesForServiceIds(configuration.getServiceIds());
        return serviceDates.contains(serviceDate);
    }

    private void getActiveBlocksInTimeRange(BlockTripIndex index, long timeFrom, long timeTo, Collection<BlockInstance> results) {
        Date dateFrom = new Date(timeFrom);
        Date dateTo = new Date(timeTo);
        this.handleBlockIndex(index, dateFrom, dateTo, results);
    }

    private Collection<BlockInstance> handleBlockIndex(BlockTripIndex index, Date timeFrom, Date timeTo, Collection<BlockInstance> instances) {
        List<BlockTripEntry> trips = index.getTrips();
        ServiceIntervalBlock serviceIntervalBlock = index.getServiceIntervalBlock();
        ServiceInterval serviceInterval = serviceIntervalBlock.getRange();
        Collection<Date> serviceDates = this._calendarService.getServiceDatesWithinRange(index.getServiceIds(), serviceInterval, timeFrom, timeTo);
        for (Date serviceDate : serviceDates) {
            this.findBlockTripsInRange(serviceIntervalBlock, serviceDate, timeFrom, timeTo, trips, instances);
        }
        return instances;
    }

    private void findBlockTripsInRange(ServiceIntervalBlock intervals, Date serviceDate, Date timeFrom, Date timeTo, List<BlockTripEntry> trips, Collection<BlockInstance> instances) {
        int scheduledTimeFrom = (int)((timeFrom.getTime() - serviceDate.getTime()) / 1000L);
        int scheduledTimeTo = (int)((timeTo.getTime() - serviceDate.getTime()) / 1000L);
        int indexFrom = this.index(Arrays.binarySearch(intervals.getMaxDepartures(), scheduledTimeFrom));
        int indexTo = this.index(Arrays.binarySearch(intervals.getMinArrivals(), scheduledTimeTo));
        InstanceState state = new InstanceState(serviceDate.getTime());
        if (indexFrom == indexTo && trips.get(0).getTrip() instanceof DynamicTripEntryImpl) {
            BlockTripEntry trip = trips.get(0);
            BlockConfigurationEntry block = trip.getBlockConfiguration();
            BlockInstance instance = new BlockInstance(block, state);
            instances.add(instance);
        }
        for (int in = indexFrom; in < indexTo; ++in) {
            BlockTripEntry trip = trips.get(in);
            BlockConfigurationEntry block = trip.getBlockConfiguration();
            BlockInstance instance = new BlockInstance(block, state);
            instances.add(instance);
        }
    }

    private void getActiveLayoversInTimeRange(BlockLayoverIndex index, long timeFrom, long timeTo, Collection<BlockInstance> results) {
        Date dateFrom = new Date(timeFrom);
        Date dateTo = new Date(timeTo);
        this.handleLayoverIndex(index, dateFrom, dateTo, results);
    }

    private Collection<BlockInstance> handleLayoverIndex(BlockLayoverIndex index, Date timeFrom, Date timeTo, Collection<BlockInstance> instances) {
        List<BlockTripEntry> trips = index.getTrips();
        LayoverIntervalBlock layoverIntervalBlock = index.getLayoverIntervalBlock();
        ServiceInterval serviceInterval = layoverIntervalBlock.getRange();
        Collection<Date> serviceDates = this._calendarService.getServiceDatesWithinRange(index.getServiceIds(), serviceInterval, timeFrom, timeTo);
        for (Date serviceDate : serviceDates) {
            this.findBlockLayoversInRange(layoverIntervalBlock, serviceDate, timeFrom, timeTo, trips, instances);
        }
        return instances;
    }

    private void findBlockLayoversInRange(LayoverIntervalBlock intervals, Date serviceDate, Date timeFrom, Date timeTo, List<BlockTripEntry> trips, Collection<BlockInstance> instances) {
        int scheduledTimeFrom = (int)((timeFrom.getTime() - serviceDate.getTime()) / 1000L);
        int scheduledTimeTo = (int)((timeTo.getTime() - serviceDate.getTime()) / 1000L);
        int indexFrom = this.index(Arrays.binarySearch(intervals.getEndTimes(), scheduledTimeFrom));
        int indexTo = this.index(Arrays.binarySearch(intervals.getStartTimes(), scheduledTimeTo));
        InstanceState state = new InstanceState(serviceDate.getTime());
        for (int in = indexFrom; in < indexTo; ++in) {
            BlockTripEntry trip = trips.get(in);
            BlockConfigurationEntry block = trip.getBlockConfiguration();
            BlockInstance instance = new BlockInstance(block, state);
            instances.add(instance);
        }
    }

    private void getActiveFrequencyBlocksInTimeRange(FrequencyBlockTripIndex index, long timeFrom, long timeTo, Collection<BlockInstance> results) {
        Date dateFrom = new Date(timeFrom);
        Date dateTo = new Date(timeTo);
        this.handleFrequencyBlockIndex(index, dateFrom, dateTo, results);
    }

    private Collection<BlockInstance> handleFrequencyBlockIndex(FrequencyBlockTripIndex index, Date timeFrom, Date timeTo, Collection<BlockInstance> instances) {
        List<BlockTripEntry> trips = index.getTrips();
        List<FrequencyEntry> frequencies = index.getFrequencies();
        FrequencyServiceIntervalBlock serviceIntervalBlock = index.getServiceIntervalBlock();
        ServiceInterval serviceInterval = serviceIntervalBlock.getRange();
        Collection<Date> serviceDates = this._calendarService.getServiceDatesWithinRange(index.getServiceIds(), serviceInterval, timeFrom, timeTo);
        for (Date serviceDate : serviceDates) {
            this.findFrequencyBlockTripsInRange(serviceIntervalBlock, serviceDate, timeFrom, timeTo, trips, frequencies, instances);
        }
        return instances;
    }

    private void findFrequencyBlockTripsInRange(FrequencyServiceIntervalBlock serviceIntervalIndex, Date serviceDate, Date timeFrom, Date timeTo, List<BlockTripEntry> trips, List<FrequencyEntry> frequencies, Collection<BlockInstance> instances) {
        int scheduledTimeFrom = (int)((timeFrom.getTime() - serviceDate.getTime()) / 1000L);
        int scheduledTimeTo = (int)((timeTo.getTime() - serviceDate.getTime()) / 1000L);
        int indexFrom = this.index(Arrays.binarySearch(serviceIntervalIndex.getEndTimes(), scheduledTimeFrom));
        int indexTo = this.index(Arrays.binarySearch(serviceIntervalIndex.getStartTimes(), scheduledTimeTo));
        for (int in = indexFrom; in < indexTo; ++in) {
            BlockTripEntry trip = trips.get(in);
            BlockConfigurationEntry block = trip.getBlockConfiguration();
            FrequencyEntry frequency = frequencies.get(in);
            InstanceState state = new InstanceState(serviceDate.getTime(), frequency);
            BlockInstance instance = new BlockInstance(block, state);
            instances.add(instance);
        }
    }

    private long getTimeToBlockInstance(BlockInstance instance, long time) {
        long serviceDate = instance.getServiceDate();
        BlockConfigurationEntry blockConfig = instance.getBlock();
        int n = blockConfig.getStopTimes().size();
        long from = serviceDate + (long)(blockConfig.getArrivalTimeForIndex(0) * 1000);
        long to = serviceDate + (long)(blockConfig.getDepartureTimeForIndex(n - 1) * 1000);
        return Math.abs((from + to) / 2L - time);
    }

    private int index(int index) {
        if (index < 0) {
            return -(index + 1);
        }
        return index;
    }
}

