/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.collections.Min;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.ProjectedPointFactory;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndIndex;
import org.onebusaway.transit_data_federation.impl.shapes.ShapePointsLibrary;
import org.onebusaway.transit_data_federation.model.ProjectedPoint;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockGeospatialService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocationService;
import org.onebusaway.transit_data_federation.services.shapes.ProjectedShapePointService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BlockGeospatialServiceImpl
implements BlockGeospatialService {
    private static Logger _log = LoggerFactory.getLogger(BlockGeospatialServiceImpl.class);
    private FederatedTransitDataBundle _bundle;
    private TransitGraphDao _transitGraphDao;
    private BlockCalendarService _blockCalendarService;
    private BlockIndexService _blockIndexService;
    private Map<AgencyAndId, List<BlockSequenceIndex>> _blockSequenceIndicesByShapeId = new HashMap<AgencyAndId, List<BlockSequenceIndex>>();
    private STRtree _tree = new STRtree();
    private ProjectedShapePointService _projectedShapePointService;
    private ShapePointsLibrary _shapePointsLibrary;
    private ScheduledBlockLocationService _scheduledBlockLocationService;

    BlockGeospatialServiceImpl() {
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setProjected(ProjectedShapePointService projectedShapePointService) {
        this._projectedShapePointService = projectedShapePointService;
    }

    @Autowired
    public void setShapePointsLibrary(ShapePointsLibrary shapePointsLibrary) {
        this._shapePointsLibrary = shapePointsLibrary;
    }

    @Autowired
    public void setScheduledBlockLocationService(ScheduledBlockLocationService scheduledBlockLocationService) {
        this._scheduledBlockLocationService = scheduledBlockLocationService;
    }

    @PostConstruct
    @Refreshable(dependsOn={"shapeGeospatialIndex", "blockIndexService"})
    public void setup() throws IOException, ClassNotFoundException {
        this._blockSequenceIndicesByShapeId.clear();
        this.groupBlockSequenceIndicesByShapeIds();
        this.buildShapeSpatialIndex();
    }

    @Override
    public List<BlockInstance> getActiveScheduledBlocksPassingThroughBounds(CoordinateBounds bounds, long timeFrom, long timeTo) {
        List<StopEntry> stops = this._transitGraphDao.getStopsByLocation(bounds);
        HashSet blockIds = new HashSet();
        for (StopEntry stopEntry : stops) {
            List<BlockStopTimeIndex> stopTimeIndices = this._blockIndexService.getStopTimeIndicesForStop(stopEntry);
            HashSet blockConfigs = new HashSet();
            List blockConfigsList = MappingLibrary.map(stopTimeIndices, (String)"blockConfigs");
            for (List l : blockConfigsList) {
                blockConfigs.addAll(l);
            }
            List stopBlockIds = MappingLibrary.map(blockConfigs, (String)"block.id");
            blockIds.addAll(stopBlockIds);
        }
        HashSet<BlockTripIndex> blockIndices = new HashSet<BlockTripIndex>();
        for (AgencyAndId blockId : blockIds) {
            blockIndices.addAll(this._blockIndexService.getBlockTripIndicesForBlock(blockId));
        }
        List<BlockLayoverIndex> list = Collections.emptyList();
        List<FrequencyBlockTripIndex> frequencyIndices = Collections.emptyList();
        return this._blockCalendarService.getActiveBlocksInTimeRange(blockIndices, list, frequencyIndices, timeFrom, timeTo);
    }

    @Override
    public Set<BlockSequenceIndex> getBlockSequenceIndexPassingThroughBounds(CoordinateBounds bounds) {
        Envelope env = new Envelope(bounds.getMinLon(), bounds.getMaxLon(), bounds.getMinLat(), bounds.getMaxLat());
        List results = this._tree.query(env);
        HashSet<AgencyAndId> visitedShapeIds = new HashSet<AgencyAndId>();
        HashSet<BlockSequenceIndex> allIndices = new HashSet<BlockSequenceIndex>();
        for (List shapeIds : results) {
            for (AgencyAndId shapeId : shapeIds) {
                List<BlockSequenceIndex> indices;
                if (!visitedShapeIds.add(shapeId) || CollectionsLibrary.isEmpty(indices = this._blockSequenceIndicesByShapeId.get(shapeId))) continue;
                allIndices.addAll(indices);
            }
        }
        return allIndices;
    }

    @Override
    public ScheduledBlockLocation getBestScheduledBlockLocationForLocation(BlockInstance blockInstance, CoordinatePoint location, long timestamp, double blockDistanceFrom, double blockDistanceTo) {
        BlockConfigurationEntry block = blockInstance.getBlock();
        ProjectedPoint targetPoint = ProjectedPointFactory.forward(location);
        List shapePointIds = MappingLibrary.map(block.getTrips(), (String)"trip.shapeId");
        T2<List<XYPoint>, double[]> tuple = this._projectedShapePointService.getProjectedShapePoints(shapePointIds, targetPoint.getSrid());
        if (tuple == null) {
            throw new IllegalStateException("block had no shape points: " + block.getBlock().getId());
        }
        List projectedShapePoints = (List)tuple.getFirst();
        double[] distances = (double[])tuple.getSecond();
        int fromIndex = 0;
        int toIndex = distances.length;
        if (blockDistanceFrom > 0.0 && (fromIndex = Arrays.binarySearch(distances, blockDistanceFrom)) < 0 && (fromIndex = -(fromIndex + 1)) > 0) {
            --fromIndex;
        }
        if (blockDistanceTo < distances[distances.length - 1] && (toIndex = Arrays.binarySearch(distances, blockDistanceTo)) < 0 && (toIndex = -(toIndex + 1)) < distances.length) {
            ++toIndex;
        }
        XYPoint xyPoint = new XYPoint(targetPoint.getX(), targetPoint.getY());
        List<PointAndIndex> assignments = this._shapePointsLibrary.computePotentialAssignments(projectedShapePoints, distances, xyPoint, fromIndex, toIndex);
        Min best = new Min();
        for (PointAndIndex index : assignments) {
            ScheduledBlockLocation blockLocation;
            double distanceAlongBlock = index.distanceAlongShape;
            if (distanceAlongBlock > block.getTotalBlockDistance()) {
                distanceAlongBlock = block.getTotalBlockDistance();
            }
            if ((blockLocation = this._scheduledBlockLocationService.getScheduledBlockLocationFromDistanceAlongBlock(block, distanceAlongBlock)) == null) continue;
            int scheduledTime = blockLocation.getScheduledTime();
            long scheduleTimestamp = blockInstance.getServiceDate() + (long)(scheduledTime * 1000);
            double delta = Math.abs(scheduleTimestamp - timestamp);
            best.add(delta, (Object)blockLocation);
        }
        return (ScheduledBlockLocation)best.getMinElement();
    }

    private void groupBlockSequenceIndicesByShapeIds() {
        List<BlockSequenceIndex> indices = this._blockIndexService.getAllBlockSequenceIndices();
        for (BlockSequenceIndex index : indices) {
            HashSet<AgencyAndId> shapeIdsForIndex = new HashSet<AgencyAndId>();
            for (BlockSequence sequence : index.getSequences()) {
                for (BlockStopTimeEntry bst : sequence.getStopTimes()) {
                    BlockTripEntry blockTrip = bst.getTrip();
                    TripEntry trip = blockTrip.getTrip();
                    AgencyAndId shapeId = trip.getShapeId();
                    if (shapeId == null) continue;
                    shapeIdsForIndex.add(shapeId);
                }
            }
            for (AgencyAndId shapeId : shapeIdsForIndex) {
                List<BlockSequenceIndex> list = this._blockSequenceIndicesByShapeId.get(shapeId);
                if (list == null) {
                    list = new ArrayList<BlockSequenceIndex>();
                    this._blockSequenceIndicesByShapeId.put(shapeId, list);
                }
                list.add(index);
            }
        }
    }

    private void buildShapeSpatialIndex() throws IOException, ClassNotFoundException {
        File path = this._bundle.getShapeGeospatialIndexDataPath();
        if (!path.exists()) {
            this._tree = null;
            return;
        }
        _log.info("loading shape point geospatial index...");
        Map shapeIdsByGridCell = (Map)ObjectSerializationLibrary.readObject((File)path);
        _log.info("block shape geospatial nodes: " + shapeIdsByGridCell.size());
        if (shapeIdsByGridCell.isEmpty()) {
            this._tree = null;
            return;
        }
        this._tree = new STRtree(shapeIdsByGridCell.size());
        for (Map.Entry entry : shapeIdsByGridCell.entrySet()) {
            CoordinateBounds b = (CoordinateBounds)entry.getKey();
            Envelope env = new Envelope(b.getMinLon(), b.getMaxLon(), b.getMinLat(), b.getMaxLat());
            List shapeIds = (List)entry.getValue();
            this._tree.insert(env, (Object)shapeIds);
        }
        this._tree.build();
    }
}

