/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicHelper;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.DynamicBlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyStopTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.StaticBlockIndexService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BlockIndexServiceImpl
implements BlockIndexService {
    @Qualifier(value="staticBlockIndexServiceImpl")
    @Autowired
    StaticBlockIndexService staticBlockIndexService;
    @Qualifier(value="dynamicBlockIndexServiceImpl")
    @Autowired
    DynamicBlockIndexService dynamicBlockIndexService;
    private DynamicHelper helper = new DynamicHelper();

    public void setStaticBlockIndexService(StaticBlockIndexService staticBlockIndexService) {
        this.staticBlockIndexService = staticBlockIndexService;
    }

    public void setDynamicBlockIndexService(DynamicBlockIndexService dynamicBlockIndexService) {
        this.dynamicBlockIndexService = dynamicBlockIndexService;
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndices() {
        return this.staticBlockIndexService.getBlockTripIndices();
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForAgencyId(String agencyId) {
        return this.staticBlockIndexService.getBlockTripIndicesForAgencyId(agencyId);
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        ArrayList<BlockTripIndex> list = new ArrayList<BlockTripIndex>();
        List<BlockTripIndex> indices = this.staticBlockIndexService.getBlockTripIndicesForRouteCollectionId(routeCollectionId);
        if (indices != null) {
            list.addAll(indices);
        }
        if (this.dynamicBlockIndexService != null && (indices = this.dynamicBlockIndexService.getBlockTripIndicesForRouteCollectionId(routeCollectionId)) != null) {
            list.addAll(indices);
        }
        return list;
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForBlock(AgencyAndId blockId) {
        List<BlockTripIndex> dynamicIndices;
        ArrayList<BlockTripIndex> indices = new ArrayList<BlockTripIndex>();
        List<BlockTripIndex> staticIndices = this.staticBlockIndexService.getBlockTripIndicesForBlock(blockId);
        if (staticIndices != null) {
            indices.addAll(staticIndices);
        }
        if (this.dynamicBlockIndexService != null && (dynamicIndices = this.dynamicBlockIndexService.getBlockTripIndicesForBlock(blockId)) != null) {
            indices.addAll(dynamicIndices);
        }
        return indices;
    }

    @Override
    public List<BlockStopTimeIndex> getStopTimeIndicesForStop(StopEntry stopEntry) {
        List<BlockStopTimeIndex> dynamicIndicies;
        ArrayList<BlockStopTimeIndex> list = new ArrayList<BlockStopTimeIndex>();
        List<BlockStopTimeIndex> staticIndices = this.staticBlockIndexService.getStopTimeIndicesForStop(stopEntry);
        if (staticIndices != null) {
            list.addAll(staticIndices);
        }
        if (this.dynamicBlockIndexService != null && (dynamicIndicies = this.dynamicBlockIndexService.getStopTimeIndicesForStop(stopEntry)) != null) {
            list.addAll(dynamicIndicies);
        }
        return list;
    }

    @Override
    public void register(BlockInstance blockInstance, long currentTime) {
        this.dynamicBlockIndexService.register(blockInstance, currentTime);
    }

    @Override
    public BlockInstance getDynamicBlockInstance(AgencyAndId blockId) {
        return this.dynamicBlockIndexService.getDynamicBlockInstance(blockId);
    }

    @Override
    public List<BlockStopSequenceIndex> getStopSequenceIndicesForStop(StopEntry stopEntry) {
        return this.staticBlockIndexService.getStopSequenceIndicesForStop(stopEntry);
    }

    @Override
    public List<BlockSequenceIndex> getAllBlockSequenceIndices() {
        return this.staticBlockIndexService.getAllBlockSequenceIndices();
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndices() {
        return this.staticBlockIndexService.getBlockLayoverIndices();
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForAgencyId(String agencyId) {
        return this.staticBlockIndexService.getBlockLayoverIndicesForAgencyId(agencyId);
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForRouteCollectionId(AgencyAndId rotueCollectionId) {
        return this.staticBlockIndexService.getBlockLayoverIndicesForRouteCollectionId(rotueCollectionId);
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForBlock(AgencyAndId blockId) {
        return this.staticBlockIndexService.getBlockLayoverIndicesForBlock(blockId);
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndices() {
        return this.staticBlockIndexService.getFrequencyBlockTripIndices();
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForAgencyId(String agencyId) {
        return this.staticBlockIndexService.getFrequencyBlockTripIndicesForAgencyId(agencyId);
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this.staticBlockIndexService.getFrequencyBlockTripIndicesForRouteCollectionId(routeCollectionId);
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForBlock(AgencyAndId blockId) {
        return this.staticBlockIndexService.getFrequencyBlockTripIndicesForBlock(blockId);
    }

    @Override
    public List<FrequencyBlockStopTimeIndex> getFrequencyStopTimeIndicesForStop(StopEntry stopEntry) {
        return this.staticBlockIndexService.getFrequencyStopTimeIndicesForStop(stopEntry);
    }

    @Override
    public List<FrequencyStopTripIndex> getFrequencyStopTripIndicesForStop(StopEntry stop) {
        return this.staticBlockIndexService.getFrequencyStopTripIndicesForStop(stop);
    }

    @Override
    public boolean isDynamicTrip(TripEntry trip) {
        return this.helper.isServiceIdDynamic(trip.getServiceId().toString());
    }

    @Override
    public boolean isDynamicBlock(BlockEntry block) {
        return this.helper.isBlockDynamic(block);
    }
}

