/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.transit_data_federation.model.bundle.BlockRunIndex;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockRunService;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockRunServiceImpl
implements BlockRunService {
    private static Logger _log = LoggerFactory.getLogger(BlockRunServiceImpl.class);
    private FederatedTransitDataBundle _bundle;
    private Map<String, List<BlockRunIndex>> _map = null;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        _log.info("bundle path=" + this._bundle.getPath());
        File path = this._bundle.getBlockRunDataPath();
        if (path.exists()) {
            _log.info("loading BlockRunIndex...");
            this._map = (Map)ObjectSerializationLibrary.readObject((File)path);
            _log.info("loading BlockRunIndex...done");
        } else {
            _log.info("failed BlockRunIndex load, path not found of " + path);
            this._map = new HashMap<String, List<BlockRunIndex>>();
        }
    }

    @Override
    public List<Integer> getBlockIds(Integer routeKey, Integer runId) {
        List<BlockRunIndex> index = this._map.get(this.hash(routeKey, runId));
        if (index == null) {
            _log.debug("miss for hash=" + this.hash(routeKey, runId));
            return null;
        }
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (BlockRunIndex blockRunIndex : index) {
            blockIds.add(blockRunIndex.getBlockId());
        }
        return blockIds;
    }

    private String hash(Integer routeKey, Integer runId) {
        if (routeKey == null || runId == null) {
            return null;
        }
        return routeKey + ":" + runId;
    }

    public void addRunBlock(int runId, int routeKey, int blockId) {
        List<Object> list;
        String key = this.hash(routeKey, runId);
        if (!this._map.containsKey(key)) {
            list = new ArrayList();
            this._map.put(key, list);
        } else {
            list = this._map.get(key);
        }
        BlockRunIndex.Builder index = BlockRunIndex.builder();
        index.setRunId(runId);
        index.setRouteKey(routeKey);
        index.setBlockId(blockId);
        list.add(index.create());
    }
}

