/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.HasBlockStopTimes;

public class BlockSequence
implements HasBlockStopTimes {
    private final BlockConfigurationEntry blockConfig;
    private final int blockSequenceFrom;
    private final int blockSequenceTo;

    public BlockSequence(BlockConfigurationEntry blockConfig, int blockSequenceFrom, int blockSequenceTo) {
        this.blockConfig = blockConfig;
        this.blockSequenceFrom = blockSequenceFrom;
        this.blockSequenceTo = blockSequenceTo;
    }

    public BlockConfigurationEntry getBlockConfig() {
        return this.blockConfig;
    }

    public int getBlockSequenceFrom() {
        return this.blockSequenceFrom;
    }

    public int getBlockSequenceTo() {
        return this.blockSequenceTo;
    }

    @Override
    public List<BlockStopTimeEntry> getStopTimes() {
        List<BlockStopTimeEntry> stopTimes = this.blockConfig.getStopTimes();
        return stopTimes.subList(this.blockSequenceFrom, this.blockSequenceTo);
    }

    public int getArrivalTimeForIndex(int index) {
        return this.blockConfig.getArrivalTimeForIndex(this.blockSequenceFrom + index);
    }

    public int getDepartureTimeForIndex(int index) {
        return this.blockConfig.getDepartureTimeForIndex(this.blockSequenceFrom + index);
    }
}

