/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import net.sf.ehcache.CacheManager;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.bundle.BundleScheduler;
import org.onebusaway.transit_data_federation.impl.bundle.HourlyBundleSchedulerImpl;
import org.onebusaway.transit_data_federation.impl.bundle.HttpBundleStoreImpl;
import org.onebusaway.transit_data_federation.impl.bundle.IntervalBundleSchedulerImpl;
import org.onebusaway.transit_data_federation.impl.bundle.LocalBundleStoreImpl;
import org.onebusaway.transit_data_federation.impl.bundle.S3BundleStoreImpl;
import org.onebusaway.transit_data_federation.impl.config.BundleConfigDao;
import org.onebusaway.transit_data_federation.model.bundle.BundleItem;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.bundle.BundleManagementService;
import org.onebusaway.transit_data_federation.services.bundle.BundleStoreService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.util.HttpServiceClient;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class BundleManagementServiceImpl
implements BundleManagementService {
    protected static final int INFERENCE_PROCESSING_THREAD_WAIT_TIMEOUT_IN_SECONDS = 60;
    protected static final int MAX_EXPECTED_THREADS = 3000;
    private static final int REFRESH_INTERVAL_MINUTES = 1;
    private static Logger _log = LoggerFactory.getLogger(BundleManagementServiceImpl.class);
    protected BundleConfigDao _bundleConfigDao;
    private List<BundleItem> _allBundles = new ArrayList<BundleItem>();
    protected HashMap<String, BundleItem> _applicableBundles = new HashMap();
    protected volatile List<Future> _inferenceProcessingThreads = new ArrayList<Future>();
    protected String _bundleRootPath = null;
    private BundleStoreService _bundleStore = null;
    protected boolean _standaloneMode = true;
    private String _remoteSourceURI = null;
    protected boolean _builderMode = false;
    protected boolean _bundleIsReady = false;
    protected String _currentBundleId = null;
    protected ServiceDate _currentServiceDate = null;
    protected HttpServiceClient _restApiLibrary;
    @Autowired
    protected TransitDataService _transitDataService;
    @Autowired
    protected TransitGraphDao _transitGraphDao;
    @Autowired
    protected FederatedTransitDataBundle _bundle;
    @Autowired
    protected ThreadPoolTaskScheduler _taskScheduler;
    protected BundleScheduler _scheduler = null;
    @Autowired
    protected RefreshService _refreshService;

    @Override
    public int getApplicableBundlesSize() {
        return this._applicableBundles.size();
    }

    @Override
    public String getCurrentBundleId() {
        return this._currentBundleId;
    }

    @Autowired
    public void set_restApiLibrary(HttpServiceClient _restApiLibrary) {
        this._restApiLibrary = _restApiLibrary;
    }

    @Autowired
    public void setBundleConfigDao(BundleConfigDao bundleConfigDao) {
        this._bundleConfigDao = bundleConfigDao;
    }

    @PostConstruct
    protected void setup() throws Exception {
        if (this._builderMode) {
            String bundleRoot = System.getProperty("bundle.root");
            _log.info("builder mode:  using bundle.root of " + bundleRoot);
            this._bundleStore = new LocalBundleStoreImpl(bundleRoot);
            this._scheduler = new HourlyBundleSchedulerImpl();
            this._scheduler.setup(this, this._taskScheduler);
            return;
        }
        if (!this._standaloneMode) {
            this._bundleStore = new HttpBundleStoreImpl(this._bundleRootPath, this._restApiLibrary);
            this._scheduler = new HourlyBundleSchedulerImpl();
            this._scheduler.setup(this, this._taskScheduler);
        } else if (this._remoteSourceURI == null) {
            this._bundleStore = new LocalBundleStoreImpl(this._bundleRootPath);
            this._scheduler = new HourlyBundleSchedulerImpl();
            this._scheduler.setup(this, this._taskScheduler);
        } else {
            _log.info("setting up interval based bundle refresh with refresh interval=1");
            this._bundleStore = new S3BundleStoreImpl(this._bundleRootPath, this._remoteSourceURI);
            this._scheduler = new IntervalBundleSchedulerImpl(1);
            this._scheduler.setup(this, this._taskScheduler);
            _log.info("when using interval based we discover on a thread, returning...");
            return;
        }
        try {
            this.discoverBundles();
        }
        catch (Exception e) {
            _log.error("Unable to retrieve Bundle List.", (Throwable)e);
            if (!(this._bundleStore instanceof LocalBundleStoreImpl)) {
                _log.info("Attempting to load local Bundle...");
                this._bundleStore = new LocalBundleStoreImpl(this._bundleRootPath);
                this.discoverBundles();
            }
            throw e;
        }
        this.refreshApplicableBundles();
        this.reevaluateBundleAssignment();
        this._scheduler.setup(this, this._taskScheduler);
    }

    @Override
    public void discoverBundles() throws Exception {
        this._allBundles = this._bundleStore.getBundles();
    }

    @Override
    public synchronized void refreshApplicableBundles() {
        this._applicableBundles.clear();
        for (BundleItem bundle : this._allBundles) {
            if (!bundle.isApplicableToDate(this.getServiceDate())) continue;
            _log.info("Bundle " + bundle.getName() + "(" + bundle.getId() + ") is active for today; adding to list of active bundles.");
            this._applicableBundles.put(bundle.getId(), bundle);
        }
    }

    @Override
    public void reevaluateBundleAssignment() throws Exception {
        if (this._applicableBundles.size() == 0) {
            _log.error("No valid and active bundles found!");
            return;
        }
        ArrayList<BundleItem> bestBundleCandidates = new ArrayList<BundleItem>(this._applicableBundles.values());
        Collections.sort(bestBundleCandidates);
        BundleItem bestBundle = bestBundleCandidates.get(bestBundleCandidates.size() - 1);
        _log.info("Best bundle is " + bestBundle.getName() + " (" + bestBundle.getId() + ")");
        this.changeBundle(bestBundle.getId(), bestBundle.getName());
    }

    @Override
    public String getBundleStoreRoot() {
        return this._bundleRootPath;
    }

    @Override
    public void setBundleStoreRoot(String path) throws Exception {
        File bundleRootPath = new File(path);
        this._bundleRootPath = path;
    }

    @Override
    public void setTime(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        this._currentServiceDate = new ServiceDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        this.refreshApplicableBundles();
    }

    @Override
    public void setServiceDate(ServiceDate serviceDate) {
        this._currentServiceDate = serviceDate;
        this.refreshApplicableBundles();
    }

    @Override
    public ServiceDate getServiceDate() {
        if (this._currentServiceDate != null) {
            return this._currentServiceDate;
        }
        return new ServiceDate();
    }

    @Override
    public void setStandaloneMode(boolean standalone) {
        this._standaloneMode = standalone;
    }

    public void setRemoteSourceURI(String s) {
        this._remoteSourceURI = s;
    }

    @Override
    public boolean getStandaloneMode() {
        return this._standaloneMode;
    }

    public void setBuilderMode(boolean builderMode) {
        this._builderMode = builderMode;
    }

    @Override
    public String getActiveBundleId() {
        if (this._bundleConfigDao == null) {
            if (this._currentBundleId == null) {
                _log.error("config error:  bundleConfigDao is null");
                return null;
            }
            _log.warn("config error:  bundleConfigDao is null, returning currentBundleId value instead.");
            _log.debug("Legacy Bundle most likely not detected");
            return this._currentBundleId;
        }
        if (this._bundleConfigDao.getBundleMetadata() == null) {
            _log.error("data error:  getBundleMetadata is null");
            return Integer.toString(this._bundleRootPath.hashCode());
        }
        return this._bundleConfigDao.getBundleMetadata().getId();
    }

    @Override
    public BundleMetadata getBundleMetadata() {
        if (this._bundleConfigDao == null) {
            _log.error("config error:  bundleConfigDao is null");
            return null;
        }
        return this._bundleConfigDao.getBundleMetadata();
    }

    @Override
    public List<BundleItem> getAllKnownBundles() {
        return this._allBundles;
    }

    @Override
    public boolean bundleWithIdExists(String bundleId) {
        return this._applicableBundles.containsKey(bundleId);
    }

    @Override
    public BundleItem getCurrentBundleMetadata() {
        return this._applicableBundles.get(this._currentBundleId);
    }

    @Override
    public Boolean bundleIsReady() {
        if (!this._builderMode) {
            return this._bundleIsReady;
        }
        return true;
    }

    @Override
    public void registerInferenceProcessingThread(Future thread) {
        this._inferenceProcessingThreads.add(thread);
        if (this._inferenceProcessingThreads.size() > 3000) {
            this.removeDeadInferenceThreads();
        }
    }

    @Override
    public void changeBundle(String bundleId) throws Exception {
        this.changeBundle(bundleId, bundleId);
    }

    public void changeBundle(String bundleId, String bundleName) throws Exception {
        if (bundleId == null || !this._applicableBundles.containsKey(bundleId)) {
            throw new Exception("Bundle " + bundleName + " is not valid or does not exist.");
        }
        if (bundleId.equals(this._currentBundleId)) {
            _log.info("Received command to change to " + bundleName + " (" + bundleId + "); bundle is already active.");
            return;
        }
        _log.info("Switching to bundle " + bundleName + " (" + bundleId + ")...");
        this._bundleIsReady = false;
        int t = 12;
        while (t-- >= 0) {
            this.removeDeadInferenceThreads();
            _log.info("Waiting for all inference processing threads to exit... " + this._inferenceProcessingThreads.size() + " thread(s) left.");
            if (this.allInferenceThreadsHaveExited()) break;
            if (t == 0) {
                for (Future thread : this._inferenceProcessingThreads) {
                    if (thread.isDone() || thread.isCancelled()) continue;
                    thread.cancel(true);
                }
                this._inferenceProcessingThreads.clear();
                break;
            }
            Thread.yield();
            Thread.sleep(5000L);
        }
        _log.info("All inference processing threads have now exited--changing bundle...");
        this._refreshService.refresh("startBundleSwap");
        File path = this._bundleStore.isLegacyBundle() ? new File(this._bundleRootPath) : new File(this._bundleRootPath, bundleName);
        this._bundle.setPath(path);
        try {
            this._refreshService.refresh("transitGraph");
            this.timingHook();
            this._refreshService.refresh("calendarData");
            this._refreshService.refresh("routeCollectionsData");
            this._refreshService.refresh("routeCollectionSearchData");
            this._refreshService.refresh("stopSearchData");
            this._refreshService.refresh("blockIndexData");
            this._refreshService.refresh("blockIndexService");
            this._refreshService.refresh("shapeGeospatialIndex");
            this._refreshService.refresh("stopGeospatialIndex");
            this._refreshService.refresh("narrativeData");
            this._refreshService.refresh("stopConsolidationFile");
        }
        catch (Exception e) {
            _log.error("Bundle " + bundleName + "(" + bundleId + ") failed to load. Disabling for this session...", (Throwable)e);
            this._applicableBundles.remove(bundleId);
            this.reevaluateBundleAssignment();
            throw new Exception("Bundle " + bundleName + "(" + bundleId + ") loading exception. Root exception follows.", e);
        }
        _log.info("Refresh/reload of bundle data complete.");
        System.gc();
        System.gc();
        _log.info("Garbage collection after bundle switch complete.");
        this._currentBundleId = bundleId;
        this._bundleIsReady = true;
        _log.info("New bundle is now ready.");
        this.removeAndRebuildCache();
        this._refreshService.refresh("stopBundleSwap");
        _log.info("Cache rebuild complete.");
    }

    protected void timingHook() {
    }

    private void removeAndRebuildCache() {
        this.timingHook();
        _log.info("Clearing all caches...");
        for (Object cacheManager : CacheManager.ALL_CACHE_MANAGERS) {
            _log.info("Found " + cacheManager.getName());
            for (String string : cacheManager.getCacheNames()) {
                _log.info(" > Cache: " + (String)string);
                cacheManager.getCache(string).flush();
                cacheManager.clearAllStartingWith(string);
            }
            cacheManager.clearAll();
        }
        try {
            List agenciesWithCoverage = this._transitDataService.getAgenciesWithCoverage();
            for (AgencyWithCoverageBean agencyWithCoverage : agenciesWithCoverage) {
                AgencyBean agency = agencyWithCoverage.getAgency();
                ListBean stopIds = this._transitDataService.getStopIdsForAgencyId(agency.getId());
                for (String stopId : stopIds.getList()) {
                    this._transitDataService.getStop(stopId);
                }
                ListBean listBean = this._transitDataService.getRouteIdsForAgencyId(agency.getId());
                for (String routeId : listBean.getList()) {
                    this._transitDataService.getStopsForRoute(routeId);
                }
            }
            HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
            for (TripEntry trip : this._transitGraphDao.getAllTrips()) {
                AgencyAndId shapeId = trip.getShapeId();
                if (shapeId == null || !shapeId.hasValues()) continue;
                shapeIds.add(shapeId);
            }
            for (AgencyAndId shapeId : shapeIds) {
                this._transitDataService.getShapeForId(AgencyAndIdLibrary.convertToString((AgencyAndId)shapeId));
            }
            _log.info("cache clearing complete!");
        }
        catch (Exception e) {
            _log.error("Exception during cache rebuild: ", (Object)e.getMessage());
        }
    }

    protected void removeDeadInferenceThreads() {
        ArrayList<Future> finishedThreads = new ArrayList<Future>();
        for (Future future : this._inferenceProcessingThreads) {
            if (!future.isDone() && !future.isCancelled()) continue;
            finishedThreads.add(future);
        }
        for (Future<Object> future : finishedThreads) {
            this._inferenceProcessingThreads.remove(future);
        }
    }

    protected boolean allInferenceThreadsHaveExited() {
        this.removeDeadInferenceThreads();
        return this._inferenceProcessingThreads.size() == 0;
    }
}

