/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.model.bundle.BundleFileItem;
import org.onebusaway.transit_data_federation.model.bundle.BundleItem;
import org.onebusaway.transit_data_federation.services.bundle.BundleStoreService;
import org.onebusaway.transit_data_federation.util.HttpServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBundleStoreImpl
implements BundleStoreService {
    private static Logger _log = LoggerFactory.getLogger(HttpBundleStoreImpl.class);
    private static final DateTimeFormatter _updatedDateFormatter = ISODateTimeFormat.dateTimeNoMillis();
    private static final int _fileDownloadRetries = 2;
    private String _bundleRootPath = null;
    private HttpServiceClient _apiLibrary;

    public HttpBundleStoreImpl(String bundleRootPath, HttpServiceClient apiLibrary) throws Exception {
        this._bundleRootPath = bundleRootPath;
        this._apiLibrary = apiLibrary;
    }

    private List<BundleItem> getBundleListFromHttp() {
        ArrayList<BundleItem> output = new ArrayList<BundleItem>();
        _log.info("Getting current bundle list from Server...");
        List<JsonObject> bundles = null;
        try {
            bundles = this._apiLibrary.getItemsForRequest("bundle", "list");
        }
        catch (Exception e) {
            _log.info("Error executing apiLibrary.getItemsForRequest", (Throwable)e);
        }
        if (bundles != null) {
            for (JsonObject itemToAdd : bundles) {
                try {
                    BundleItem item = new BundleItem();
                    if (itemToAdd.get("id") == null) {
                        item.setId(this.getJsonObjAsString(itemToAdd, "name"));
                    } else {
                        item.setId(this.getJsonObjAsString(itemToAdd, "id"));
                    }
                    item.setName(this.getJsonObjAsString(itemToAdd, "name"));
                    item.setServiceDateFrom(ServiceDate.parseString((String)this.getJsonObjAsString(itemToAdd, "service-date-from").replace("-", "")));
                    item.setServiceDateTo(ServiceDate.parseString((String)this.getJsonObjAsString(itemToAdd, "service-date-to").replace("-", "")));
                    if (itemToAdd.get("created") != null) {
                        item.setCreated(_updatedDateFormatter.parseDateTime(this.getJsonObjAsString(itemToAdd, "created")));
                    }
                    if (itemToAdd.get("updated") != null) {
                        item.setUpdated(_updatedDateFormatter.parseDateTime(this.getJsonObjAsString(itemToAdd, "updated")));
                    }
                    ArrayList<BundleFileItem> files = new ArrayList<BundleFileItem>();
                    JsonElement filesElement = itemToAdd.get("files");
                    if (filesElement != null && filesElement.isJsonArray()) {
                        for (JsonElement _subitemToAdd : filesElement.getAsJsonArray()) {
                            if (_subitemToAdd.isJsonObject()) {
                                JsonObject subitemToAdd = _subitemToAdd.getAsJsonObject();
                                BundleFileItem fileItemToAdd = new BundleFileItem();
                                fileItemToAdd.setFilename(this.getJsonObjAsString(subitemToAdd, "filename"));
                                fileItemToAdd.setMd5(this.getJsonObjAsString(subitemToAdd, "md5"));
                                files.add(fileItemToAdd);
                                continue;
                            }
                            _log.warn("Unable to retreive file name/md5 as Json Object");
                        }
                        item.setFiles(files);
                        output.add(item);
                        continue;
                    }
                    _log.warn("Unable to get list of files for Bundle " + item.getName());
                }
                catch (NullPointerException npe) {
                    _log.warn("Error retrieving bundle information");
                }
                catch (ParseException e) {
                    _log.warn("Error parsing dates for Bundle Item");
                }
            }
            _log.info("Found " + output.size() + " bundle(s) available from the Server.");
        }
        return output;
    }

    private void downloadUrlToLocalPath(URL url, File destFilename, String expectedMd5) throws Exception {
        try {
            int readBytes;
            _log.info("Downloading bundle item from " + url + "...");
            File containerPath = destFilename.getParentFile();
            if (!containerPath.exists() && !containerPath.mkdirs()) {
                throw new Exception("Could not create parent directories for path " + destFilename);
            }
            if (!destFilename.createNewFile()) {
                throw new Exception("Could not create empty file at path " + destFilename);
            }
            FileOutputStream out = new FileOutputStream(destFilename.getPath());
            BufferedOutputStream bufferedOut = new BufferedOutputStream(out, 1024);
            MessageDigest md5Hasher = MessageDigest.getInstance("MD5");
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            byte[] data = new byte[1024];
            while ((readBytes = in.read(data, 0, data.length)) >= 0) {
                md5Hasher.update(data, 0, readBytes);
                bufferedOut.write(data, 0, readBytes);
            }
            bufferedOut.close();
            out.close();
            in.close();
            byte[] messageDigest = md5Hasher.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String hex = Integer.toHexString(0xFF & messageDigest[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            if (!hexString.toString().equals(expectedMd5)) {
                throw new Exception("MD5 hash doesn't match.");
            }
        }
        catch (Exception e) {
            if (!destFilename.delete() && destFilename.exists()) {
                throw new Exception("Could not delete corrupted file " + destFilename);
            }
            throw e;
        }
    }

    @Override
    public List<BundleItem> getBundles() throws Exception {
        ArrayList<BundleItem> output = new ArrayList<BundleItem>();
        List<BundleItem> bundlesFromHttp = this.getBundleListFromHttp();
        for (BundleItem bundle : bundlesFromHttp) {
            boolean bundleIsValid = true;
            File bundleRoot = new File(this._bundleRootPath, bundle.getName());
            if (!bundleRoot.exists() && !bundleRoot.mkdirs()) {
                throw new Exception("Creation of bundle root for " + bundle.getName() + " at " + bundleRoot + " failed.");
            }
            block3: for (BundleFileItem file : bundle.getFiles()) {
                File fileInBundlePath = new File(bundleRoot, file.getFilename());
                if (fileInBundlePath.exists() && !file.verifyMd5(fileInBundlePath)) {
                    _log.warn("File " + fileInBundlePath + " is corrupted; removing.");
                    if (!fileInBundlePath.delete()) {
                        _log.error("Could not remove corrupted file " + fileInBundlePath);
                        bundleIsValid = false;
                        break;
                    }
                }
                if (fileInBundlePath.exists()) continue;
                int tries = 2;
                while (tries > 0) {
                    URL fileDownloadUrl = this._apiLibrary.buildUrl("bundle", "deploy", bundle.getName(), "file", file.getFilename(), "get");
                    try {
                        this.downloadUrlToLocalPath(fileDownloadUrl, fileInBundlePath, file.getMd5());
                        continue block3;
                    }
                    catch (Exception e) {
                        if (--tries == 0) {
                            bundleIsValid = false;
                        }
                        _log.warn("Download of " + fileDownloadUrl + " failed (" + e.getMessage() + "); retrying (retries left=" + tries + ")");
                    }
                }
            }
            if (bundleIsValid) {
                _log.info("Bundle " + bundle.getName() + " files pass checksums; added to list of local bundles.");
                output.add(bundle);
                continue;
            }
            _log.warn("Bundle " + bundle.getName() + " files do NOT pass checksums; skipped.");
        }
        return output;
    }

    @Override
    public boolean isLegacyBundle() {
        return false;
    }

    private String getJsonObjAsString(JsonObject json, String key) throws NullPointerException {
        if (json.get(key) != null) {
            return json.get(key).getAsString();
        }
        _log.warn("Json member name : " + key + " not found");
        throw new NullPointerException();
    }
}

