/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeSource;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RealtimeSourceServiceImpl {
    private static Logger _log = LoggerFactory.getLogger(RealtimeSourceServiceImpl.class);
    @Autowired
    private ListableBeanFactory beanFactory;

    public String[] getSourceNames() {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, GtfsRealtimeSource.class);
    }

    public List<GtfsRealtimeSource> getSources() {
        ArrayList<GtfsRealtimeSource> sources = new ArrayList<GtfsRealtimeSource>();
        for (String sourceName : this.getSourceNames()) {
            sources.add((GtfsRealtimeSource)this.beanFactory.getBean(sourceName));
        }
        _log.debug("returning " + sources.size() + " sources");
        return sources;
    }

    public boolean getPlaybackEnabled() {
        return SystemTime.getAdjustment() != 0L;
    }

    public boolean getSystemTimeAdjustmentEnabled() {
        return SystemTime.isEnabled();
    }

    public String getCurrentTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(SystemTime.currentTimeMillis()));
    }
}

