/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.narrative;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.model.narrative.AgencyNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteAndHeadsignNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopDirectionKey;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopTimeNarrative;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public final class NarrativeProviderImpl
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Map<String, AgencyNarrative> _agencyNarratives = new HashMap<String, AgencyNarrative>();
    private Map<AgencyAndId, StopNarrative> _stopNarratives = new HashMap<AgencyAndId, StopNarrative>();
    private Map<AgencyAndId, RouteCollectionNarrative> _routeCollectionNarratives = new HashMap<AgencyAndId, RouteCollectionNarrative>();
    private Map<AgencyAndId, TripNarrative> _tripNarratives = new HashMap<AgencyAndId, TripNarrative>();
    private Map<AgencyAndId, List<StopTimeNarrative>> _stopTimeNarrativesByTripIdAndStopTimeSequence = new HashMap<AgencyAndId, List<StopTimeNarrative>>();
    private final Map<RoutePattern, List<StopTimeNarrative>> _patternToStopTimeNarratives = new HashMap<RoutePattern, List<StopTimeNarrative>>();
    private Map<AgencyAndId, ShapePoints> _shapePointsById = new HashMap<AgencyAndId, ShapePoints>();
    Map<AgencyAndId, ShapePoints> _dynamicShapesById = new HashMap<AgencyAndId, ShapePoints>();
    private Map<StopDirectionKey, RouteAndHeadsignNarrative> _patternCache = new HashMap<StopDirectionKey, RouteAndHeadsignNarrative>();
    private Map<AgencyAndId, List<AgencyAndId>> _staticRoutesByStopId = new HashMap<AgencyAndId, List<AgencyAndId>>();

    @Refreshable(dependsOn={"transitGraph"})
    public void reset() {
    }

    public void setNarrativeForAgency(String agencyId, AgencyNarrative narrative) {
        this._agencyNarratives.put(agencyId, narrative);
    }

    public void setNarrativeForStop(AgencyAndId stopId, StopNarrative narrative) {
        this._stopNarratives.put(stopId, narrative);
    }

    public void setNarrativeForRouteCollectionId(AgencyAndId id, RouteCollectionNarrative narrative) {
        this._routeCollectionNarratives.put(id, narrative);
    }

    public void setNarrativeForTripId(AgencyAndId tripId, TripNarrative narrative) {
        this._tripNarratives.put(tripId, narrative);
    }

    public void setNarrativeForStopTimeEntry(AgencyAndId tripId, int index, StopTimeNarrative narrative) {
        List<StopTimeNarrative> narratives = this._stopTimeNarrativesByTripIdAndStopTimeSequence.get(tripId);
        if (narratives == null) {
            narratives = new ArrayList<StopTimeNarrative>();
            this._stopTimeNarrativesByTripIdAndStopTimeSequence.put(tripId, narratives);
        }
        while (narratives.size() <= index) {
            narratives.add(null);
        }
        narratives.set(index, narrative);
    }

    public void setShapePointsForId(AgencyAndId shapeId, ShapePoints shapePoints) {
        this._shapePointsById.put(shapeId, shapePoints);
    }

    public AgencyNarrative getNarrativeForAgencyId(String agencyId) {
        return this._agencyNarratives.get(agencyId);
    }

    public RouteCollectionNarrative getNarrativeForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this._routeCollectionNarratives.get(routeCollectionId);
    }

    public StopNarrative getNarrativeForStopId(AgencyAndId stopId) {
        return this._stopNarratives.get(stopId);
    }

    public StopTimeNarrative getNarrativeForStopTimeEntry(StopTimeEntry entry) {
        StopTimeNarrative narrative = this.getNarrativeFromPattern(entry);
        if (narrative != null) {
            return narrative;
        }
        TripEntry trip = entry.getTrip();
        int index = entry.getSequence();
        List<StopTimeNarrative> narratives = this._stopTimeNarrativesByTripIdAndStopTimeSequence.get(trip.getId());
        if (narratives == null) {
            return null;
        }
        return narratives.get(index);
    }

    private StopTimeNarrative getNarrativeFromPattern(StopTimeEntry entry) {
        String directionId;
        AgencyAndId stopId = entry.getStop().getId();
        StopDirectionKey sd = new StopDirectionKey(stopId, directionId = entry.getTrip().getDirectionId());
        RouteAndHeadsignNarrative rd = this._patternCache.get(sd);
        if (rd == null) {
            return null;
        }
        StopTimeNarrative.Builder builder = new StopTimeNarrative.Builder();
        builder.setStopHeadsign(rd.getHeadsign());
        builder.setRouteShortName(rd.getRouteShortname());
        return builder.create();
    }

    public RouteCollectionNarrative getRouteCollectionNarrativeForId(AgencyAndId routeCollectionId) {
        return this._routeCollectionNarratives.get(routeCollectionId);
    }

    public TripNarrative getNarrativeForTripId(AgencyAndId tripId) {
        return this._tripNarratives.get(tripId);
    }

    public ShapePoints getShapePointsForId(AgencyAndId id) {
        if (this._shapePointsById.containsKey(id)) {
            return this._shapePointsById.get(id);
        }
        if (this._dynamicShapesById == null) {
            return null;
        }
        return this._dynamicShapesById.get(id);
    }

    public List<StopTimeNarrative> getStopTimeNarrativesForPattern(AgencyAndId routeId, String directionId, List<AgencyAndId> stopIds) {
        if (this._patternToStopTimeNarratives == null) {
            return null;
        }
        List<StopTimeNarrative> results = this._patternToStopTimeNarratives.get(new RoutePattern(routeId, directionId, stopIds));
        return results;
    }

    private List<StopTimeNarrative> find(List<AgencyAndId> stopIds, List<StopPattern> patterns) {
        for (StopPattern pattern : patterns) {
            if (pattern.stopIds == null) continue;
            if (CollectionUtils.isEqualCollection(pattern.stopIds, stopIds)) {
                return pattern.narratives;
            }
            int subListLocation = Collections.indexOfSubList(pattern.stopIds, stopIds);
            if (subListLocation <= -1) continue;
            return pattern.narratives;
        }
        return null;
    }

    public void setNarrativesForStops(AgencyAndId routeId, String directionId, List<AgencyAndId> stopIds, List<StopTimeNarrative> narratives) {
        if (stopIds.size() != narratives.size()) {
            throw new IllegalStateException("mismatch between pattern and narratives");
        }
        RoutePattern pattern = new RoutePattern(routeId, directionId, stopIds);
        if (!this._patternToStopTimeNarratives.containsKey(pattern)) {
            this._patternToStopTimeNarratives.put(pattern, narratives);
        }
    }

    public void addShapePoints(ShapePoints shapePoints) {
        this._dynamicShapesById.put(shapePoints.getShapeId(), shapePoints);
    }

    public void addStaticRoute(AgencyAndId stopId, List<AgencyAndId> staticRouteIds) {
        this._staticRoutesByStopId.put(stopId, staticRouteIds);
    }

    public List<AgencyAndId> getStaticRoutes(AgencyAndId stopId) {
        return this._staticRoutesByStopId.get(stopId);
    }

    public void addRouteAndHeadsign(StopDirectionKey stopDirectionKey, RouteAndHeadsignNarrative routeAndHeadsignNarrative) {
        this._patternCache.put(stopDirectionKey, routeAndHeadsignNarrative);
    }

    public int getPatternCount() {
        return this._patternCache.size();
    }

    public StopTimeNarrative getStopTimeNarrativeForPattern(AgencyAndId routeId, AgencyAndId stopId, String directionId) {
        StopDirectionKey key = new StopDirectionKey(stopId, directionId);
        RouteAndHeadsignNarrative routeAndHeadsignNarrative = this._patternCache.get(key);
        if (routeAndHeadsignNarrative == null) {
            for (StopDirectionKey stopDirectionKey : this._patternCache.keySet()) {
                if (!stopDirectionKey.getStopId().equals((Object)stopId)) continue;
                System.out.println("patternCache miss but stop/direction exists=" + stopDirectionKey.getStopId() + ", " + stopDirectionKey.getDirectionId());
            }
            return null;
        }
        StopTimeNarrative.Builder narrative = StopTimeNarrative.builder();
        narrative.setStopHeadsign(routeAndHeadsignNarrative.getHeadsign());
        narrative.setRouteShortName(routeAndHeadsignNarrative.getRouteShortname());
        return narrative.create();
    }

    public static class StopPattern
    implements Serializable {
        private List<AgencyAndId> stopIds;
        private List<StopTimeNarrative> narratives;

        public StopPattern(List<AgencyAndId> stopIds, List<StopTimeNarrative> narratives) {
            this.stopIds = stopIds;
            this.narratives = narratives;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof StopPattern)) {
                return false;
            }
            StopPattern sp = (StopPattern)obj;
            return sp.stopIds.equals(this.stopIds) && sp.narratives.equals(this.narratives);
        }

        public int hashCode() {
            return this.stopIds.hashCode() + this.narratives.hashCode();
        }
    }

    public static class RouteDirection
    implements Serializable {
        private AgencyAndId routeId;
        private String directionId;

        public RouteDirection(AgencyAndId routeId, String directionId) {
            if (routeId == null) {
                throw new NullPointerException("routeId cannot be null");
            }
            if (directionId == null) {
                directionId = "null";
            }
            this.routeId = routeId;
            this.directionId = directionId;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof RouteDirection)) {
                return false;
            }
            RouteDirection rd = (RouteDirection)obj;
            return rd.routeId.equals((Object)this.routeId) && rd.directionId.equals(this.directionId);
        }

        public int hashCode() {
            return this.routeId.hashCode() + this.directionId.hashCode();
        }

        public String toString() {
            return "{" + this.routeId + ":" + this.directionId + ")";
        }
    }

    public static class RoutePattern
    implements Serializable {
        private AgencyAndId routeId;
        private String directionId;
        private List<AgencyAndId> stopIds;

        public RoutePattern(AgencyAndId routeId, String direction, List<AgencyAndId> stopIds) {
            if (routeId == null) {
                throw new NullPointerException("routeId cannot be null");
            }
            if (direction == null) {
                direction = "null";
            }
            if (stopIds == null) {
                throw new NullPointerException("stopIds cannot be null, but can be empty");
            }
            this.routeId = routeId;
            this.directionId = direction;
            this.stopIds = stopIds;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof RoutePattern)) {
                return false;
            }
            RoutePattern rd = (RoutePattern)obj;
            return rd.routeId.equals((Object)this.routeId) && rd.directionId.equals(this.directionId) && CollectionUtils.isEqualCollection(rd.stopIds, this.stopIds);
        }

        public int hashCode() {
            return this.routeId.hashCode() + this.directionId.hashCode() + this.stopIds.hashCode();
        }
    }
}

