/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehicleType;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocationService;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElement;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElements;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractBlockLocationServiceImpl {
    private static Logger _log = LoggerFactory.getLogger(AbstractBlockLocationServiceImpl.class);
    private boolean _locationInterpolation = false;
    protected boolean _sampleScheduleDeviationHistory = false;
    protected ScheduledBlockLocationService _scheduledBlockLocationService;
    @Deprecated
    private boolean _distanceAlongBlockLocationInterpolation = false;

    @Autowired
    public void setScheduledBlockLocationService(ScheduledBlockLocationService scheduleBlockLocationService) {
        this._scheduledBlockLocationService = scheduleBlockLocationService;
    }

    @ConfigurationParameter
    public void setLocationInterpolation(boolean locationInterpolation) {
        this._locationInterpolation = locationInterpolation;
    }

    @ConfigurationParameter
    public void setSampleScheduleDeviationHistory(Boolean sampleScheduleDeviationHistory) {
        this._sampleScheduleDeviationHistory = sampleScheduleDeviationHistory;
    }

    @Deprecated
    public void setDistanceAlongBlockLocationInterpolation(boolean distanceAlongBlockLocationInterpolation) {
        this._distanceAlongBlockLocationInterpolation = distanceAlongBlockLocationInterpolation;
    }

    protected BlockLocation getBlockLocation(BlockInstance blockInstance, VehicleLocationCacheElements cacheElements, ScheduledBlockLocation scheduledLocation, long targetTime) {
        BlockLocation location = new BlockLocation();
        location.setTime(targetTime);
        location.setBlockInstance(blockInstance);
        VehicleLocationCacheElement cacheElement = null;
        boolean isCancelled = false;
        if (cacheElements != null) {
            cacheElement = cacheElements.getElementForTimestamp(targetTime);
        }
        if (cacheElement != null) {
            VehicleLocationRecord record = cacheElement.getRecord();
            if (scheduledLocation == null) {
                scheduledLocation = this.getScheduledBlockLocationForVehicleLocationCacheRecord(blockInstance, cacheElement, targetTime);
            }
            if (scheduledLocation != null) {
                location.setEffectiveScheduleTime(scheduledLocation.getScheduledTime());
                location.setDistanceAlongBlock(scheduledLocation.getDistanceAlongBlock());
            }
            location.setBlockStartTime(record.getBlockStartTime());
            location.setPredicted(true);
            location.setLastUpdateTime(record.getTimeOfRecord());
            location.setLastLocationUpdateTime(record.getTimeOfLocationUpdate());
            location.setScheduleDeviation(record.getScheduleDeviation());
            location.setScheduleDeviations(cacheElement.getScheduleDeviations());
            location.setVehicleFeatures(record.getVehicleFeatures());
            if (record.isCurrentLocationSet()) {
                CoordinatePoint p = new CoordinatePoint(record.getCurrentLocationLat(), record.getCurrentLocationLon());
                location.setLastKnownLocation(p);
            }
            location.setLastKnownOrientation(record.getCurrentOrientation());
            location.setPhase(record.getPhase());
            if ("CANCELED".equals(record.getStatus())) {
                isCancelled = true;
                _log.debug("vehicle " + record.getVehicleId() + " is cancelled");
            }
            location.setStatus(record.getStatus());
            location.setVehicleId(record.getVehicleId());
            List timepointPredictions = record.getTimepointPredictions();
            if (timepointPredictions != null && !timepointPredictions.isEmpty()) {
                TreeMap<Integer, Double> scheduleDeviations = new TreeMap<Integer, Double>();
                BlockConfigurationEntry blockConfig = blockInstance.getBlock();
                int tprIndexCounter = 0;
                for (TimepointPredictionRecord tpr : timepointPredictions) {
                    AgencyAndId stopId = tpr.getTimepointId();
                    long predictedTime = tpr.getTimepointPredictedDepartureTime() != -1L ? tpr.getTimepointPredictedDepartureTime() : tpr.getTimepointPredictedArrivalTime();
                    if (stopId == null || predictedTime == 0L) continue;
                    for (BlockStopTimeEntry blockStopTime : blockConfig.getStopTimes()) {
                        StopTimeEntry stopTime = blockStopTime.getStopTime();
                        StopEntry stop = stopTime.getStop();
                        if (!stopId.equals((Object)stop.getId()) || !stopTime.getTrip().getId().equals((Object)tpr.getTripId()) || tpr.getStopSequence() != -1 && stopTime.getSequence() != tpr.getStopSequence() || tpr.getStopSequence() == -1 && this.isFirstOrLastStopInTrip(stopTime) && this.isLoopRoute(stopTime) && (this.isSinglePredictionForTrip(timepointPredictions, tpr, tprIndexCounter) || this.isLastPrediction(stopTime, timepointPredictions, tpr, tprIndexCounter) && this.isFirstStopInRoute(stopTime) || this.isFirstPrediction(stopTime, timepointPredictions, tpr, tprIndexCounter) && this.isLastStopInRoute(stopTime))) continue;
                        int index = stopTime.getArrivalTime();
                        int arrivalOrDepartureTime = tpr.getTimepointPredictedDepartureTime() != -1L ? stopTime.getDepartureTime() : stopTime.getArrivalTime();
                        int deviation = (int)((predictedTime - blockInstance.getServiceDate()) / 1000L - (long)arrivalOrDepartureTime);
                        scheduleDeviations.put(index, Double.valueOf(deviation));
                    }
                    ++tprIndexCounter;
                }
                location.setTimepointPredictions(timepointPredictions);
                double[] scheduleTimes = new double[scheduleDeviations.size()];
                double[] scheduleDeviationMus = new double[scheduleDeviations.size()];
                double[] scheduleDeviationSigmas = new double[scheduleDeviations.size()];
                int index = 0;
                for (Map.Entry entry : scheduleDeviations.entrySet()) {
                    scheduleTimes[index] = ((Integer)entry.getKey()).intValue();
                    scheduleDeviationMus[index] = (Double)entry.getValue();
                    ++index;
                }
                ScheduleDeviationSamples samples = new ScheduleDeviationSamples(scheduleTimes, scheduleDeviationMus, scheduleDeviationSigmas);
                location.setScheduleDeviations(samples);
            }
        } else if (scheduledLocation == null) {
            scheduledLocation = this.getScheduledBlockLocationForBlockInstance(blockInstance, targetTime);
        }
        if (scheduledLocation == null) {
            if (isCancelled) {
                return location;
            }
            return null;
        }
        if (scheduledLocation.getActiveTrip() != null && scheduledLocation.getActiveTrip().getTrip() != null && scheduledLocation.getActiveTrip().getTrip().getRoute() != null) {
            location.setVehicleType(EVehicleType.toEnum((int)scheduledLocation.getActiveTrip().getTrip().getRoute().getType()));
        }
        location.setInService(scheduledLocation.isInService());
        location.setActiveTrip(scheduledLocation.getActiveTrip());
        location.setLocation(scheduledLocation.getLocation());
        location.setOrientation(scheduledLocation.getOrientation());
        location.setScheduledDistanceAlongBlock(scheduledLocation.getDistanceAlongBlock());
        location.setClosestStop(scheduledLocation.getClosestStop());
        location.setClosestStopTimeOffset(scheduledLocation.getClosestStopTimeOffset());
        location.setNextStop(scheduledLocation.getNextStop());
        location.setNextStopTimeOffset(scheduledLocation.getNextStopTimeOffset());
        location.setPreviousStop(scheduledLocation.getPreviousStop());
        return location;
    }

    protected ScheduledBlockLocation getScheduledBlockLocationForVehicleLocationCacheRecord(BlockInstance blockInstance, VehicleLocationCacheElement cacheElement, long targetTime) {
        VehicleLocationRecord record = cacheElement.getRecord();
        ScheduledBlockLocation scheduledBlockLocation = cacheElement.getScheduledBlockLocation();
        BlockConfigurationEntry blockConfig = blockInstance.getBlock();
        long serviceDate = blockInstance.getServiceDate();
        int scheduledTime = (int)((targetTime - serviceDate) / 1000L);
        if (!this._locationInterpolation && scheduledBlockLocation != null) {
            return scheduledBlockLocation;
        }
        if (record.isScheduleDeviationSet()) {
            int effectiveScheduledTime = (int)((double)scheduledTime - record.getScheduleDeviation());
            if (scheduledBlockLocation != null && scheduledBlockLocation.getScheduledTime() <= effectiveScheduledTime) {
                return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(scheduledBlockLocation, effectiveScheduledTime);
            }
            return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, effectiveScheduledTime);
        }
        if (record.isDistanceAlongBlockSet()) {
            if ((this._locationInterpolation || this._distanceAlongBlockLocationInterpolation) && scheduledBlockLocation != null && scheduledBlockLocation.getDistanceAlongBlock() <= record.getDistanceAlongBlock()) {
                int ellapsedTime = (int)((targetTime - record.getTimeOfRecord()) / 1000L);
                if (ellapsedTime >= 0) {
                    int effectiveScheduledTime = scheduledBlockLocation.getScheduledTime() + ellapsedTime;
                    return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, effectiveScheduledTime);
                }
                return this._scheduledBlockLocationService.getScheduledBlockLocationFromDistanceAlongBlock(scheduledBlockLocation, record.getDistanceAlongBlock());
            }
            return this._scheduledBlockLocationService.getScheduledBlockLocationFromDistanceAlongBlock(blockConfig, record.getDistanceAlongBlock());
        }
        return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, scheduledTime);
    }

    protected ScheduledBlockLocation getScheduledBlockLocationForBlockInstance(BlockInstance blockInstance, long targetTime) {
        BlockConfigurationEntry blockConfig = blockInstance.getBlock();
        long serviceDate = blockInstance.getServiceDate();
        int scheduledTime = (int)((targetTime - serviceDate) / 1000L);
        return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, scheduledTime);
    }

    protected boolean isFirstOrLastStopInTrip(StopTimeEntry stopTime) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        AgencyAndId firstStopId = stopTimes.get(0).getStop().getId();
        AgencyAndId lastStopId = stopTimes.get(stopTimes.size() - 1).getStop().getId();
        AgencyAndId currentStopId = stopTime.getStop().getId();
        return firstStopId.equals((Object)currentStopId) || lastStopId.equals((Object)currentStopId);
    }

    protected boolean isLoopRoute(StopTimeEntry stopTime) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        AgencyAndId firstStopId = stopTimes.get(0).getStop().getId();
        AgencyAndId lastStopId = stopTimes.get(stopTimes.size() - 1).getStop().getId();
        return firstStopId.equals((Object)lastStopId);
    }

    protected boolean isFirstStopInRoute(StopTimeEntry stopTime) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        return stopTimes.get(0).getSequence() == stopTime.getSequence();
    }

    protected boolean isLastStopInRoute(StopTimeEntry stopTime) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        return stopTimes.get(stopTimes.size() - 1).getSequence() == stopTime.getSequence();
    }

    protected boolean isSinglePredictionForTrip(List<TimepointPredictionRecord> timepointPredictions, TimepointPredictionRecord tpr, int tprIndexCounter) {
        if (timepointPredictions.size() == 1) {
            return true;
        }
        boolean isNextPredictionHasSameTripId = true;
        if (tprIndexCounter + 1 < timepointPredictions.size() && (isNextPredictionHasSameTripId = timepointPredictions.get(tprIndexCounter + 1).getTripId().equals((Object)tpr.getTripId()))) {
            return false;
        }
        if (tprIndexCounter - 1 >= 0) {
            return !timepointPredictions.get(tprIndexCounter - 1).getTripId().equals((Object)tpr.getTripId());
        }
        return !isNextPredictionHasSameTripId;
    }

    private boolean isLastPrediction(StopTimeEntry stopTime, List<TimepointPredictionRecord> timepointPredictions, TimepointPredictionRecord timepointPredictionRecord, int index) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        AgencyAndId lastStopId = stopTimes.get(stopTimes.size() - 1).getStop().getId();
        if (lastStopId.equals((Object)timepointPredictionRecord.getTimepointId()) && stopTime.getTrip().getId().equals((Object)timepointPredictionRecord.getTripId())) {
            return index + 1 == timepointPredictions.size() || index < timepointPredictions.size() && !timepointPredictions.get(index + 1).getTripId().equals((Object)timepointPredictionRecord.getTripId());
        }
        return false;
    }

    protected boolean isFirstPrediction(StopTimeEntry stopTime, List<TimepointPredictionRecord> timepointPredictions, TimepointPredictionRecord timepointPredictionRecord, int index) {
        List<StopTimeEntry> stopTimes = stopTime.getTrip().getStopTimes();
        AgencyAndId firstStopId = stopTimes.get(0).getStop().getId();
        if (firstStopId.equals((Object)timepointPredictionRecord.getTimepointId()) && stopTime.getTrip().getId().equals((Object)timepointPredictionRecord.getTripId())) {
            return index == 0 || index > 0 && !timepointPredictions.get(index - 1).getTripId().equals((Object)timepointPredictionRecord.getTripId());
        }
        return false;
    }

    protected ScheduledBlockLocation getScheduledBlockLocationForVehicleLocationRecord(VehicleLocationRecord record, BlockInstance blockInstance) {
        BlockConfigurationEntry blockConfig = blockInstance.getBlock();
        long serviceDate = blockInstance.getServiceDate();
        long targetTime = record.getTimeOfRecord();
        int scheduledTime = (int)((targetTime - serviceDate) / 1000L);
        if (record.isScheduleDeviationSet()) {
            int effectiveScheduledTime = (int)((double)scheduledTime - record.getScheduleDeviation());
            return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, effectiveScheduledTime);
        }
        if (record.isDistanceAlongBlockSet()) {
            return this._scheduledBlockLocationService.getScheduledBlockLocationFromDistanceAlongBlock(blockConfig, record.getDistanceAlongBlock());
        }
        return this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, scheduledTime);
    }
}

