/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.EVehicleType;

@Entity
@Table(name="transit_data_block_location_records")
@org.hibernate.annotations.Table(appliesTo="transit_data_block_location_records", indexes={@Index(name="vehicle_and_time", columnNames={"vehicle_agencyId", "vehicle_id", "time"}), @Index(name="vehicle_and_serviceDate", columnNames={"vehicle_agencyId", "vehicle_id", "serviceDate"})})
@org.hibernate.annotations.Entity(mutable=false)
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class BlockLocationRecord {
    @Id
    @GeneratedValue
    private final int id = 0;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="block_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="block_id"))})
    private final AgencyAndId blockId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="trip_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="trip_id"))})
    private final AgencyAndId tripId;
    private final long serviceDate;
    private final long time;
    @Column(nullable=true)
    private final Double scheduleDeviation;
    @Column(nullable=true)
    private final Double distanceAlongBlock;
    @Column(nullable=true)
    private final Double distanceAlongTrip;
    @Column(nullable=true)
    private final Double locationLat;
    @Column(nullable=true)
    private final Double locationLon;
    @Column(nullable=true)
    private final Double orientation;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="timepoint_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="timepoint_id"))})
    private final AgencyAndId timepointId;
    private final long timepointScheduledTime;
    private final long timepointPredictedArrivalTime;
    private final long timepointPredictedDepartureTime;
    @Type(type="org.onebusaway.container.hibernate.EnumUserType", parameters={@Parameter(name="enumClassName", value="org.onebusaway.realtime.api.EVehiclePhase")})
    @Column(length=50)
    private final EVehiclePhase phase;
    @Type(type="org.onebusaway.container.hibernate.EnumUserType", parameters={@Parameter(name="enumClassName", value="org.onebusaway.realtime.api.EVehicleType")})
    @Column(length=10)
    private final EVehicleType vehicleType;
    private final String status;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="vehicle_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="vehicle_id"))})
    private final AgencyAndId vehicleId;

    public static Builder builder() {
        return new Builder();
    }

    public BlockLocationRecord() {
        this.blockId = null;
        this.tripId = null;
        this.serviceDate = 0L;
        this.time = 0L;
        this.scheduleDeviation = null;
        this.distanceAlongBlock = null;
        this.distanceAlongTrip = null;
        this.locationLat = null;
        this.locationLon = null;
        this.orientation = null;
        this.timepointId = null;
        this.timepointScheduledTime = 0L;
        this.timepointPredictedArrivalTime = -1L;
        this.timepointPredictedDepartureTime = -1L;
        this.phase = null;
        this.status = null;
        this.vehicleId = null;
        this.vehicleType = EVehicleType.BUS;
    }

    private BlockLocationRecord(Builder builder) {
        this.blockId = builder.blockId;
        this.tripId = builder.tripId;
        this.serviceDate = builder.serviceDate;
        this.time = builder.time;
        this.scheduleDeviation = builder.scheduleDeviation;
        this.distanceAlongBlock = builder.distanceAlongBlock;
        this.distanceAlongTrip = builder.distanceAlongTrip;
        this.locationLat = builder.locationLat;
        this.locationLon = builder.locationLon;
        this.orientation = builder.orientation;
        this.timepointId = builder.timepointId;
        this.timepointScheduledTime = builder.timepointScheduledTime;
        this.timepointPredictedArrivalTime = builder.timepointPredictedArrivalTime;
        this.timepointPredictedDepartureTime = builder.timepointPredictedDepartureTime;
        this.phase = builder.phase;
        this.status = builder.status;
        this.vehicleId = builder.vehicleId;
        this.vehicleType = builder.vehicleType;
    }

    public int getId() {
        return 0;
    }

    public AgencyAndId getBlockId() {
        return this.blockId;
    }

    public AgencyAndId getTripId() {
        return this.tripId;
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isScheduleDeviationSet() {
        return this.scheduleDeviation != null;
    }

    public Double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public boolean isDistanceAlongBlockSet() {
        return this.distanceAlongBlock != null;
    }

    public Double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    public Double getDistanceAlongTrip() {
        return this.distanceAlongTrip;
    }

    public boolean isLocationSet() {
        return this.locationLat != null && this.locationLon != null;
    }

    public Double getLocationLat() {
        return this.locationLat;
    }

    public Double getLocationLon() {
        return this.locationLon;
    }

    public CoordinatePoint getLocation() {
        if (!this.isLocationSet()) {
            return null;
        }
        return new CoordinatePoint(this.locationLat.doubleValue(), this.locationLon.doubleValue());
    }

    public boolean isOrientationSet() {
        return this.orientation != null;
    }

    public Double getOrientation() {
        return this.orientation;
    }

    public AgencyAndId getTimepointId() {
        return this.timepointId;
    }

    public long getTimepointScheduledTime() {
        return this.timepointScheduledTime;
    }

    public long getTimepointPredictedArrivalTime() {
        return this.timepointPredictedArrivalTime;
    }

    public long getTimepointPredictedDepartureTime() {
        return this.timepointPredictedDepartureTime;
    }

    public EVehiclePhase getPhase() {
        return this.phase;
    }

    public EVehicleType getVehicleType() {
        return this.vehicleType;
    }

    public String getStatus() {
        return this.status;
    }

    @Index(name="vehicleId")
    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public String toString() {
        return "BlockLocationRecord(id=0 blockId=" + this.blockId + " serviceDate=" + this.serviceDate + " time=" + this.time + " scheduleDeviation=" + this.scheduleDeviation + " vehicleId=" + this.vehicleId + ")";
    }

    public static class Builder {
        private AgencyAndId blockId;
        private AgencyAndId tripId;
        private long serviceDate;
        private long time;
        private Double scheduleDeviation = null;
        private Double distanceAlongBlock = null;
        private Double distanceAlongTrip = null;
        private Double locationLat = null;
        private Double locationLon = null;
        private Double orientation = null;
        private AgencyAndId timepointId;
        private long timepointScheduledTime;
        private long timepointPredictedArrivalTime;
        private long timepointPredictedDepartureTime;
        private EVehiclePhase phase;
        private EVehicleType vehicleType;
        private String status;
        private AgencyAndId vehicleId;

        public void setBlockId(AgencyAndId blockId) {
            this.blockId = blockId;
        }

        public void setTripId(AgencyAndId tripId) {
            this.tripId = tripId;
        }

        public void setServiceDate(long serviceDate) {
            this.serviceDate = serviceDate;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setScheduleDeviation(Double scheduleDeviation) {
            this.scheduleDeviation = scheduleDeviation;
        }

        public void setDistanceAlongBlock(Double distanceAlongBlock) {
            this.distanceAlongBlock = distanceAlongBlock;
        }

        public void setDistanceAlongTrip(Double distanceAlongTrip) {
            this.distanceAlongTrip = distanceAlongTrip;
        }

        public void setLocationLat(Double locationLat) {
            this.locationLat = locationLat;
        }

        public void setLocationLon(Double locationLon) {
            this.locationLon = locationLon;
        }

        public void setLocation(CoordinatePoint location) {
            if (location == null) {
                this.locationLat = null;
                this.locationLon = null;
            } else {
                this.locationLat = location.getLat();
                this.locationLon = location.getLon();
            }
        }

        public void setOrientation(Double orientation) {
            this.orientation = orientation;
        }

        public void setTimepointId(AgencyAndId timepointId) {
            this.timepointId = timepointId;
        }

        public void setTimepointScheduledTime(long timepointScheduledTime) {
            this.timepointScheduledTime = timepointScheduledTime;
        }

        public void setTimepointPredictedArrivalTime(long timepointPredictedArrivalTime) {
            this.timepointPredictedArrivalTime = timepointPredictedArrivalTime;
        }

        public void setTimepointPredictedDepartureTime(long timepointPredictedDepartureTime) {
            this.timepointPredictedDepartureTime = timepointPredictedDepartureTime;
        }

        public void setPhase(EVehiclePhase phase) {
            this.phase = phase;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public EVehicleType getVehicleType() {
            return this.vehicleType;
        }

        public void setVehicleType(EVehicleType vehicleType) {
            this.vehicleType = vehicleType;
        }

        public void setVehicleId(AgencyAndId vehicleId) {
            this.vehicleId = vehicleId;
        }

        public BlockLocationRecord create() {
            return new BlockLocationRecord(this);
        }
    }
}

