/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.io.Serializable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.onebusaway.collections.adapter.AdapterLibrary;
import org.onebusaway.collections.adapter.IAdapter;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.util.SystemTime;
import org.onebusaway.utility.EOutOfRangeStrategy;
import org.onebusaway.utility.InterpolationLibrary;

public final class BlockLocationRecordCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ScheduleDeviationAdapter _scheduleDeviationAdapter = new ScheduleDeviationAdapter();
    private static final DistanceAlongBlockAdapter _distanceAlongBlockAdapter = new DistanceAlongBlockAdapter();
    private BlockInstance blockInstance;
    private AgencyAndId vehicleId;
    private final long fromTime;
    private final long toTime;
    private final long measuredLastUpdateTime;
    private final SortedMap<Long, BlockLocationRecord> records;

    public BlockLocationRecordCollection(long fromTime, long toTime, SortedMap<Long, BlockLocationRecord> records) {
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.records = records;
        this.measuredLastUpdateTime = SystemTime.currentTimeMillis();
    }

    public BlockLocationRecordCollection(long fromTime, long toTime) {
        this(fromTime, toTime, new TreeMap<Long, BlockLocationRecord>());
    }

    public static BlockLocationRecordCollection createFromRecords(BlockInstance blockInstance, List<BlockLocationRecord> records) {
        if (records.isEmpty()) {
            return null;
        }
        long fromTime = Long.MAX_VALUE;
        long toTime = Long.MIN_VALUE;
        TreeMap<Long, BlockLocationRecord> map = new TreeMap<Long, BlockLocationRecord>();
        AgencyAndId vehicleId = null;
        for (BlockLocationRecord record : records) {
            fromTime = Math.min(fromTime, record.getTime());
            toTime = Math.max(toTime, record.getTime());
            map.put(record.getTime(), record);
            vehicleId = BlockLocationRecordCollection.checkVehicleId(vehicleId, record);
        }
        BlockLocationRecordCollection collection = new BlockLocationRecordCollection(fromTime, toTime, map);
        collection.blockInstance = blockInstance;
        collection.vehicleId = vehicleId;
        return collection;
    }

    public BlockInstance getBlockInstance() {
        return this.blockInstance;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public long getFromTime() {
        return this.fromTime;
    }

    public long getToTime() {
        return this.toTime;
    }

    public long getMeasuredLastUpdateTime() {
        return this.measuredLastUpdateTime;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public double getScheduleDeviationForTargetTime(long targetTime) {
        if (this.records.isEmpty()) {
            return Double.NaN;
        }
        SortedMap m = AdapterLibrary.adaptSortedMap(this.records, (IAdapter)_scheduleDeviationAdapter);
        return Math.round(InterpolationLibrary.interpolate((SortedMap)m, (Number)targetTime, (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE));
    }

    public double getDistanceAlongBlockForTargetTime(long targetTime) {
        if (this.records.isEmpty()) {
            return Double.NaN;
        }
        SortedMap m = AdapterLibrary.adaptSortedMap(this.records, (IAdapter)_distanceAlongBlockAdapter);
        return InterpolationLibrary.interpolate((SortedMap)m, (Number)targetTime, (EOutOfRangeStrategy)EOutOfRangeStrategy.INTERPOLATE);
    }

    public CoordinatePoint getLastLocationForTargetTime(long targetTime) {
        BlockLocationRecord record = this.previousRecord(targetTime);
        if (record == null) {
            return null;
        }
        return record.getLocation();
    }

    public double getLastOrientationForTargetTime(long targetTime) {
        BlockLocationRecord record = this.previousRecord(targetTime);
        if (record == null) {
            return Double.NaN;
        }
        return record.getOrientation();
    }

    public EVehiclePhase getPhaseForTargetTime(long targetTime) {
        BlockLocationRecord record = this.previousRecord(targetTime);
        if (record == null) {
            return null;
        }
        return record.getPhase();
    }

    public String getStatusForTargetTime(long targetTime) {
        BlockLocationRecord record = this.previousRecord(targetTime);
        if (record == null) {
            return null;
        }
        return record.getStatus();
    }

    public long getLastUpdateTime(long targetTime) {
        if (this.records.isEmpty()) {
            return 0L;
        }
        SortedMap<Long, BlockLocationRecord> headMap = this.records.headMap(targetTime + 1L);
        if (headMap.isEmpty()) {
            return this.records.firstKey();
        }
        return headMap.lastKey();
    }

    public BlockLocationRecordCollection addRecord(BlockInstance blockInstance, BlockLocationRecord record, long windowSize) {
        AgencyAndId vehicleId = BlockLocationRecordCollection.checkVehicleId(this.vehicleId, record);
        blockInstance = BlockLocationRecordCollection.checkBlockInstance(this.blockInstance, blockInstance);
        long time = record.getTime();
        long updatedFromTime = Math.min(this.fromTime, time);
        long updatedToTime = Math.max(this.toTime, time);
        long updatedWindowSize = updatedToTime - updatedFromTime;
        SortedMap<Long, BlockLocationRecord> updatedRecords = new TreeMap<Long, BlockLocationRecord>(this.records);
        updatedRecords.put(record.getTime(), record);
        if (updatedWindowSize > windowSize) {
            double ratio = (double)windowSize / (double)updatedWindowSize;
            updatedFromTime = (long)((double)time - (double)(time - updatedFromTime) * ratio);
            updatedToTime = (long)((double)time + (double)(updatedToTime - time) * ratio);
            updatedRecords = this.submap(updatedFromTime, updatedToTime, updatedRecords);
        }
        BlockLocationRecordCollection collection = new BlockLocationRecordCollection(updatedFromTime, updatedToTime, updatedRecords);
        collection.blockInstance = blockInstance;
        collection.vehicleId = vehicleId;
        return collection;
    }

    private <T> SortedMap<Long, T> submap(long updatedFromTime, long updatedToTime, SortedMap<Long, T> map) {
        map = map.subMap(updatedFromTime, updatedToTime + 1L);
        return new TreeMap<Long, T>(map);
    }

    private BlockLocationRecord previousRecord(long targetTime) {
        if (this.records.isEmpty()) {
            return null;
        }
        SortedMap<Long, BlockLocationRecord> headMap = this.records.headMap(targetTime + 1L);
        if (headMap.isEmpty()) {
            return null;
        }
        return (BlockLocationRecord)headMap.get(headMap.lastKey());
    }

    private static BlockInstance checkBlockInstance(BlockInstance existing, BlockInstance blockInstance) {
        if (existing == null) {
            return blockInstance;
        }
        if (!existing.equals(blockInstance)) {
            throw new IllegalArgumentException("blockInstance mismatch: expected=" + existing + " actual=" + blockInstance);
        }
        return blockInstance;
    }

    private static AgencyAndId checkVehicleId(AgencyAndId existing, BlockLocationRecord record) {
        if (existing == null) {
            return record.getVehicleId();
        }
        if (!existing.equals((Object)record.getVehicleId())) {
            throw new IllegalArgumentException("vehicleId mismatch: expected=" + existing + " actual=" + record.getVehicleId());
        }
        return existing;
    }

    private static class DistanceAlongBlockAdapter
    implements IAdapter<BlockLocationRecord, Double> {
        private DistanceAlongBlockAdapter() {
        }

        public Double adapt(BlockLocationRecord source) {
            return source.getDistanceAlongBlock();
        }
    }

    private static class ScheduleDeviationAdapter
    implements IAdapter<BlockLocationRecord, Double> {
        private ScheduleDeviationAdapter() {
        }

        public Double adapt(BlockLocationRecord source) {
            return source.getScheduleDeviation();
        }
    }
}

