/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.blocks.BlockIndexFactoryServiceImpl;
import org.onebusaway.transit_data_federation.impl.blocks.BlockStopTimeIndicesFactory;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicCache;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.DynamicBlockIndexService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicBlockIndexServiceImpl
extends DynamicCache
implements DynamicBlockIndexService {
    private static Logger _log = LoggerFactory.getLogger(DynamicBlockIndexServiceImpl.class);
    @Autowired
    private BlockIndexFactoryServiceImpl blockIndexFactoryService;
    private NarrativeService _narrativeService;
    private DynamicGraph _dynamicGraph;
    private Map<AgencyAndId, List<BlockTripIndex>> blockTripIndexByRouteCollectionId = new HashMap<AgencyAndId, List<BlockTripIndex>>();
    private BlockStopTimeIndicesFactory blockStopTimeIndicesFactory = new BlockStopTimeIndicesFactory();
    private Map<AgencyAndId, BlockInstance> cacheByBlockId = new HashMap<AgencyAndId, BlockInstance>();
    private Map<AgencyAndId, Set<BlockStopTimeIndex>> blockStopTimeIndicesByStopId = new HashMap<AgencyAndId, Set<BlockStopTimeIndex>>();
    private Map<AgencyAndId, List<BlockTripIndex>> blockTripByBlockId = new HashMap<AgencyAndId, List<BlockTripIndex>>();

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setDynamicGraph(DynamicGraph dynamicGraph) {
        this._dynamicGraph = dynamicGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlockStopTimeIndex> getStopTimeIndicesForStop(StopEntry stopEntry) {
        Map<AgencyAndId, Set<BlockStopTimeIndex>> map = this.blockStopTimeIndicesByStopId;
        synchronized (map) {
            if (!this.blockStopTimeIndicesByStopId.containsKey(stopEntry.getId())) {
                return null;
            }
            Set<BlockStopTimeIndex> set = this.blockStopTimeIndicesByStopId.get(stopEntry.getId());
            return new ArrayList<BlockStopTimeIndex>(set);
        }
    }

    @Override
    public void register(BlockInstance blockInstance, long currentTime) {
        AgencyAndId id;
        if (this.needsPrune(currentTime)) {
            this.prune(currentTime);
        }
        if (this.cacheByBlockId.containsKey(id = blockInstance.getBlock().getBlock().getId()) && this.isCached(id)) {
            this.merge(blockInstance, currentTime);
            return;
        }
        this.add(blockInstance, currentTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(long currentTime) {
        long start = System.currentTimeMillis();
        try {
            this.resetStats(currentTime);
            int effectiveTime = this.getEffectiveTime(currentTime);
            this.pruneBlockTripIndexByRouteCollectionId(currentTime, effectiveTime);
            this.pruneCacheByBlockId(currentTime, effectiveTime);
            this.pruneBlockStopTimeIndicesByStopId(currentTime, effectiveTime);
            this.prunceBlockTripByBlockId(currentTime, effectiveTime);
        }
        catch (Throwable t) {
            _log.error("pune exception {}", (Object)t, (Object)t);
        }
        finally {
            _log.info("cache prune complete in {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void prunceBlockTripByBlockId(long currentTime, int effectiveTime) {
        for (Map.Entry<AgencyAndId, List<BlockTripIndex>> next : this.blockTripByBlockId.entrySet()) {
            Iterator<BlockTripIndex> iteratorInner = next.getValue().iterator();
            while (iteratorInner.hasNext()) {
                BlockTripIndex blockTripIndex = iteratorInner.next();
                if (!this.isExpired(blockTripIndex, currentTime, effectiveTime)) continue;
                iteratorInner.remove();
            }
        }
    }

    private void pruneBlockStopTimeIndicesByStopId(long currentTime, int effectiveTime) {
        for (Map.Entry<AgencyAndId, Set<BlockStopTimeIndex>> next : this.blockStopTimeIndicesByStopId.entrySet()) {
            Iterator<BlockStopTimeIndex> iteratorInner = next.getValue().iterator();
            while (iteratorInner.hasNext()) {
                BlockStopTimeIndex stopTimeIndex = iteratorInner.next();
                if (!this.isExpired(stopTimeIndex, currentTime, effectiveTime)) continue;
                iteratorInner.remove();
            }
        }
    }

    private void pruneCacheByBlockId(long currentTime, int effectiveTime) {
        Iterator<Map.Entry<AgencyAndId, BlockInstance>> iteratorOuter = this.cacheByBlockId.entrySet().iterator();
        while (iteratorOuter.hasNext()) {
            Map.Entry<AgencyAndId, BlockInstance> next = iteratorOuter.next();
            if (!this.isExpired(next.getValue(), effectiveTime)) continue;
            iteratorOuter.remove();
        }
    }

    private void pruneBlockTripIndexByRouteCollectionId(long currentTime, int effectiveTime) {
        for (Map.Entry<AgencyAndId, List<BlockTripIndex>> next : this.blockTripIndexByRouteCollectionId.entrySet()) {
            Iterator<BlockTripIndex> iteratorInner = next.getValue().iterator();
            while (iteratorInner.hasNext()) {
                BlockTripIndex blockTripIndex = iteratorInner.next();
                if (!this.isExpired(blockTripIndex, currentTime, effectiveTime)) continue;
                iteratorInner.remove();
            }
        }
    }

    private void merge(BlockInstance blockInstance, long currentTime) {
        AgencyAndId id = blockInstance.getBlock().getBlock().getId();
        if (!blockInstance.equals(this.cacheByBlockId.get(id))) {
            _log.info("block {} changed!", (Object)blockInstance);
            this.mergeBlockInstance(blockInstance);
        }
        this.mergeBlockTripIndexList(blockInstance);
    }

    private void mergeBlockTripIndexList(BlockInstance blockInstance) {
        AgencyAndId id = blockInstance.getBlock().getBlock().getId();
        ArrayList<BlockEntry> blocks = new ArrayList<BlockEntry>();
        blocks.add(blockInstance.getBlock().getBlock());
        List<BlockTripIndex> blockTripIndexList = this.blockIndexFactoryService.createTripIndices(blocks);
        if (blockTripIndexList.size() > 1) {
            _log.error("unexpected blockTripList of size {} for {}", (Object)blockTripIndexList.size(), blockTripIndexList);
        }
        for (BlockTripIndex blockTripIndex : blockTripIndexList) {
            this.mergeBlockTripIndex(id, blockTripIndex);
        }
        this.mergeBlockStopTimes(blockInstance);
    }

    private void mergeBlockStopTimes(BlockInstance blockInstance) {
        ArrayList<BlockEntry> blocks = new ArrayList<BlockEntry>();
        blocks.add(blockInstance.getBlock().getBlock());
        List<BlockStopTimeIndex> indices = this.blockStopTimeIndicesFactory.createIndices(blocks);
        for (BlockStopTimeIndex sti : indices) {
            BlockStopTimeIndex oldTimeIndex;
            AgencyAndId stopId = sti.getStop().getId();
            if (!this.blockStopTimeIndicesByStopId.containsKey(stopId)) {
                this.blockStopTimeIndicesByStopId.put(stopId, new HashSet());
            }
            if (sti.equals(oldTimeIndex = this.getBlockStopTimeIndex(this.blockStopTimeIndicesByStopId.get(stopId), sti))) continue;
            _log.debug("time index {} changed!", (Object)oldTimeIndex);
            this.removeBlockStopTimeIndex(this.blockStopTimeIndicesByStopId.get(stopId), sti);
            this.blockStopTimeIndicesByStopId.get(stopId).add(sti);
        }
    }

    private BlockStopTimeIndex getBlockStopTimeIndex(Set<BlockStopTimeIndex> blockStopTimeIndices, BlockStopTimeIndex sti) {
        for (BlockStopTimeIndex next : blockStopTimeIndices) {
            if (!next.getTrips().get(0).getTrip().getId().equals((Object)sti.getTrips().get(0).getTrip().getId())) continue;
            return next;
        }
        return null;
    }

    private void removeBlockStopTimeIndex(Set<BlockStopTimeIndex> blockStopTimeIndices, BlockStopTimeIndex sti) {
        Iterator<BlockStopTimeIndex> iterator = blockStopTimeIndices.iterator();
        while (iterator.hasNext()) {
            BlockStopTimeIndex next = iterator.next();
            if (!next.getTrips().get(0).getTrip().getId().equals((Object)sti.getTrips().get(0).getTrip().getId())) continue;
            iterator.remove();
        }
    }

    private void mergeBlockTripIndex(AgencyAndId id, BlockTripIndex blockTripIndex) {
        List<BlockTripIndex> blockTripIndices;
        BlockTripIndex existingBlockTripIndex;
        if (!this.blockTripByBlockId.containsKey(id)) {
            this.blockTripByBlockId.put(id, new ArrayList());
        }
        if (!blockTripIndex.equals(existingBlockTripIndex = (blockTripIndices = this.blockTripByBlockId.get(id)).get(0))) {
            _log.debug("blockTripIndex changed {}, truncating!", (Object)blockTripIndex);
            blockTripIndices.clear();
            blockTripIndices.add(blockTripIndex);
            TripEntry trip = blockTripIndex.getTrips().get(0).getTrip();
            this._dynamicGraph.updateTrip(trip);
            RouteEntry route = trip.getRoute();
            if (!this.blockTripIndexByRouteCollectionId.containsKey(route.getId())) {
                this.blockTripIndexByRouteCollectionId.put(route.getId(), new ArrayList());
            }
            Iterator<BlockTripIndex> routeIterator = this.blockTripIndexByRouteCollectionId.get(route.getId()).iterator();
            while (routeIterator.hasNext()) {
                BlockTripIndex index = routeIterator.next();
                if (!index.getTrips().get(0).getTrip().getId().equals((Object)id)) continue;
                routeIterator.remove();
            }
            this.blockTripIndexByRouteCollectionId.get(route.getId()).add(blockTripIndex);
            this._narrativeService.updateDynamicTrip(blockTripIndex);
        }
    }

    private void mergeBlockInstance(BlockInstance blockInstance) {
        AgencyAndId id = blockInstance.getBlock().getBlock().getId();
        this.cacheByBlockId.put(id, blockInstance);
        this._dynamicGraph.updateBlock(blockInstance.getBlock().getBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(BlockInstance blockInstance, long currentTime) {
        AgencyAndId id = blockInstance.getBlock().getBlock().getId();
        this.cacheByBlockId.put(id, blockInstance);
        ArrayList<BlockEntry> blocks = new ArrayList<BlockEntry>();
        blocks.add(blockInstance.getBlock().getBlock());
        this._dynamicGraph.registerBlock(blockInstance.getBlock().getBlock());
        List<BlockTripIndex> blockTripIndexList = this.blockIndexFactoryService.createTripIndices(blocks);
        for (BlockTripIndex blockTripIndex : blockTripIndexList) {
            if (!this.blockTripByBlockId.containsKey(id)) {
                this.blockTripByBlockId.put(id, new ArrayList());
            }
            this.blockTripByBlockId.get(id).add(blockTripIndex);
            TripEntry trip = blockTripIndex.getTrips().get(0).getTrip();
            this._dynamicGraph.registerTrip(trip, currentTime);
            RouteEntry route = trip.getRoute();
            this._dynamicGraph.registerRoute(route);
            if (!this.blockTripIndexByRouteCollectionId.containsKey(route.getId())) {
                this.blockTripIndexByRouteCollectionId.put(route.getId(), new ArrayList());
            }
            this.blockTripIndexByRouteCollectionId.get(route.getId()).add(blockTripIndex);
            this._narrativeService.addDynamicTrip(blockTripIndex);
        }
        List<BlockStopTimeIndex> indices = this.blockStopTimeIndicesFactory.createIndices(blocks);
        Map<AgencyAndId, Set<BlockStopTimeIndex>> map = this.blockStopTimeIndicesByStopId;
        synchronized (map) {
            for (BlockStopTimeIndex sti : indices) {
                AgencyAndId stopId = sti.getStop().getId();
                if (!this.blockStopTimeIndicesByStopId.containsKey(stopId)) {
                    this.blockStopTimeIndicesByStopId.put(stopId, new HashSet());
                }
                if (this.containsTrip(this.blockStopTimeIndicesByStopId.get(stopId), sti)) continue;
                this.blockStopTimeIndicesByStopId.get(stopId).add(sti);
            }
        }
    }

    private boolean isCached(AgencyAndId id) {
        BlockEntry testBlock = this._dynamicGraph.getBlockEntryForId(id);
        if (testBlock == null) {
            _log.debug("lost block {}", (Object)id);
            return false;
        }
        List<BlockTripIndex> blockTripIndices = this.blockTripByBlockId.get(id);
        if (blockTripIndices == null || blockTripIndices.isEmpty()) {
            _log.debug("lost blockTripIndices {}", (Object)id);
            return false;
        }
        TripEntry tripEntryForId = this._dynamicGraph.getTripEntryForId(id);
        if (tripEntryForId == null) {
            _log.debug("lost trip {}", (Object)id);
            return false;
        }
        RouteEntry routEntryForId = this._dynamicGraph.getRoutEntryForId(tripEntryForId.getRoute().getId());
        if (routEntryForId == null) {
            _log.debug("lost route {}", (Object)id);
            return false;
        }
        List<BlockTripIndex> list = this.blockTripIndexByRouteCollectionId.get(routEntryForId.getId());
        if (list == null || list.isEmpty()) {
            _log.debug("missing blockTripIndex {}", (Object)routEntryForId.getId());
            return false;
        }
        return true;
    }

    private boolean containsTrip(Set<BlockStopTimeIndex> blockStopTimeIndices, BlockStopTimeIndex sti) {
        for (BlockStopTimeIndex blockStopTimeIndex : blockStopTimeIndices) {
            if (!sti.getTrips().get(0).getTrip().getId().equals((Object)blockStopTimeIndex.getTrips().get(0).getTrip().getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockInstance getDynamicBlockInstance(AgencyAndId blockId) {
        return this.cacheByBlockId.get(blockId);
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this.blockTripIndexByRouteCollectionId.get(routeCollectionId);
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForBlock(AgencyAndId blockId) {
        return this.blockTripByBlockId.get(blockId);
    }
}

