/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class DynamicCache {
    private long lastPruneTime = 0L;
    private long pruneIntervalMillis = 3600000L;
    private long windowInMillis = 5400000L;

    public void setPruneIntervalMillis(long millis) {
        this.pruneIntervalMillis = millis;
    }

    public void setWindowInMillis(long millis) {
        this.windowInMillis = millis;
    }

    protected boolean needsPrune(long currentTime) {
        return currentTime > this.lastPruneTime + this.pruneIntervalMillis;
    }

    protected void resetStats(long currentTime) {
        this.lastPruneTime = currentTime;
    }

    public int getEffectiveTime(long currentTime) {
        return Math.toIntExact((currentTime - new ServiceDate(new Date(currentTime)).getAsDate().getTime()) / 1000L);
    }

    protected boolean isExpired(ServiceInterval range, int effectiveTime) {
        int minBounds = Math.toIntExact((long)range.getMinArrival() - this.windowInMillis / 1000L);
        int maxBounds = Math.toIntExact((long)range.getMaxDeparture() + this.windowInMillis / 1000L);
        return minBounds >= effectiveTime || maxBounds <= effectiveTime;
    }

    protected boolean isExpired(BlockTripIndex blockTripIndex, long currentTime, int effectiveTime) {
        return this.isExpired(blockTripIndex.getServiceIntervalBlock().getRange(), effectiveTime);
    }

    protected boolean isExpired(BlockInstance blockInstance, int effectiveTime) {
        return this.isExpired(blockInstance.getBlock(), effectiveTime);
    }

    protected boolean isExpired(BlockStopTimeIndex stopTimeIndex, long currentTime, int effectiveTime) {
        return this.isExpired(stopTimeIndex.getServiceInterval(), effectiveTime);
    }

    protected boolean isExpired(BlockEntry blockEntry, int effectiveTime) {
        return this.isExpired(blockEntry.getConfigurations().get(0), effectiveTime);
    }

    protected boolean isExpired(BlockConfigurationEntry entry, int effectiveTime) {
        List<BlockStopTimeEntry> stopTimes = entry.getBlock().getConfigurations().get(0).getStopTimes();
        int size = stopTimes.size();
        ServiceInterval serviceInterval = new ServiceInterval(this.getArrivalOrDeparture(stopTimes.get(0).getStopTime()), this.getDepartureOrArrival(stopTimes.get(size - 1).getStopTime()));
        return this.isExpired(serviceInterval, effectiveTime);
    }

    private int getDepartureOrArrival(StopTimeEntry stopTime) {
        if (stopTime.getDepartureTime() > 0) {
            return stopTime.getDepartureTime();
        }
        return stopTime.getArrivalTime();
    }

    private int getArrivalOrDeparture(StopTimeEntry stopTime) {
        if (stopTime.getArrivalTime() > 0) {
            return stopTime.getArrivalTime();
        }
        return stopTime.getDepartureTime();
    }

    protected boolean isExpired(TripEntry trip, int effectiveTime) {
        List<StopTimeEntry> stopTimes = trip.getStopTimes();
        int size = stopTimes.size();
        ServiceInterval serviceInterval = new ServiceInterval(this.getArrivalOrDeparture(stopTimes.get(0)), this.getDepartureOrArrival(stopTimes.get(size - 1)));
        return this.isExpired(serviceInterval, effectiveTime);
    }
}

