/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.collections.ConcurrentCollectionsLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElements;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheEntry;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationRecordCache;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VehicleLocationRecordCacheImpl
implements VehicleLocationRecordCache {
    private static Logger _log = LoggerFactory.getLogger(VehicleLocationRecordCacheImpl.class);
    private ConcurrentMap<AgencyAndId, VehicleLocationCacheEntry> _entriesByVehicleId = new ConcurrentHashMap<AgencyAndId, VehicleLocationCacheEntry>();
    private ConcurrentMap<BlockInstance, Set<AgencyAndId>> _vehicleIdsByBlockInstance = new ConcurrentHashMap<BlockInstance, Set<AgencyAndId>>();
    private Map<AgencyAndId, VehicleLocationRecord> rawPositionMap = new HashMap<AgencyAndId, VehicleLocationRecord>();
    private int _blockLocationRecordCacheWindowSize = 1200;
    private int _cacheEvictionFrequency = 1;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _evictionHandler;

    public void setBlockLocationRecordCacheWindowSize(int windowSize) {
        this._blockLocationRecordCacheWindowSize = windowSize;
    }

    public void setCacheEvictionFrequency(int cacheEvictionFrequency) {
        this._cacheEvictionFrequency = cacheEvictionFrequency;
    }

    @PostConstruct
    public void start() {
        this._executor = Executors.newScheduledThreadPool(1);
        this._evictionHandler = this._executor.scheduleAtFixedRate(new CacheEvictionHandler(), this._cacheEvictionFrequency, this._cacheEvictionFrequency, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void stop() {
        if (this._evictionHandler != null) {
            this._evictionHandler.cancel(true);
        }
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
    }

    @Override
    public void addRawPosition(AgencyAndId vehicleId, VehicleLocationRecord point) {
        this.rawPositionMap.put(vehicleId, point);
    }

    @Override
    public VehicleLocationRecord getRawPosition(AgencyAndId vehicleId) {
        return this.rawPositionMap.get(vehicleId);
    }

    @Override
    public VehicleLocationCacheElements getRecordForVehicleId(AgencyAndId vehicleId) {
        VehicleLocationCacheEntry entry = (VehicleLocationCacheEntry)this._entriesByVehicleId.get(vehicleId);
        if (entry == null) {
            return null;
        }
        return entry.getElements();
    }

    @Override
    public List<VehicleLocationCacheElements> getRecordsForBlockInstance(BlockInstance blockInstance) {
        Set vehicleIds = (Set)this._vehicleIdsByBlockInstance.get(blockInstance);
        ArrayList<VehicleLocationCacheElements> records = new ArrayList<VehicleLocationCacheElements>();
        if (vehicleIds != null) {
            for (AgencyAndId vehicleId : vehicleIds) {
                VehicleLocationCacheEntry record = (VehicleLocationCacheEntry)this._entriesByVehicleId.get(vehicleId);
                if (record == null || !record.getBlockInstance().equals(blockInstance)) continue;
                records.add(record.getElements());
            }
        }
        return records;
    }

    @Override
    public VehicleLocationCacheElements addRecord(BlockInstance blockInstance, VehicleLocationRecord record, ScheduledBlockLocation scheduledBlockLocation, ScheduleDeviationSamples samples) {
        VehicleLocationCacheEntry cacheEntry;
        AgencyAndId vehicleId = record.getVehicleId();
        if (vehicleId == null && "CANCELED".equals(record.getStatus())) {
            vehicleId = record.getTripId();
        }
        if (vehicleId == null) {
            return null;
        }
        while (true) {
            VehicleLocationCacheEntry newCacheEntry;
            if ((cacheEntry = this._entriesByVehicleId.putIfAbsent(vehicleId, newCacheEntry = new VehicleLocationCacheEntry(blockInstance))) == null) {
                cacheEntry = newCacheEntry;
                ConcurrentCollectionsLibrary.addToMapValueSet(this._vehicleIdsByBlockInstance, (Object)blockInstance, (Object)vehicleId);
            }
            if (cacheEntry.isClosedBecauseBlockInstanceChanged(blockInstance)) {
                this._entriesByVehicleId.remove(vehicleId);
                ConcurrentCollectionsLibrary.removeFromMapValueSet(this._vehicleIdsByBlockInstance, (Object)cacheEntry.getBlockInstance(), (Object)vehicleId);
                continue;
            }
            if (cacheEntry.addElement(record, scheduledBlockLocation, samples)) break;
        }
        BlockInstance existingBlockInstance = cacheEntry.getBlockInstance();
        if (!blockInstance.equals(existingBlockInstance)) {
            ConcurrentCollectionsLibrary.removeFromMapValueSet(this._vehicleIdsByBlockInstance, (Object)existingBlockInstance, (Object)vehicleId);
        }
        return cacheEntry.getElements();
    }

    @Override
    public void clearRecordsForVehicleId(AgencyAndId vehicleId) {
        VehicleLocationCacheEntry record = (VehicleLocationCacheEntry)this._entriesByVehicleId.remove(vehicleId);
        if (record != null) {
            ConcurrentCollectionsLibrary.removeFromMapValueSet(this._vehicleIdsByBlockInstance, (Object)record.getBlockInstance(), (Object)vehicleId);
        }
    }

    public void clearStaleRecords(long time) {
        Iterator it = this._entriesByVehicleId.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            AgencyAndId vehicleId = (AgencyAndId)entry.getKey();
            VehicleLocationCacheEntry cacheEntry = (VehicleLocationCacheEntry)entry.getValue();
            if (!cacheEntry.closeIfStale(time)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("pruning block location record cache for vehicle=" + vehicleId + " block=" + cacheEntry.getBlockInstance());
            }
            it.remove();
            ConcurrentCollectionsLibrary.removeFromMapValueSet(this._vehicleIdsByBlockInstance, (Object)cacheEntry.getBlockInstance(), (Object)vehicleId);
        }
    }

    private class CacheEvictionHandler
    implements Runnable {
        private CacheEvictionHandler() {
        }

        @Override
        public void run() {
            int preSize = VehicleLocationRecordCacheImpl.this._entriesByVehicleId.size();
            int vehiclePreSize = VehicleLocationRecordCacheImpl.this._vehicleIdsByBlockInstance.size();
            VehicleLocationRecordCacheImpl.this.clearStaleRecords(SystemTime.currentTimeMillis() - (long)(VehicleLocationRecordCacheImpl.this._blockLocationRecordCacheWindowSize * 1000));
            int postSize = VehicleLocationRecordCacheImpl.this._entriesByVehicleId.size();
            int vehiclePostSize = VehicleLocationRecordCacheImpl.this._vehicleIdsByBlockInstance.size();
            _log.debug("cleared {} entries and {} vehicles, now {} entries and {} vehicles", new Object[]{preSize - postSize, vehiclePreSize - vehiclePostSize, postSize, vehiclePostSize});
        }
    }
}

