/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.realtime.api.VehicleOccupancyListener;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data_federation.impl.realtime.apc.VehicleOccupancyRecordCache;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.blocks.BlockVehicleLocationListener;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElement;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElements;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationRecordCache;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatus;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatusService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VehicleStatusServiceImpl
implements VehicleLocationListener,
VehicleOccupancyListener,
VehicleStatusService {
    private ConcurrentHashMap<AgencyAndId, VehicleLocationRecord> _vehicleRecordsById = new ConcurrentHashMap();
    private TransitGraphDao _transitGraphDao;
    private BlockVehicleLocationListener _blockVehicleLocationService;
    private VehicleLocationRecordCache _vehicleLocationRecordCache;
    private VehicleOccupancyRecordCache _vehicleOccupanycRecordCache;
    private AgencyService _agencyService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockVehicleLocationService(BlockVehicleLocationListener service) {
        this._blockVehicleLocationService = service;
    }

    @Autowired
    public void setVehicleLocationRecordCache(VehicleLocationRecordCache vehicleLocationRecordCache) {
        this._vehicleLocationRecordCache = vehicleLocationRecordCache;
    }

    @Autowired
    public void setVehicleOccupancyRecordCache(VehicleOccupancyRecordCache vehicleOccupancyRecordCache) {
        this._vehicleOccupanycRecordCache = vehicleOccupancyRecordCache;
    }

    @Autowired
    public void setAgencyService(AgencyService agencyService) {
        this._agencyService = agencyService;
    }

    public void handleVehicleLocationRecord(VehicleLocationRecord record) {
        AgencyAndId tripId;
        AgencyAndId blockId;
        if (record.getPhase() == null && !"CANCELED".equals(record.getStatus())) {
            record.setPhase(EVehiclePhase.IN_PROGRESS);
        }
        if (record.getTimeOfRecord() == 0L) {
            throw new IllegalArgumentException("you must specify a record time");
        }
        if (record.getVehicleId() != null) {
            this._vehicleRecordsById.put(record.getVehicleId(), record);
        }
        if ((blockId = record.getBlockId()) == null && (tripId = record.getTripId()) != null) {
            TripEntry tripEntry = this._transitGraphDao.getTripEntryForId(tripId);
            if (tripEntry == null) {
                throw new IllegalArgumentException("trip not found with id=" + tripId);
            }
            BlockEntry block = tripEntry.getBlock();
            blockId = block.getId();
        }
        if (blockId != null && record.getServiceDate() != 0L) {
            this._blockVehicleLocationService.handleVehicleLocationRecord(record);
        } else if (record.getVehicleId() != null) {
            this._blockVehicleLocationService.resetVehicleLocation(record.getVehicleId());
        }
    }

    public void handleVehicleOccupancyRecord(VehicleOccupancyRecord record) {
        this._vehicleOccupanycRecordCache.addRecord(record);
    }

    public void handleVehicleOccupancyRecords(List<VehicleOccupancyRecord> records) {
        if (records == null) {
            return;
        }
        for (VehicleOccupancyRecord vor : records) {
            this._vehicleOccupanycRecordCache.addRecord(vor);
        }
    }

    public void resetVehicleOccupancy(AgencyAndId vehicleId) {
        this._vehicleOccupanycRecordCache.clearRecordForVehicle(vehicleId);
    }

    public void handleVehicleLocationRecords(List<VehicleLocationRecord> records) {
        for (VehicleLocationRecord record : records) {
            this.handleVehicleLocationRecord(record);
        }
    }

    public void resetVehicleLocation(AgencyAndId vehicleId) {
        this._vehicleRecordsById.remove(vehicleId);
        this._blockVehicleLocationService.resetVehicleLocation(vehicleId);
    }

    public void handleRawPosition(AgencyAndId vehicle, double lat, double lon, long timestamp) {
        VehicleLocationRecord record = new VehicleLocationRecord();
        record.setVehicleId(vehicle);
        record.setCurrentLocationLat(lat);
        record.setCurrentLocationLon(lon);
        record.setTimeOfLocationUpdate(timestamp);
        record.setTimeOfRecord(timestamp);
        record.setScheduleDeviation(-999.0);
        record.setDistanceAlongBlock(-999.0);
        record.setCurrentOrientation(-999.0);
        this._vehicleLocationRecordCache.addRawPosition(vehicle, record);
    }

    @Override
    public VehicleLocationRecord getRawPosition(AgencyAndId vehicle) {
        return this._vehicleLocationRecordCache.getRawPosition(vehicle);
    }

    @Override
    public VehicleStatus getVehicleStatusForId(AgencyAndId vehicleId) {
        VehicleLocationRecord record = this._vehicleRecordsById.get(vehicleId);
        if (record == null) {
            return null;
        }
        ArrayList<VehicleLocationRecord> records = new ArrayList<VehicleLocationRecord>();
        VehicleLocationCacheElements elements = this._vehicleLocationRecordCache.getRecordForVehicleId(vehicleId);
        if (elements != null) {
            for (VehicleLocationCacheElement element : elements.getElements()) {
                records.add(element.getRecord());
            }
        }
        VehicleStatus status = new VehicleStatus();
        status.setRecord(record);
        status.setAllRecords(records);
        status.setOccupancyRecord(this._vehicleOccupanycRecordCache.getLastRecordForVehicleId(vehicleId));
        return status;
    }

    @Override
    public List<VehicleStatus> getAllVehicleStatuses() {
        ArrayList<VehicleStatus> statuses = new ArrayList<VehicleStatus>();
        for (VehicleLocationRecord record : this._vehicleRecordsById.values()) {
            VehicleStatus status = new VehicleStatus();
            status.setRecord(record);
            statuses.add(status);
            status.setOccupancyRecord(this._vehicleOccupanycRecordCache.getLastRecordForVehicleId(record.getVehicleId()));
        }
        return statuses;
    }
}

