/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.apc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data_federation.impl.realtime.apc.VehicleOccupancyRecordCache;
import org.springframework.stereotype.Component;

@Component
public class VehicleOccupancyRecordCacheImpl
implements VehicleOccupancyRecordCache {
    private static int DEFAULT_CACHE_TIMEOUT_SECONDS = 360;
    private int _cacheTimeoutSeconds = DEFAULT_CACHE_TIMEOUT_SECONDS;
    private Cache<String, VehicleOccupancyRecord> _routeCache;
    private Cache<AgencyAndId, VehicleOccupancyRecord> _vehicleCache;

    public void setCacheTimeoutSeconds(int timeoutInSeconds) {
        if (timeoutInSeconds <= 0) {
            throw new UnsupportedOperationException("Non-expiring cache not supported");
        }
        this._cacheTimeoutSeconds = timeoutInSeconds;
    }

    @Override
    public void addRecord(VehicleOccupancyRecord vehicleOccupancyRecord) {
        if (vehicleOccupancyRecord == null || vehicleOccupancyRecord.getVehicleId() == null) {
            return;
        }
        this.getVehicleCache().put((Object)vehicleOccupancyRecord.getVehicleId(), (Object)vehicleOccupancyRecord);
        if (StringUtils.isBlank((String)vehicleOccupancyRecord.getRouteId())) {
            return;
        }
        this.getRouteCache().put((Object)this.hash(vehicleOccupancyRecord), (Object)vehicleOccupancyRecord);
    }

    @Override
    public VehicleOccupancyRecord getLastRecordForVehicleId(AgencyAndId vehicleId) {
        return (VehicleOccupancyRecord)this.getVehicleCache().getIfPresent((Object)vehicleId);
    }

    @Override
    public VehicleOccupancyRecord getRecordForVehicleIdAndRoute(AgencyAndId vehicleId, String routeId, String directionId) {
        return (VehicleOccupancyRecord)this.getRouteCache().getIfPresent((Object)this.hash(vehicleId, routeId, directionId));
    }

    @Override
    public boolean clearRecordForVehicle(AgencyAndId vehicleId) {
        boolean found = this.getVehicleCache().getIfPresent((Object)vehicleId) != null;
        this.getVehicleCache().invalidate((Object)vehicleId);
        return found;
    }

    @Override
    public boolean clearRecord(VehicleOccupancyRecord vor) {
        String hash = this.hash(vor.getVehicleId(), vor.getRouteId(), vor.getDirectionId());
        boolean found = this.getRouteCache().getIfPresent((Object)hash) != null;
        this.getRouteCache().invalidate((Object)hash);
        return found;
    }

    private String hash(AgencyAndId vehicleId, String routeId, String directionId) {
        if (!routeId.contains("_")) {
            routeId = new AgencyAndId(vehicleId.getAgencyId(), routeId).toString();
        }
        return vehicleId.toString() + "." + routeId + "." + directionId;
    }

    private String hash(VehicleOccupancyRecord vor) {
        return this.hash(vor.getVehicleId(), vor.getRouteId(), vor.getDirectionId());
    }

    private Cache<String, VehicleOccupancyRecord> getRouteCache() {
        if (this._routeCache == null) {
            this._routeCache = CacheBuilder.newBuilder().expireAfterWrite((long)this._cacheTimeoutSeconds, TimeUnit.SECONDS).build();
        }
        return this._routeCache;
    }

    private Cache<AgencyAndId, VehicleOccupancyRecord> getVehicleCache() {
        if (this._vehicleCache == null) {
            this._vehicleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this._cacheTimeoutSeconds, TimeUnit.SECONDS).build();
        }
        return this._vehicleCache;
    }
}

