/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedStopInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DuplicatedTripServiceParser;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatedTripServiceParserImpl
implements DuplicatedTripServiceParser {
    private static final Logger _log = LoggerFactory.getLogger(DuplicatedTripServiceParserImpl.class);
    private GtfsRealtimeEntitySource _entitySource;

    @Override
    public void setGtfsRealtimeEntitySource(GtfsRealtimeEntitySource source) {
        this._entitySource = source;
    }

    @Override
    public AddedTripInfo parse(GtfsRealtime.TripUpdate tu) {
        AddedTripInfo duplicatedTrip = new AddedTripInfo();
        duplicatedTrip.setScheduleRelationshipValue("DUPLICATED");
        ArrayList<AddedStopInfo> stopInfos = new ArrayList<AddedStopInfo>();
        String tripId = tu.getTrip().getTripId();
        TripEntry tripEntry = this._entitySource.getTrip(tripId);
        if (tripEntry == null) {
            _log.error("duplicated trip presented an invalid trip id {}", (Object)tripId);
            return null;
        }
        duplicatedTrip.setAgencyId(tripEntry.getId().getAgencyId());
        if (!tu.getTrip().getStartTime().contains(":")) {
            ServiceDate serviceDate = new ServiceDate(new Date(this.parseDate(tu.getTrip().getStartTime())));
            duplicatedTrip.setTripStartTime(this.getTimeOfFirstStop(tu.getStopTimeUpdateList(), serviceDate));
            duplicatedTrip.setServiceDate(serviceDate.getAsDate().getTime());
        } else if (tu.getTrip().getStartTime().contains(":")) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                Date startDate = dateFormat.parse(tu.getTrip().getStartDate());
                SimpleDateFormat timeSdf = new SimpleDateFormat("HH:mm:ss");
                Calendar timeCalendar = Calendar.getInstance();
                timeCalendar.setTime(timeSdf.parse(tu.getTrip().getStartTime()));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startDate);
                calendar.set(11, timeCalendar.get(11));
                calendar.set(12, timeCalendar.get(12));
                calendar.set(13, timeCalendar.get(13));
                ServiceDate serviceDate = new ServiceDate(startDate);
                duplicatedTrip.setServiceDate(serviceDate.getAsDate().getTime());
                duplicatedTrip.setTripStartTime(Math.toIntExact((calendar.getTimeInMillis() - duplicatedTrip.getServiceDate()) / 1000L));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new UnsupportedOperationException("service date / trip start time format not supported");
        }
        int originalTripStartTime = this.getTripStartTime(tripEntry);
        int offset = duplicatedTrip.getTripStartTime() / 1000 - originalTripStartTime;
        duplicatedTrip.setTripId(tripId + "_Dup");
        duplicatedTrip.setRouteId(tripEntry.getRoute().getId().getId());
        duplicatedTrip.setDirectionId(tripEntry.getDirectionId());
        duplicatedTrip.setShapeId(tripEntry.getShapeId());
        for (StopTimeEntry stopTimeEntry : tripEntry.getStopTimes()) {
            AddedStopInfo stopInfo = new AddedStopInfo();
            stopInfo.setStopId(stopTimeEntry.getStop().getId().getId());
            stopInfo.setArrivalTime(stopTimeEntry.getArrivalTime() + offset);
            stopInfo.setDepartureTime(stopTimeEntry.getDepartureTime() + offset);
            stopInfos.add(stopInfo);
        }
        duplicatedTrip.setStops(stopInfos);
        return duplicatedTrip;
    }

    private int getTripStartTime(TripEntry tripEntry) {
        if (tripEntry == null || tripEntry.getStopTimes() == null || tripEntry.getStopTimes().isEmpty()) {
            return -1;
        }
        StopTimeEntry stopTimeEntry = tripEntry.getStopTimes().get(0);
        if (stopTimeEntry.getArrivalTime() > 0) {
            return stopTimeEntry.getArrivalTime();
        }
        return stopTimeEntry.getDepartureTime();
    }

    private int getTimeOfFirstStop(List<GtfsRealtime.TripUpdate.StopTimeUpdate> stopTimeUpdateList, ServiceDate serviceDate) {
        if (stopTimeUpdateList == null || stopTimeUpdateList.isEmpty()) {
            return -1;
        }
        GtfsRealtime.TripUpdate.StopTimeUpdate update = stopTimeUpdateList.get(0);
        if (update.hasArrival() && update.getArrival().hasTime()) {
            return Math.toIntExact(update.getArrival().getTime() * 1000L - serviceDate.getAsDate().getTime());
        }
        if (update.hasDeparture() && update.getDeparture().hasTime()) {
            return Math.toIntExact(update.getDeparture().getTime() * 1000L - serviceDate.getAsDate().getTime());
        }
        throw new UnsupportedOperationException("received an update in an unexpected format " + update);
    }

    private long parseDate(String startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = sdf.parse(startTime);
            return date.getTime();
        }
        catch (ParseException e) {
            _log.error("unexpected date format for start_time {}", (Object)startTime);
            return -1L;
        }
    }
}

