/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import com.google.transit.realtime.GtfsRealtimeServiceStatus;
import java.util.Map;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.service.ServiceAlerts;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GtfsRealtimeAlertLibrary {
    private static final Logger _log = LoggerFactory.getLogger(GtfsRealtimeAlertLibrary.class);
    private GtfsRealtimeEntitySource _entitySource;

    GtfsRealtimeAlertLibrary() {
    }

    public void setEntitySource(GtfsRealtimeEntitySource entitySource) {
        this._entitySource = entitySource;
    }

    public ServiceAlerts.ServiceAlert.Builder getAlertAsServiceAlert(AgencyAndId id, GtfsRealtime.Alert alert) {
        return this.getAlertAsServiceAlert(id, alert, null);
    }

    public ServiceAlerts.ServiceAlert.Builder getAlertAsServiceAlert(AgencyAndId id, GtfsRealtime.Alert alert, Map agencyIdMap) {
        return this.getAlertAsServiceAlert(id, alert, agencyIdMap, false);
    }

    public ServiceAlerts.ServiceAlert.Builder getAlertAsServiceAlert(AgencyAndId id, GtfsRealtime.Alert alert, Map agencyIdMap, boolean ignoreTripIds) {
        ServiceAlerts.ServiceAlert.Builder b = ServiceAlerts.ServiceAlert.newBuilder();
        b.setCreationTime(SystemTime.currentTimeMillis());
        b.setModifiedTime(SystemTime.currentTimeMillis());
        b.setId(ServiceAlertLibrary.id((AgencyAndId)id));
        for (GtfsRealtime.TimeRange range : alert.getActivePeriodList()) {
            ServiceAlerts.TimeRange.Builder rangeBuilder = ServiceAlerts.TimeRange.newBuilder();
            if (range.hasStart() && range.getStart() > 0L) {
                rangeBuilder.setStart(this.toMillis(range.getStart()));
            }
            if (range.hasEnd() && range.getEnd() > 0L) {
                rangeBuilder.setEnd(this.toMillis(range.getEnd()));
            }
            b.addActiveWindow(rangeBuilder);
        }
        if (alert.hasCause()) {
            b.setCause(this.convertCause(alert.getCause()));
        }
        if (alert.hasHeaderText()) {
            b.setSummary(this.convertTranslatedString(alert.getHeaderText()));
        }
        if (alert.hasDescriptionText()) {
            b.setDescription(this.convertTranslatedString(alert.getDescriptionText()));
        }
        if (alert.hasEffect()) {
            ServiceAlerts.Consequence.Builder consequence = ServiceAlerts.Consequence.newBuilder();
            consequence.setEffect(this.convertEffect(alert.getEffect()));
            b.addConsequence(consequence);
        }
        for (GtfsRealtime.EntitySelector selector : alert.getInformedEntityList()) {
            ServiceAlerts.Affects.Builder affects = this.getEntitySelectorAsAffects(selector, agencyIdMap, ignoreTripIds);
            b.addAffects(affects);
        }
        if (alert.hasUrl()) {
            b.setUrl(this.convertTranslatedString(alert.getUrl()));
        }
        GtfsRealtimeServiceStatus.MercuryAlert mercuryAlert = null;
        if (alert.hasExtension(GtfsRealtimeServiceStatus.mercuryAlert) && (mercuryAlert = (GtfsRealtimeServiceStatus.MercuryAlert)alert.getExtension(GtfsRealtimeServiceStatus.mercuryAlert)).hasAlertType()) {
            b.setConsequenceMessage(mercuryAlert.getAlertType());
        }
        return b;
    }

    private long toMillis(long secondsOrMillis) {
        if (secondsOrMillis < 1000000000000L) {
            return secondsOrMillis * 1000L;
        }
        return secondsOrMillis;
    }

    private ServiceAlerts.Affects.Builder getEntitySelectorAsAffects(GtfsRealtime.EntitySelector selector, Map agencyIdMap, boolean ignoreTripIds) {
        ServiceAlerts.Affects.Builder affects = ServiceAlerts.Affects.newBuilder();
        if (selector.hasAgencyId()) {
            String agencyId = selector.getAgencyId();
            if (agencyIdMap != null && agencyIdMap.get(agencyId) != null) {
                agencyId = (String)agencyIdMap.get(agencyId);
            }
            affects.setAgencyId(agencyId);
        }
        if (selector.hasRouteId()) {
            ServiceAlerts.Id routeId = this._entitySource.getRouteId(selector.getRouteId());
            affects.setRouteId(routeId);
        }
        if (selector.hasStopId()) {
            ServiceAlerts.Id stopId = this._entitySource.getStopId(selector.getStopId());
            affects.setStopId(stopId);
        }
        if (!ignoreTripIds && selector.hasTrip()) {
            GtfsRealtime.TripDescriptor trip = selector.getTrip();
            if (trip.hasTripId()) {
                affects.setTripId(this._entitySource.getTripId(trip.getTripId()));
            } else if (trip.hasRouteId()) {
                affects.setRouteId(this._entitySource.getRouteId(trip.getRouteId()));
            }
        }
        return affects;
    }

    private ServiceAlerts.ServiceAlert.Cause convertCause(GtfsRealtime.Alert.Cause cause) {
        switch (cause) {
            case ACCIDENT: {
                return ServiceAlerts.ServiceAlert.Cause.ACCIDENT;
            }
            case CONSTRUCTION: {
                return ServiceAlerts.ServiceAlert.Cause.CONSTRUCTION;
            }
            case DEMONSTRATION: {
                return ServiceAlerts.ServiceAlert.Cause.DEMONSTRATION;
            }
            case HOLIDAY: {
                return ServiceAlerts.ServiceAlert.Cause.HOLIDAY;
            }
            case MAINTENANCE: {
                return ServiceAlerts.ServiceAlert.Cause.MAINTENANCE;
            }
            case MEDICAL_EMERGENCY: {
                return ServiceAlerts.ServiceAlert.Cause.MEDICAL_EMERGENCY;
            }
            case OTHER_CAUSE: {
                return ServiceAlerts.ServiceAlert.Cause.OTHER_CAUSE;
            }
            case POLICE_ACTIVITY: {
                return ServiceAlerts.ServiceAlert.Cause.POLICE_ACTIVITY;
            }
            case STRIKE: {
                return ServiceAlerts.ServiceAlert.Cause.STRIKE;
            }
            case TECHNICAL_PROBLEM: {
                return ServiceAlerts.ServiceAlert.Cause.TECHNICAL_PROBLEM;
            }
            case UNKNOWN_CAUSE: {
                return ServiceAlerts.ServiceAlert.Cause.UNKNOWN_CAUSE;
            }
            case WEATHER: {
                return ServiceAlerts.ServiceAlert.Cause.WEATHER;
            }
        }
        _log.warn("unknown GtfsRealtime.Alert.Cause " + cause);
        return ServiceAlerts.ServiceAlert.Cause.UNKNOWN_CAUSE;
    }

    private ServiceAlerts.Consequence.Effect convertEffect(GtfsRealtime.Alert.Effect effect) {
        switch (effect) {
            case ADDITIONAL_SERVICE: {
                return ServiceAlerts.Consequence.Effect.ADDITIONAL_SERVICE;
            }
            case DETOUR: {
                return ServiceAlerts.Consequence.Effect.DETOUR;
            }
            case MODIFIED_SERVICE: {
                return ServiceAlerts.Consequence.Effect.MODIFIED_SERVICE;
            }
            case NO_SERVICE: {
                return ServiceAlerts.Consequence.Effect.NO_SERVICE;
            }
            case OTHER_EFFECT: {
                return ServiceAlerts.Consequence.Effect.OTHER_EFFECT;
            }
            case REDUCED_SERVICE: {
                return ServiceAlerts.Consequence.Effect.REDUCED_SERVICE;
            }
            case SIGNIFICANT_DELAYS: {
                return ServiceAlerts.Consequence.Effect.SIGNIFICANT_DELAYS;
            }
            case STOP_MOVED: {
                return ServiceAlerts.Consequence.Effect.STOP_MOVED;
            }
            case UNKNOWN_EFFECT: {
                return ServiceAlerts.Consequence.Effect.UNKNOWN_EFFECT;
            }
        }
        _log.warn("unknown GtfsRealtime.Alert.Effect " + effect);
        return ServiceAlerts.Consequence.Effect.UNKNOWN_EFFECT;
    }

    private ServiceAlerts.TranslatedString convertTranslatedString(GtfsRealtime.TranslatedString string) {
        ServiceAlerts.TranslatedString.Builder b = ServiceAlerts.TranslatedString.newBuilder();
        for (GtfsRealtime.TranslatedString.Translation translation : string.getTranslationList()) {
            ServiceAlerts.TranslatedString.Translation.Builder tb = ServiceAlerts.TranslatedString.Translation.newBuilder();
            if (translation.hasLanguage()) {
                tb.setLanguage(translation.getLanguage());
            }
            tb.setText(translation.getText());
            b.addTranslation(tb);
        }
        return b.build();
    }
}

