/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsInclusionBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicHelper;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeCancelService;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GtfsRealtimeCancelServiceImpl
implements GtfsRealtimeCancelService {
    private static Logger _log = LoggerFactory.getLogger(GtfsRealtimeCancelServiceImpl.class);
    private TransitGraphDao _transitGraphDao;
    private VehicleLocationListener _vehicleLocationListener;
    private TransitDataService _tds;
    private DynamicHelper helper = new DynamicHelper();
    private Map<List<AgencyAndId>, Set<RouteEntry>> _cache = new HashMap<List<AgencyAndId>, Set<RouteEntry>>();

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setVehicleLocationListener(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    @Autowired
    public void setTransitDataService(TransitDataService tds) {
        this._tds = tds;
    }

    @Override
    public Set<RouteEntry> findRoutesForIds(List<AgencyAndId> ids) {
        HashSet<RouteEntry> routeSet = new HashSet<RouteEntry>();
        List<RouteEntry> routes = this._transitGraphDao.getAllRoutes();
        if (routes == null) {
            return null;
        }
        for (RouteEntry routeEntry : routes) {
            if (routeSet == null) {
                routeSet = new HashSet();
            }
            for (AgencyAndId routeId : ids) {
                if (!routeId.equals((Object)routeEntry.getId())) continue;
                routeSet.add(routeEntry);
            }
        }
        return routeSet;
    }

    public List<TripDetailsBean> findActiveTripsForRoutes(Set<RouteEntry> routes, long timestamp) {
        ArrayList<TripDetailsBean> beans = new ArrayList<TripDetailsBean>();
        if (routes == null) {
            return beans;
        }
        for (RouteEntry route : routes) {
            beans.addAll(this.findActiveTripsForRoute(route, timestamp));
        }
        return beans;
    }

    @Override
    public List<TripDetailsBean> findActiveTripsForRoute(RouteEntry route, long timestamp) {
        ArrayList<TripDetailsBean> activeTrips = new ArrayList<TripDetailsBean>();
        TripsForRouteQueryBean query = new TripsForRouteQueryBean();
        query.setRouteId(AgencyAndId.convertToString((AgencyAndId)route.getId()));
        query.setMaxCount(5000);
        query.setTime(timestamp);
        TripDetailsInclusionBean inclusion = new TripDetailsInclusionBean(true, false, true);
        query.setInclusion(inclusion);
        ListBean tripsForRoute = this._tds.getTripsForRoute(query);
        if (tripsForRoute != null) {
            for (TripDetailsBean bean : tripsForRoute.getList()) {
                if (this.isDynamic(bean)) continue;
                activeTrips.add(bean);
            }
        }
        return activeTrips;
    }

    private boolean isDynamic(TripDetailsBean bean) {
        if (bean == null || bean.getTrip() == null || bean.getTrip().getServiceId() == null) {
            return false;
        }
        return this.helper.isServiceIdDynamic(bean.getTrip().getServiceId());
    }

    @Override
    public void cancel(List<TripDetailsBean> tripsToCancel) {
        for (TripDetailsBean trip : tripsToCancel) {
            VehicleLocationRecord record = this.createVehicleLocationRecord(trip);
            if (record == null) continue;
            this._vehicleLocationListener.handleVehicleLocationRecord(record);
        }
    }

    @Override
    public void cancelServiceForRoutes(List<AgencyAndId> routeIdsToCancel, long timestamp) {
        Set<RouteEntry> routeEntries = this._cache.get(routeIdsToCancel);
        if (routeEntries == null) {
            routeEntries = this.findRoutesForIds(routeIdsToCancel);
            if (routeEntries == null) {
                return;
            }
            this._cache.put(routeIdsToCancel, routeEntries);
        }
        this.cancel(this.findActiveTripsForRoutes(routeEntries, timestamp));
        _log.info("canceled service for {}", routeIdsToCancel);
    }

    private VehicleLocationRecord createVehicleLocationRecord(TripDetailsBean trip) {
        VehicleLocationRecord record = new VehicleLocationRecord();
        record.setTimeOfRecord(System.currentTimeMillis());
        if (trip == null || trip.getTrip() == null || trip.getTrip().getBlockId() == null) {
            return null;
        }
        record.setBlockId(AgencyAndId.convertFromString((String)trip.getTrip().getBlockId()));
        record.setStatus("CANCELED");
        record.setTripId(AgencyAndId.convertFromString((String)trip.getTripId()));
        record.setServiceDate(new ServiceDate().getAsDate().getTime());
        return record;
    }
}

