/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeFuzzyMatcher {
    private static final Logger _log = LoggerFactory.getLogger(RealtimeFuzzyMatcher.class);
    private static final int DEFAULT_REFRESH_INTERVAL = 60;
    private TransitGraphDao dao;
    private ExtendedCalendarService calendarService;
    private Map<AgencyAndId, TripEntry> _cache = new HashMap<AgencyAndId, TripEntry>();
    private Set<AgencyAndId> _nullCache = new HashSet<AgencyAndId>();
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private int _cacheResetFrequencyMinutes = 60;
    private List<String> _realtimeTripIdRegexs = new ArrayList<String>();
    private List<String> _scheduleTripIdRegexs = new ArrayList<String>();
    private Map<AgencyAndId, Set<TripEntry>> _baseTripsByAgencyId = new HashMap<AgencyAndId, Set<TripEntry>>();
    private Set<String> _agencies = new HashSet<String>();
    boolean isInitialized = false;
    boolean firstRun = true;

    public void setAgencies(Set<String> agencies) {
        this._agencies.addAll(agencies);
    }

    public void setRealtimeTripIdRegexes(List<String> tripIdRegexs) {
        this._realtimeTripIdRegexs.addAll(tripIdRegexs);
    }

    public void setScheduleTripIdRegexs(List<String> tripIdRegexs) {
        this._scheduleTripIdRegexs.addAll(tripIdRegexs);
    }

    public void setRefreshInterval(int refreshIntervalMinutes) {
        this._cacheResetFrequencyMinutes = refreshIntervalMinutes;
    }

    public RealtimeFuzzyMatcher(TransitGraphDao transitGraphDao, ExtendedCalendarService calendarService) {
        this.dao = transitGraphDao;
        this.calendarService = calendarService;
    }

    @PostConstruct
    public void start() {
        this._executor.scheduleAtFixedRate(new RefreshTask(), 0L, this._cacheResetFrequencyMinutes, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void stop() {
        if (this._executor != null) {
            this._executor.shutdown();
        }
    }

    public synchronized void reset() {
        this.isInitialized = false;
        long start = System.currentTimeMillis();
        this._cache.clear();
        this._baseTripsByAgencyId.clear();
        this._nullCache.clear();
        for (TripEntry trip : this.dao.getAllTrips()) {
            if (!this._agencies.contains(trip.getId().getAgencyId())) continue;
            String baseTripId = trip.getId().getId();
            for (String tripIdRegex : this._realtimeTripIdRegexs) {
                baseTripId = baseTripId.replaceAll(tripIdRegex, "");
            }
            AgencyAndId baseTripAndAgencyId = new AgencyAndId(trip.getId().getAgencyId(), baseTripId);
            if (!this._baseTripsByAgencyId.containsKey(baseTripAndAgencyId)) {
                this._baseTripsByAgencyId.put(baseTripAndAgencyId, new HashSet());
            }
            this._baseTripsByAgencyId.get(baseTripAndAgencyId).add(trip);
        }
        long end = System.currentTimeMillis();
        _log.info("index built/reset in " + (end - start) + " ms");
        this.isInitialized = true;
    }

    public synchronized TripEntry findTrip(AgencyAndId tripId, long currentTime) {
        TripEntry trip;
        if (this.firstRun) {
            this.start();
            this.firstRun = false;
        }
        if (!this.isInitialized) {
            return null;
        }
        if (this._cache.containsKey(tripId)) {
            return this._cache.get(tripId);
        }
        if (this._nullCache.contains(tripId)) {
            return null;
        }
        if (this._scheduleTripIdRegexs != null && this._scheduleTripIdRegexs.size() > 0) {
            String agencyId = tripId.getAgencyId();
            String alteredTripId = tripId.getId();
            for (String regex : this._scheduleTripIdRegexs) {
                alteredTripId = alteredTripId.replaceAll(regex, "");
                tripId = new AgencyAndId(agencyId, alteredTripId);
            }
        }
        if ((trip = this.getBestTrip(tripId, currentTime)) != null) {
            this.logResult(trip, tripId);
            this._cache.put(tripId, trip);
        } else {
            this._nullCache.add(tripId);
        }
        return trip;
    }

    private void logResult(TripEntry trip, AgencyAndId tripId) {
        Date currentServiceDay = new ServiceDate().getAsDate();
        Set<Date> datesForServiceIds = this.calendarService.getDatesForServiceIds(new ServiceIdActivation(trip.getServiceId()));
        if (!datesForServiceIds.contains(currentServiceDay)) {
            _log.error("trip {} matched to {} on serviceId {}/{}", new Object[]{tripId, trip.getId(), trip.getServiceId(), datesForServiceIds});
        }
    }

    private TripEntry getBestTrip(AgencyAndId tripId, long currentTime) {
        Set<Date> datesForServiceIds;
        List<TripEntry> possibleTrips = this.getPossibleTrips(tripId);
        if (possibleTrips.isEmpty()) {
            return null;
        }
        Date currentServiceDay = new ServiceDate(new Date(currentTime)).getAsDate();
        for (TripEntry possibleTrip : possibleTrips) {
            datesForServiceIds = this.calendarService.getDatesForServiceIds(new ServiceIdActivation(possibleTrip.getServiceId()));
            if (!datesForServiceIds.contains(currentServiceDay)) continue;
            return possibleTrip;
        }
        List<TripScore> scoredTrips = this.getScore(possibleTrips, currentTime);
        if (scoredTrips.isEmpty()) {
            return null;
        }
        Collections.sort(scoredTrips);
        TripEntry bestTrip = scoredTrips.get(0).getTrip();
        datesForServiceIds = this.calendarService.getDatesForServiceIds(new ServiceIdActivation(bestTrip.getServiceId()));
        _log.debug("didn't match current day, instead found {} for {}", datesForServiceIds, (Object)bestTrip.getId());
        return bestTrip;
    }

    private List<TripScore> getScore(List<TripEntry> possibleTrips, long currentTime) {
        ArrayList<TripScore> scores = new ArrayList<TripScore>();
        for (TripEntry trip : possibleTrips) {
            LocalizedServiceId serviceId = trip.getServiceId();
            Set<Date> datesForServiceIds = this.calendarService.getDatesForServiceIds(new ServiceIdActivation(serviceId));
            if (datesForServiceIds != null && !datesForServiceIds.isEmpty()) {
                double tripScore = this.score(datesForServiceIds, currentTime);
                scores.add(new TripScore(trip, tripScore));
                continue;
            }
            _log.debug("no dates for serviceId {}", (Object)serviceId);
        }
        return scores;
    }

    private double score(Set<Date> possibleDates, long currentTime) {
        double lowestScore = Double.MAX_VALUE;
        for (Date possibleDate : possibleDates) {
            double score = (double)((possibleDate.getTime() + 21600000L - currentTime) / 1000L) / 60.0;
            if (!(Math.abs(score) < lowestScore)) continue;
            lowestScore = score;
        }
        return lowestScore;
    }

    private List<TripEntry> getPossibleTrips(AgencyAndId tripId) {
        ArrayList<TripEntry> possibleTrips = new ArrayList<TripEntry>();
        if (this._baseTripsByAgencyId.containsKey(tripId)) {
            possibleTrips.addAll((Collection<TripEntry>)this._baseTripsByAgencyId.get(tripId));
        }
        return possibleTrips;
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                RealtimeFuzzyMatcher.this.reset();
            }
            catch (Throwable t) {
                _log.error("error refreshing trips", t);
            }
        }
    }

    private static class TripScore
    implements Comparable<TripScore> {
        private TripEntry trip;
        private double score;

        public TripScore(TripEntry trip, double score) {
            this.trip = trip;
            this.score = score;
        }

        public TripEntry getTrip() {
            return this.trip;
        }

        @Override
        public int compareTo(TripScore o) {
            return Double.compare(Math.abs(this.score), Math.abs(o.score));
        }
    }
}

