/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.history;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.onebusaway.csv_entities.schema.EnumFieldMappingFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFieldNameConvention;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.mappings.AgencyIdFieldMappingFactory;
import org.onebusaway.realtime.api.EVehiclePhase;

@Entity
@javax.persistence.Table(name="oba_block_location_records_historical")
@Table(appliesTo="oba_block_location_records_historical", indexes={@Index(name="oba_block_location_records_historical_trip", columnNames={"trip_agencyId", "trip_id"})})
@org.hibernate.annotations.Entity(mutable=false)
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
@CsvFields(filename="block_location_records.csv", fieldNameConvention=CsvFieldNameConvention.CAMEL_CASE)
public class BlockLocationArchiveRecord {
    @Id
    private String id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="block_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="block_id"))})
    @CsvField(name="block", mapping=AgencyIdFieldMappingFactory.class)
    private AgencyAndId blockId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="trip_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="trip_id"))})
    @CsvField(name="trip", optional=true, mapping=AgencyIdFieldMappingFactory.class)
    private AgencyAndId tripId;
    private long serviceDate;
    private long time;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double scheduleDeviation;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double distanceAlongBlock;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double distanceAlongTrip;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double locationLat;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double locationLon;
    @CsvField(optional=true)
    @Column(nullable=true)
    private Double orientation;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="timepoint_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="timepoint_id"))})
    @CsvField(name="timepoint", optional=true, mapping=AgencyIdFieldMappingFactory.class)
    private AgencyAndId timepointId;
    private long timepointScheduledTime;
    private long timepointPredictedTime;
    @Type(type="org.onebusaway.container.hibernate.EnumUserType", parameters={@Parameter(name="enumClassName", value="org.onebusaway.realtime.api.EVehiclePhase")})
    @Column(length=50)
    @CsvField(optional=true, mapping=EnumFieldMappingFactory.class)
    private EVehiclePhase phase;
    @CsvField(optional=true)
    private String status;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="vehicle_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="vehicle_id"))})
    @CsvField(name="vehicle", mapping=AgencyIdFieldMappingFactory.class)
    private AgencyAndId vehicleId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgencyAndId getBlockId() {
        return this.blockId;
    }

    public void setBlockId(AgencyAndId blockId) {
        this.blockId = blockId;
    }

    public AgencyAndId getTripId() {
        return this.tripId;
    }

    public void setTripId(AgencyAndId tripId) {
        this.tripId = tripId;
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long serviceDate) {
        this.serviceDate = serviceDate;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public void setScheduleDeviation(Double scheduleDeviation) {
        this.scheduleDeviation = scheduleDeviation;
    }

    public Double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    public void setDistanceAlongBlock(Double distanceAlongBlock) {
        this.distanceAlongBlock = distanceAlongBlock;
    }

    public Double getDistanceAlongTrip() {
        return this.distanceAlongTrip;
    }

    public void setDistanceAlongTrip(Double distanceAlongTrip) {
        this.distanceAlongTrip = distanceAlongTrip;
    }

    public Double getLocationLat() {
        return this.locationLat;
    }

    public void setLocationLat(Double locationLat) {
        this.locationLat = locationLat;
    }

    public Double getLocationLon() {
        return this.locationLon;
    }

    public void setLocationLon(Double locationLon) {
        this.locationLon = locationLon;
    }

    public Double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Double orientation) {
        this.orientation = orientation;
    }

    public AgencyAndId getTimepointId() {
        return this.timepointId;
    }

    public void setTimepointId(AgencyAndId timepointId) {
        this.timepointId = timepointId;
    }

    public long getTimepointScheduledTime() {
        return this.timepointScheduledTime;
    }

    public void setTimepointScheduledTime(long timepointScheduledTime) {
        this.timepointScheduledTime = timepointScheduledTime;
    }

    public long getTimepointPredictedTime() {
        return this.timepointPredictedTime;
    }

    public void setTimepointPredictedTime(long timepointPredictedTime) {
        this.timepointPredictedTime = timepointPredictedTime;
    }

    public EVehiclePhase getPhase() {
        return this.phase;
    }

    public void setPhase(EVehiclePhase phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(AgencyAndId vehicleId) {
        this.vehicleId = vehicleId;
    }
}

