/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CDFMap<T> {
    private double _cumulativeProb = 0.0;
    private double[] _cumulativeProbabilities = new double[2];
    private List<T> _entries = new ArrayList<T>();

    public void put(double prob, T object) {
        if (this._cumulativeProbabilities.length <= this._entries.size()) {
            int c = this._cumulativeProbabilities.length << 1;
            double[] cumulativeProbabilities = new double[c];
            System.arraycopy(this._cumulativeProbabilities, 0, cumulativeProbabilities, 0, this._cumulativeProbabilities.length);
            this._cumulativeProbabilities = cumulativeProbabilities;
        }
        this._cumulativeProb += prob;
        this._cumulativeProbabilities[this._entries.size()] = this._cumulativeProb;
        this._entries.add(object);
    }

    public T sample() {
        if (this._entries.isEmpty()) {
            throw new IllegalStateException("No entries in the CDF");
        }
        if (this._cumulativeProb == 0.0) {
            throw new IllegalStateException("No cumulative probability in CDF");
        }
        double probability = Math.random() * this._cumulativeProb;
        int index = Arrays.binarySearch(this._cumulativeProbabilities, 0, this._entries.size(), probability);
        if (index < 0) {
            index = -(index + 1);
        }
        return this._entries.get(index);
    }

    public List<T> sample(int samples) {
        if (this._entries.isEmpty()) {
            throw new IllegalStateException("No entries in the CDF map");
        }
        if (this._cumulativeProb == 0.0) {
            throw new IllegalStateException("No cumulative probability in CDF");
        }
        if (samples == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> sampled = new ArrayList<T>(samples);
        double step = this._cumulativeProb / (double)samples;
        int index = 0;
        for (double p = 0.0; p < this._cumulativeProb && sampled.size() < samples; p += step) {
            while (this._cumulativeProbabilities[index] <= p) {
                ++index;
            }
            sampled.add(this._entries.get(index));
        }
        return sampled;
    }

    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    public boolean hasProbability() {
        return this._cumulativeProb > 0.0;
    }

    public boolean canSample() {
        return !this._entries.isEmpty() && this._cumulativeProb > 0.0;
    }

    public int size() {
        return this._entries.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        for (int i = 0; i < this._entries.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this._cumulativeProbabilities[i]);
            b.append("=");
            b.append(this._entries.get(i));
        }
        b.append("}");
        return b.toString();
    }
}

