/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.history;

import cern.colt.list.DoubleArrayList;
import cern.jet.random.Normal;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Descriptive;
import java.util.Arrays;
import org.onebusaway.collections.Range;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.history.CDFMap;
import org.onebusaway.transit_data_federation.impl.realtime.history.ScheduleDeviationHistory;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureInstance;
import org.onebusaway.transit_data_federation.services.realtime.RealTimeHistoryService;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationHistogram;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationHistoryDao;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.InterpolationLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealTimeHistoryServiceImpl
implements RealTimeHistoryService {
    private ScheduleDeviationHistoryDao _scheduleDeviationHistoryDao;
    private int _predictionLookahead = 1200;
    private Normal _schedDevScaleParam = new Normal(0.0, 300.0, RandomEngine.makeDefault());

    @Autowired
    public void setScheduleDeviationHistoryDao(ScheduleDeviationHistoryDao scheduleDeviationHistoryDao) {
        this._scheduleDeviationHistoryDao = scheduleDeviationHistoryDao;
    }

    public void setPredictionLookahead(int predictionLookahead) {
        this._predictionLookahead = predictionLookahead;
    }

    @Override
    public ScheduleDeviationHistogram getScheduleDeviationHistogramForArrivalAndDepartureInstance(ArrivalAndDepartureInstance instance, int stepSizeInSeconds) {
        BlockTripEntry blockTrip = instance.getBlockTrip();
        TripEntry trip = blockTrip.getTrip();
        AgencyAndId tripId = trip.getId();
        ScheduleDeviationHistory history = this._scheduleDeviationHistoryDao.getScheduleDeviationHistoryForTripId(tripId);
        if (history == null) {
            return null;
        }
        BlockStopTimeEntry blockStopTime = instance.getBlockStopTime();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        double[] values = this.getScheduleDeviationsForScheduleTime(history, stopTime.getDepartureTime());
        return this.createHistogramFromValues(values, stepSizeInSeconds);
    }

    @Override
    public ScheduleDeviationSamples sampleScheduleDeviationsForVehicle(BlockInstance instance, VehicleLocationRecord record, ScheduledBlockLocation scheduledBlockLocation) {
        if (scheduledBlockLocation == null) {
            return null;
        }
        BlockTripEntry blockTrip = scheduledBlockLocation.getActiveTrip();
        TripEntry trip = blockTrip.getTrip();
        ScheduleDeviationHistory history = this._scheduleDeviationHistoryDao.getScheduleDeviationHistoryForTripId(trip.getId());
        if (history == null) {
            return null;
        }
        ScheduleDeviationHistory resampledHistory = this.resampleHistory(history, scheduledBlockLocation.getScheduledTime(), record.getScheduleDeviation());
        DoubleArrayList scheduleTimes = new DoubleArrayList();
        DoubleArrayList mus = new DoubleArrayList();
        DoubleArrayList sigmas = new DoubleArrayList();
        for (int t = 0; t <= this._predictionLookahead; t += 300) {
            int scheduleTime = scheduledBlockLocation.getScheduledTime() + t;
            double[] deviations = this.getScheduleDeviationsForScheduleTime(resampledHistory, scheduleTime);
            deviations = this.noNans(deviations);
            DoubleArrayList values = new DoubleArrayList(deviations);
            double mu = Descriptive.mean((DoubleArrayList)values);
            double var = Descriptive.sampleVariance((DoubleArrayList)values, (double)mu);
            double sigma = Descriptive.sampleStandardDeviation((int)values.size(), (double)var);
            scheduleTimes.add((double)scheduleTime);
            mus.add(mu);
            sigmas.add(sigma);
        }
        scheduleTimes.trimToSize();
        mus.trimToSize();
        sigmas.trimToSize();
        return new ScheduleDeviationSamples(scheduleTimes.elements(), mus.elements(), sigmas.elements());
    }

    private double[] getScheduleDeviationsForScheduleTime(ScheduleDeviationHistory history, int scheduleTime) {
        double[] scheduleTimes = history.getScheduleTimes();
        double[][] scheduleDeviations = history.getScheduleDeviations();
        int index = Arrays.binarySearch(scheduleTimes, (double)scheduleTime);
        if (index >= 0) {
            return this.getColumn(scheduleDeviations, index);
        }
        if ((index = -(index + 1)) == scheduleTimes.length) {
            return this.getColumn(scheduleDeviations, index - 1);
        }
        if (index == 0) {
            return this.getColumn(scheduleDeviations, 0);
        }
        int numSamples = history.getNumberOfSamples();
        double[] values = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            double fromKey = scheduleTimes[index - 1];
            double toKey = scheduleTimes[index];
            double fromValue = scheduleDeviations[i][index - 1];
            double toValue = scheduleDeviations[i][index];
            values[i] = InterpolationLibrary.interpolatePair((double)fromKey, (double)fromValue, (double)toKey, (double)toValue, (double)scheduleTime);
        }
        return values;
    }

    private double[] getColumn(double[][] values, int index) {
        double[] v = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = values[i][index];
        }
        return v;
    }

    private double[] noNans(double[] values) {
        DoubleArrayList vs = new DoubleArrayList();
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            vs.add(v);
        }
        vs.trimToSize();
        return vs.elements();
    }

    private ScheduleDeviationHistogram createHistogramFromValues(double[] values, int stepSizeInSeconds) {
        if ((values = this.noNans(values)).length == 0) {
            return new ScheduleDeviationHistogram(new int[0], new int[0]);
        }
        Range r = new Range();
        for (double v : values) {
            r.addValue(v);
        }
        if (r.getRange() == 0.0) {
            return new ScheduleDeviationHistogram(new int[]{(int)values[0]}, new int[]{values.length});
        }
        int halfStep = stepSizeInSeconds / 2;
        int from = (int)(Math.floor((r.getMin() - (double)halfStep) / (double)stepSizeInSeconds) * (double)stepSizeInSeconds) + halfStep;
        int to = (int)(Math.ceil((r.getMax() + (double)halfStep) / (double)stepSizeInSeconds) * (double)stepSizeInSeconds) - halfStep;
        int columns = (to - from) / stepSizeInSeconds;
        int[] scheduleDeviations = new int[columns];
        int[] counts = new int[columns];
        for (int i = 0; i < columns; ++i) {
            scheduleDeviations[i] = from + stepSizeInSeconds * i + halfStep;
        }
        for (double value : values) {
            int index;
            int n = index = (int)((value - (double)from) / (double)stepSizeInSeconds);
            counts[n] = counts[n] + 1;
        }
        return new ScheduleDeviationHistogram(scheduleDeviations, counts);
    }

    private ScheduleDeviationHistory resampleHistory(ScheduleDeviationHistory history, int scheduleTime, double activeDeviation) {
        double[] deviations = this.getScheduleDeviationsForScheduleTime(history, scheduleTime);
        CDFMap<Integer> cdf = new CDFMap<Integer>();
        for (int i = 0; i < deviations.length; ++i) {
            double deviation = deviations[i];
            if (Double.isNaN(deviation)) continue;
            double p = this._schedDevScaleParam.apply(activeDeviation - deviation);
            cdf.put(p, i);
        }
        int numSamples = deviations.length;
        double[] scheduleTimes = history.getScheduleTimes();
        double[][] scheduleDeviations = history.getScheduleDeviations();
        double[][] sampledScheduleDeviations = new double[numSamples][];
        for (int i = 0; i < numSamples; ++i) {
            int index = (Integer)cdf.sample();
            sampledScheduleDeviations[i] = scheduleDeviations[index];
        }
        return new ScheduleDeviationHistory(history.getTripId(), scheduleTimes, sampledScheduleDeviations);
    }
}

