/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.orbcad;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.onebusaway.csv_entities.CsvEntityReader;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.schema.AnnotationDrivenEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.AbstractOrbcadRecordSource;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.FtpDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.OrbcadRecord;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(value="org.onebusaway.transit_data_federation.impl.realtime.orbcad:name=OrbcadRecordFtpSource")
public class OrbcadRecordFtpSource
extends AbstractOrbcadRecordSource {
    private static final int TIMEOUT_IN_SECONDS = 10;
    private static Logger _log = LoggerFactory.getLogger(OrbcadRecordFtpSource.class);
    private Set<String> _paths = new HashSet<String>();
    private CsvEntityReader _reader;
    private FTPClient _ftpClient = null;
    private FtpDataSource _dataSource;
    private String _dataDirectory;
    private int _maxDownloadCount = 1;
    private transient int _totalFtpFiles = 0;
    private transient int _newFtpFiles = 0;

    public void setDataSource(FtpDataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setDataDirectory(String dataDirectory) {
        this._dataDirectory = dataDirectory;
    }

    @ManagedAttribute
    public int getTotalFtpFiles() {
        return this._totalFtpFiles;
    }

    @ManagedAttribute
    public int getNewFtpFiles() {
        return this._newFtpFiles;
    }

    @Override
    @PostConstruct
    public void start() throws SocketException, IOException {
        _log.info("starting orbcad ftp download client");
        super.start();
    }

    @Override
    @PreDestroy
    public void stop() throws IOException {
        _log.info("stopping orbcad ftp download client");
        super.stop();
        if (this._ftpClient != null) {
            this._ftpClient.disconnect();
        }
    }

    @Override
    protected void setup() {
        this._reader = new CsvEntityReader();
        AnnotationDrivenEntitySchemaFactory entitySchemaFactory = new AnnotationDrivenEntitySchemaFactory();
        entitySchemaFactory.addEntityClass(OrbcadRecord.class);
        this._reader.setEntitySchemaFactory((EntitySchemaFactory)entitySchemaFactory);
        this._reader.addEntityHandler((EntityHandler)new AbstractOrbcadRecordSource.RecordHandler());
    }

    @Override
    protected synchronized void handleRefresh() throws IOException {
        try {
            if (this._ftpClient == null) {
                this.reconnectFtp();
            }
            List<String> toDownload = this.getUpdatedFilesToDownload();
            this.downloadUpdatedFiles(toDownload);
        }
        catch (IOException ex) {
            _log.error("error refreshing avl files", (Throwable)ex);
            this.disconnectFtpClient();
        }
    }

    private void reconnectFtp() throws SocketException, IOException {
        _log.info("attempting to establish ftp connection");
        this.disconnectFtpClient();
        this._ftpClient = new FTPClient();
        this._ftpClient.setConnectTimeout(10000);
        this._ftpClient.setDataTimeout(10000);
        this._ftpClient.setDefaultTimeout(10000);
        this._ftpClient.connect(this._dataSource.getServername(), this._dataSource.getPort());
        this._ftpClient.login(this._dataSource.getUsername(), this._dataSource.getPassword());
        this._ftpClient.enterLocalPassiveMode();
        _log.info("ftp connection established");
    }

    private List<String> getUpdatedFilesToDownload() throws IOException {
        long t1 = SystemTime.currentTimeMillis();
        FTPListParseEngine engine = this._ftpClient.initiateListParsing(this._dataDirectory);
        HashSet<String> paths = new HashSet<String>();
        ArrayList<String> toDownload = new ArrayList<String>();
        while (engine.hasNext()) {
            FTPFile[] files;
            for (FTPFile file : files = engine.getNext(25)) {
                String path = this._dataDirectory + "/" + file.getName();
                paths.add(path);
                if (this._paths.contains(path)) continue;
                toDownload.add(path);
            }
        }
        this._totalFtpFiles = paths.size();
        this._newFtpFiles = toDownload.size();
        long t2 = SystemTime.currentTimeMillis();
        if (_log.isDebugEnabled()) {
            _log.debug("file listing time: " + (t2 - t1) + " totalFiles: " + paths.size() + " newFiles: " + toDownload.size());
        }
        this._paths = paths;
        if (this._maxDownloadCount > 0 && toDownload.size() > this._maxDownloadCount) {
            ArrayList<String> reduced = new ArrayList<String>(this._maxDownloadCount);
            for (int i = 0; i < this._maxDownloadCount; ++i) {
                reduced.add((String)toDownload.get(toDownload.size() - this._maxDownloadCount + i));
            }
            toDownload = reduced;
        }
        return toDownload;
    }

    private void downloadUpdatedFiles(List<String> toDownload) throws IOException {
        for (String path : toDownload) {
            _log.debug("downloading path: {}", (Object)path);
            long t3 = SystemTime.currentTimeMillis();
            InputStream in = this._ftpClient.retrieveFileStream(path);
            if (!FTPReply.isPositivePreliminary((int)this._ftpClient.getReplyCode())) {
                _log.warn("error initiating file transfer: " + this._ftpClient.getReplyCode() + " " + this._ftpClient.getReplyString());
                continue;
            }
            this._reader.readEntities(OrbcadRecord.class, in);
            in.close();
            if (!this._ftpClient.completePendingCommand()) {
                _log.warn("error completing file transfer: " + this._ftpClient.getReplyCode() + " " + this._ftpClient.getReplyString());
                continue;
            }
            long t4 = SystemTime.currentTimeMillis();
            if (!_log.isDebugEnabled()) continue;
            _log.info("file download time: " + (t4 - t3));
        }
    }

    private void disconnectFtpClient() {
        try {
            if (this._ftpClient != null) {
                this._ftpClient.disconnect();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this._ftpClient = null;
        }
    }
}

