/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.orbcad;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.csv_entities.CsvEntityReader;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.schema.AnnotationDrivenEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.AbstractOrbcadRecordSource;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.OrbcadRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(value="org.onebusaway.transit_data_federation.impl.realtime.orbcad:name=OrbcadRecordHttpSource")
public class OrbcadRecordHttpSource
extends AbstractOrbcadRecordSource {
    private static Logger _log = LoggerFactory.getLogger(OrbcadRecordHttpSource.class);
    private CsvEntityReader _reader;
    private String _url;

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    @PostConstruct
    public void start() throws SocketException, IOException {
        _log.info("starting orbcad http download client");
        super.start();
    }

    @Override
    @PreDestroy
    public void stop() throws IOException {
        _log.info("stopping orbcad http download client");
        super.stop();
    }

    @Override
    protected void setup() {
        this._reader = new CsvEntityReader();
        AnnotationDrivenEntitySchemaFactory entitySchemaFactory = new AnnotationDrivenEntitySchemaFactory();
        entitySchemaFactory.addEntityClass(OrbcadRecord.class);
        this._reader.setEntitySchemaFactory((EntitySchemaFactory)entitySchemaFactory);
        this._reader.addEntityHandler((EntityHandler)new AbstractOrbcadRecordSource.RecordHandler(this));
    }

    @Override
    protected void handleRefresh() throws IOException {
        URL url = new URL(this._url);
        InputStream in = url.openStream();
        this._reader.readEntities(OrbcadRecord.class, in);
        in.close();
    }
}

