/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.problems.EProblemReportStatus;
import org.onebusaway.transit_data.model.problems.ETripProblemGroupBy;
import org.onebusaway.transit_data.model.problems.TripProblemReportQueryBean;
import org.onebusaway.transit_data_federation.impl.reporting.StopProblemReportRecord;
import org.onebusaway.transit_data_federation.impl.reporting.TripProblemReportRecord;
import org.onebusaway.transit_data_federation.services.reporting.UserReportingDao;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class UserReportingDaoImpl
implements UserReportingDao {
    private SessionFactory _sessionFactory;

    UserReportingDaoImpl() {
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @Override
    @Transactional
    public void saveOrUpdate(Object record) {
        this.getSession().saveOrUpdate(record);
    }

    @Override
    public void delete(Object entity) {
        this.getSession().delete(entity);
    }

    @Override
    public List<T2<AgencyAndId, Integer>> getStopProblemReportSummaries(String agencyId, long timeFrom, long timeTo, EProblemReportStatus status) {
        List records = null;
        records = status == null ? this.getSession().getNamedQuery("stopProblemReportSummaries").setParameter("agencyId", (Object)agencyId).setParameter("timeFrom", (Object)timeFrom).setParameter("timeTo", (Object)timeTo).list() : this.getSession().getNamedQuery("stopProblemReportSummariesWithStatus").setParameter("agencyId", (Object)agencyId).setParameter("timeFrom", (Object)timeFrom).setParameter("timeTo", (Object)timeTo).setParameter("status", (Object)status).list();
        ArrayList<T2<AgencyAndId, Integer>> results = new ArrayList<T2<AgencyAndId, Integer>>(records.size());
        for (Object[] record : records) {
            AgencyAndId stopId = (AgencyAndId)record[0];
            Long count = (Long)record[1];
            results.add((T2<AgencyAndId, Integer>)Tuples.tuple((Object)stopId, (Object)count.intValue()));
        }
        return results;
    }

    @Override
    public List<T2<Object, Integer>> getTripProblemReportSummaries(TripProblemReportQueryBean query, ETripProblemGroupBy groupBy) {
        Criteria c = this.getSession().createCriteria(TripProblemReportRecord.class);
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.rowCount());
        switch (groupBy) {
            case TRIP: {
                projections.add((Projection)Projections.groupProperty((String)"tripId.agencyId"));
                projections.add((Projection)Projections.groupProperty((String)"tripId.id"));
                break;
            }
            case STATUS: {
                projections.add((Projection)Projections.groupProperty((String)"status"));
                break;
            }
            case LABEL: {
                projections.add((Projection)Projections.groupProperty((String)"label"));
            }
        }
        c.setProjection((Projection)projections);
        this.addQueryToCriteria(query, c);
        List rows = c.list();
        ArrayList<T2<Object, Integer>> results = new ArrayList<T2<Object, Integer>>(rows.size());
        for (Object[] row : rows) {
            Long count = (Long)row[0];
            Object key = this.getKeyForTripProblemReportSummariesRow(row, groupBy);
            results.add((T2<Object, Integer>)Tuples.tuple((Object)key, (Object)count.intValue()));
        }
        return results;
    }

    @Override
    public List<StopProblemReportRecord> getStopProblemReports(String agencyId, long timeFrom, long timeTo, EProblemReportStatus status) {
        if (status == null) {
            return this.getSession().getNamedQuery("stopProblemReports").setParameter("agencyId", (Object)agencyId).setParameter("timeFrom", (Object)timeFrom).setParameter("timeTo", (Object)timeTo).list();
        }
        return this.getSession().getNamedQuery("stopProblemReportsWithStatus").setParameter("agencyId", (Object)agencyId).setParameter("timeFrom", (Object)timeFrom).setParameter("timeTo", (Object)timeTo).setParameter("status", (Object)status).list();
    }

    @Override
    public List<TripProblemReportRecord> getTripProblemReports(TripProblemReportQueryBean query) {
        Criteria c = this.getSession().createCriteria(TripProblemReportRecord.class);
        this.addQueryToCriteria(query, c);
        c.addOrder(Order.asc((String)"time"));
        return c.list();
    }

    @Override
    public List<StopProblemReportRecord> getAllStopProblemReportsForStopId(AgencyAndId stopId) {
        return this.getSession().getNamedQuery("allStopProblemReportsForStopId").setParameter("stopId", (Object)stopId).list();
    }

    @Override
    public List<TripProblemReportRecord> getAllTripProblemReportsForTripId(AgencyAndId tripId) {
        return this.getSession().getNamedQuery("allTripProblemReportsForTripId").setParameter("tripId", (Object)tripId).list();
    }

    @Override
    public StopProblemReportRecord getStopProblemRecordForId(long id) {
        return (StopProblemReportRecord)this.getSession().get(StopProblemReportRecord.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public TripProblemReportRecord getTripProblemRecordForId(long id) {
        return (TripProblemReportRecord)this.getSession().get(TripProblemReportRecord.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public List<String> getAllTripProblemReportLabels() {
        return this.getSession().getNamedQuery("allTripProblemReportLabels").list();
    }

    private Object getKeyForTripProblemReportSummariesRow(Object[] row, ETripProblemGroupBy groupBy) {
        switch (groupBy) {
            case TRIP: {
                return new AgencyAndId((String)row[1], (String)row[2]);
            }
            case STATUS: {
                return row[1];
            }
            case LABEL: {
                return row[1];
            }
        }
        throw new IllegalStateException("unhandled grouping: " + groupBy);
    }

    private void addQueryToCriteria(TripProblemReportQueryBean query, Criteria c) {
        if (query.getAgencyId() != null) {
            c.add((Criterion)Property.forName((String)"tripId.agencyId").eq((Object)query.getAgencyId()));
        }
        if (query.getTripId() != null) {
            c.add((Criterion)Property.forName((String)"tripId").eq((Object)AgencyAndIdLibrary.convertFromString((String)query.getTripId())));
        }
        if (query.getTimeFrom() != 0L) {
            c.add((Criterion)Property.forName((String)"time").ge((Object)query.getTimeFrom()));
        }
        if (query.getTimeTo() != 0L) {
            c.add((Criterion)Property.forName((String)"time").le((Object)query.getTimeTo()));
        }
        if (query.getStatus() != null) {
            c.add((Criterion)Property.forName((String)"status").eq((Object)query.getStatus()));
        }
        if (query.getLabel() != null) {
            c.add((Criterion)Property.forName((String)"label").eq((Object)query.getLabel()));
        }
    }

    private Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }
}

