/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBean;
import org.onebusaway.transit_data.model.problems.EProblemReportStatus;
import org.onebusaway.transit_data.model.problems.ETripProblemGroupBy;
import org.onebusaway.transit_data.model.problems.StopProblemReportBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportSummaryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportSummaryBean;
import org.onebusaway.transit_data_federation.impl.reporting.StopProblemReportRecord;
import org.onebusaway.transit_data_federation.impl.reporting.TripProblemReportRecord;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureQuery;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopTimeBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureInstance;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.reporting.UserReportingDao;
import org.onebusaway.transit_data_federation.services.reporting.UserReportingService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class UserReportingServiceImpl
implements UserReportingService {
    private UserReportingDao _userReportingDao;
    private TransitGraphDao _graph;
    private BlockStatusService _blockStatusService;
    private ArrivalAndDepartureService _arrivalAndDepartureService;
    private TripBeanService _tripBeanService;
    private StopBeanService _stopBeanService;
    private StopTimeBeanService _stopTimeBeanService;

    UserReportingServiceImpl() {
    }

    @Autowired
    public void setUserReportingDao(UserReportingDao userReportingDao) {
        this._userReportingDao = userReportingDao;
    }

    @Autowired
    public void setGrah(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    @Autowired
    public void setArrivalAndDepartureService(ArrivalAndDepartureService arrivalAndDepartureService) {
        this._arrivalAndDepartureService = arrivalAndDepartureService;
    }

    @Autowired
    public void setTripBeanService(TripBeanService tripBeanService) {
        this._tripBeanService = tripBeanService;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setStopTimeBeanService(StopTimeBeanService stopTimeBeanService) {
        this._stopTimeBeanService = stopTimeBeanService;
    }

    @Override
    public void reportProblemWithStop(StopProblemReportBean problem) {
        StopProblemReportRecord record = new StopProblemReportRecord();
        String stopId = problem.getStopId();
        if (stopId != null) {
            record.setStopId(AgencyAndIdLibrary.convertFromString((String)stopId));
        }
        record.setTime(problem.getTime());
        record.setCode(problem.getCode());
        record.setUserComment(problem.getUserComment());
        if (!Double.isNaN(problem.getUserLat())) {
            record.setUserLat(problem.getUserLat());
        }
        if (!Double.isNaN(problem.getUserLon())) {
            record.setUserLon(problem.getUserLon());
        }
        if (!Double.isNaN(problem.getUserLocationAccuracy())) {
            record.setUserLocationAccuracy(problem.getUserLocationAccuracy());
        }
        record.setStatus(problem.getStatus());
        this._userReportingDao.saveOrUpdate(record);
    }

    @Override
    public void reportProblemWithTrip(TripProblemReportBean problem) {
        List<BlockLocation> blockLocations;
        BlockLocation blockLocation;
        String stopId;
        AgencyAndId tripId = AgencyAndIdLibrary.convertFromString((String)problem.getTripId());
        TripEntry trip = this._graph.getTripEntryForId(tripId);
        if (trip == null) {
            return;
        }
        BlockEntry block = trip.getBlock();
        TripProblemReportRecord record = new TripProblemReportRecord();
        record.setCode(problem.getCode());
        record.setServiceDate(problem.getServiceDate());
        String vehicleId = problem.getVehicleId();
        if (vehicleId != null) {
            record.setVehicleId(AgencyAndIdLibrary.convertFromString((String)vehicleId));
        }
        if ((stopId = problem.getStopId()) != null) {
            record.setStopId(AgencyAndIdLibrary.convertFromString((String)stopId));
        }
        record.setTime(problem.getTime());
        record.setTripId(tripId);
        record.setBlockId(block.getId());
        record.setUserComment(problem.getUserComment());
        if (problem.getUserLat() != null && !Double.isNaN(problem.getUserLat())) {
            record.setUserLat(problem.getUserLat());
        }
        if (problem.getUserLon() != null && !Double.isNaN(problem.getUserLon())) {
            record.setUserLon(problem.getUserLon());
        }
        if (problem.getUserLocationAccuracy() != null && !Double.isNaN(problem.getUserLocationAccuracy())) {
            record.setUserLocationAccuracy(problem.getUserLocationAccuracy());
        }
        record.setUserOnVehicle(problem.isUserOnVehicle());
        record.setUserVehicleNumber(problem.getUserVehicleNumber());
        Map<BlockInstance, List<BlockLocation>> locationsByInstance = this._blockStatusService.getBlocks(block.getId(), problem.getServiceDate(), record.getVehicleId(), problem.getTime());
        BlockInstance blockInstance = this.getBestBlockInstance(locationsByInstance.keySet());
        if (blockInstance != null && (blockLocation = this.getBestLocation(blockLocations = locationsByInstance.get(blockInstance), problem)) != null) {
            CoordinatePoint p;
            record.setPredicted(blockLocation.isPredicted());
            if (blockLocation.isDistanceAlongBlockSet()) {
                record.setDistanceAlongBlock(blockLocation.getDistanceAlongBlock());
            }
            if (blockLocation.isScheduleDeviationSet()) {
                record.setScheduleDeviation(blockLocation.getScheduleDeviation());
            }
            if ((p = blockLocation.getLocation()) != null) {
                record.setVehicleLat(p.getLat());
                record.setVehicleLon(p.getLon());
            }
            record.setMatchedVehicleId(blockLocation.getVehicleId());
        }
        record.setStatus(problem.getStatus());
        this._userReportingDao.saveOrUpdate(record);
    }

    @Override
    public ListBean<StopProblemReportSummaryBean> getStopProblemReportSummaries(StopProblemReportQueryBean query) {
        List<T2<AgencyAndId, Integer>> records = this._userReportingDao.getStopProblemReportSummaries(query.getAgencyId(), query.getTimeFrom(), query.getTimeTo(), query.getStatus());
        ArrayList<StopProblemReportSummaryBean> beans = new ArrayList<StopProblemReportSummaryBean>(records.size());
        for (T2<AgencyAndId, Integer> record : records) {
            AgencyAndId stopId = (AgencyAndId)record.getFirst();
            Integer count = (Integer)record.getSecond();
            StopProblemReportSummaryBean bean = new StopProblemReportSummaryBean();
            bean.setStop(this._stopBeanService.getStopForId(stopId, null));
            bean.setStatus(query.getStatus());
            bean.setCount(count.intValue());
            beans.add(bean);
        }
        return new ListBean(beans, false);
    }

    @Override
    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummaries(TripProblemReportQueryBean query, ETripProblemGroupBy groupBy) {
        List<T2<Object, Integer>> records = this._userReportingDao.getTripProblemReportSummaries(query, groupBy);
        ArrayList<TripProblemReportSummaryBean> beans = new ArrayList<TripProblemReportSummaryBean>(records.size());
        for (T2<Object, Integer> record : records) {
            TripProblemReportSummaryBean bean = new TripProblemReportSummaryBean();
            bean.setCount(((Integer)record.getSecond()).intValue());
            switch (groupBy) {
                case TRIP: {
                    AgencyAndId tripId = (AgencyAndId)record.getFirst();
                    bean.setTrip(this._tripBeanService.getTripForId(tripId));
                    break;
                }
                case STATUS: {
                    EProblemReportStatus status = (EProblemReportStatus)record.getFirst();
                    bean.setStatus(status);
                    break;
                }
                case LABEL: {
                    String label = (String)record.getFirst();
                    bean.setLabel(label);
                    break;
                }
            }
            beans.add(bean);
        }
        return new ListBean(beans, false);
    }

    @Override
    public ListBean<StopProblemReportBean> getStopProblemReports(StopProblemReportQueryBean query) {
        List<StopProblemReportRecord> records = this._userReportingDao.getStopProblemReports(query.getAgencyId(), query.getTimeFrom(), query.getTimeTo(), query.getStatus());
        ArrayList<StopProblemReportBean> beans = new ArrayList<StopProblemReportBean>(records.size());
        for (StopProblemReportRecord record : records) {
            beans.add(this.getRecordAsBean(record));
        }
        return new ListBean(beans, false);
    }

    @Override
    public ListBean<TripProblemReportBean> getTripProblemReports(TripProblemReportQueryBean query) {
        List<TripProblemReportRecord> records = this._userReportingDao.getTripProblemReports(query);
        ArrayList<TripProblemReportBean> beans = new ArrayList<TripProblemReportBean>(records.size());
        for (TripProblemReportRecord record : records) {
            beans.add(this.getRecordAsBean(record));
        }
        return new ListBean(beans, false);
    }

    @Override
    public List<StopProblemReportBean> getAllStopProblemReportsForStopId(AgencyAndId stopId) {
        List<StopProblemReportRecord> records = this._userReportingDao.getAllStopProblemReportsForStopId(stopId);
        ArrayList<StopProblemReportBean> beans = new ArrayList<StopProblemReportBean>(records.size());
        for (StopProblemReportRecord record : records) {
            beans.add(this.getRecordAsBean(record));
        }
        return beans;
    }

    @Override
    public List<TripProblemReportBean> getAllTripProblemReportsForTripId(AgencyAndId tripId) {
        List<TripProblemReportRecord> records = this._userReportingDao.getAllTripProblemReportsForTripId(tripId);
        ArrayList<TripProblemReportBean> beans = new ArrayList<TripProblemReportBean>(records.size());
        for (TripProblemReportRecord record : records) {
            beans.add(this.getRecordAsBean(record));
        }
        return beans;
    }

    @Override
    public StopProblemReportBean getStopProblemReportForId(long id) {
        StopProblemReportRecord record = this._userReportingDao.getStopProblemRecordForId(id);
        return this.getRecordAsBean(record);
    }

    @Override
    public TripProblemReportBean getTripProblemReportForId(long id) {
        TripProblemReportRecord record = this._userReportingDao.getTripProblemRecordForId(id);
        return this.getRecordAsBean(record);
    }

    @Override
    public void deleteStopProblemReportForId(long id) {
        StopProblemReportRecord record = this._userReportingDao.getStopProblemRecordForId(id);
        if (record != null) {
            this._userReportingDao.delete(record);
        }
    }

    @Override
    public void updateTripProblemReport(TripProblemReportBean bean) {
        TripProblemReportRecord record = this._userReportingDao.getTripProblemRecordForId(bean.getId());
        if (record == null) {
            return;
        }
        record.setStatus(bean.getStatus());
        record.setLabel(bean.getLabel());
        this._userReportingDao.saveOrUpdate(record);
    }

    @Override
    public void deleteTripProblemReportForId(long id) {
        TripProblemReportRecord record = this._userReportingDao.getTripProblemRecordForId(id);
        if (record != null) {
            this._userReportingDao.delete(record);
        }
    }

    @Override
    public List<String> getAllTripProblemReportLabels() {
        return this._userReportingDao.getAllTripProblemReportLabels();
    }

    private BlockInstance getBestBlockInstance(Collection<BlockInstance> blockInstances) {
        if (blockInstances.isEmpty()) {
            return null;
        }
        return blockInstances.iterator().next();
    }

    private BlockLocation getBestLocation(List<BlockLocation> blockLocations, TripProblemReportBean problem) {
        if (blockLocations.isEmpty()) {
            return null;
        }
        return blockLocations.get(0);
    }

    private StopProblemReportBean getRecordAsBean(StopProblemReportRecord record) {
        AgencyAndId stopId = record.getStopId();
        StopProblemReportBean bean = new StopProblemReportBean();
        bean.setCode(record.getCode());
        bean.setId(record.getId());
        bean.setStatus(record.getStatus());
        bean.setStopId(AgencyAndIdLibrary.convertToString((AgencyAndId)stopId));
        bean.setTime(record.getTime());
        bean.setUserComment(record.getUserComment());
        if (record.getUserLat() != null) {
            bean.setUserLat(record.getUserLat().doubleValue());
        }
        if (record.getUserLon() != null) {
            bean.setUserLon(record.getUserLon().doubleValue());
        }
        if (record.getUserLocationAccuracy() != null) {
            bean.setUserLocationAccuracy(record.getUserLocationAccuracy().doubleValue());
        }
        if (stopId != null) {
            try {
                bean.setStop(this._stopBeanService.getStopForId(stopId, null));
            }
            catch (NoSuchStopServiceException noSuchStopServiceException) {
                // empty catch block
            }
        }
        return bean;
    }

    private TripProblemReportBean getRecordAsBean(TripProblemReportRecord record) {
        AgencyAndId stopId = record.getStopId();
        AgencyAndId tripId = record.getTripId();
        TripProblemReportBean bean = new TripProblemReportBean();
        bean.setCode(record.getCode());
        bean.setId(record.getId());
        bean.setServiceDate(record.getServiceDate());
        bean.setStatus(record.getStatus());
        bean.setLabel(record.getLabel());
        bean.setStopId(AgencyAndIdLibrary.convertToString((AgencyAndId)stopId));
        bean.setTime(record.getTime());
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripId));
        bean.setUserComment(record.getUserComment());
        bean.setUserLat(record.getUserLat());
        bean.setUserLon(record.getUserLon());
        bean.setUserLocationAccuracy(record.getUserLocationAccuracy());
        bean.setUserOnVehicle(record.isUserOnVehicle());
        bean.setUserVehicleNumber(record.getUserVehicleNumber());
        bean.setPredicted(record.isPredicted());
        bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getVehicleId()));
        bean.setDistanceAlongBlock(record.getDistanceAlongBlock());
        bean.setScheduleDeviation(record.getScheduleDeviation());
        bean.setVehicleLat(record.getVehicleLat());
        bean.setVehicleLon(record.getVehicleLon());
        if (stopId != null) {
            try {
                bean.setStop(this._stopBeanService.getStopForId(stopId, null));
            }
            catch (NoSuchStopServiceException noSuchStopServiceException) {
                // empty catch block
            }
        }
        if (tripId != null) {
            bean.setTrip(this._tripBeanService.getTripForId(tripId));
        }
        if (tripId != null && stopId != null) {
            TripEntry trip = this._graph.getTripEntryForId(tripId);
            StopEntry stop = this._graph.getStopEntryForId(stopId);
            if (trip != null && stop != null) {
                AgencyAndId vehicleId = record.getMatchedVehicleId();
                if (vehicleId == null) {
                    vehicleId = record.getVehicleId();
                }
                ArrivalAndDepartureQuery query = new ArrivalAndDepartureQuery();
                query.setStop(stop);
                query.setStopSequence(-1);
                query.setTrip(trip);
                query.setServiceDate(record.getServiceDate());
                query.setVehicleId(vehicleId);
                query.setTime(record.getTime());
                ArrivalAndDepartureInstance instance = this._arrivalAndDepartureService.getArrivalAndDepartureForStop(query);
                if (instance != null) {
                    StopTimeInstance sti = instance.getStopTimeInstance();
                    StopTimeInstanceBean stopTimeBean = this._stopTimeBeanService.getStopTimeInstanceAsBean(sti);
                    bean.setStopTime(stopTimeBean);
                }
            }
        }
        return bean;
    }
}

