/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.schedule;

import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.ScheduleHelperService;
import org.onebusaway.transit_data_federation.services.StopTimeService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledServiceServiceImpl
implements ScheduleHelperService {
    private static final long SCHEDULE_WINDOW_BEFORE = 900000L;
    private static final long SCHEDULE_WINDOW_AFTER = 3600000L;
    @Autowired
    private BlockCalendarService _blockCalendarService;
    @Autowired
    private BlockIndexService _blockIndexService;
    @Autowired
    private StopTimeService _stopTimeService;
    @Autowired
    private TransitGraphDao _transitGraphDao;

    @Override
    public Boolean routeHasUpcomingScheduledService(String agencyId, long time, String routeId, String directionId) {
        long serviceEnd;
        long serviceStart;
        AgencyAndId routeAndId = routeId != null && routeId.contains("_") ? AgencyAndIdLibrary.convertFromString((String)routeId) : new AgencyAndId(agencyId, routeId);
        List<BlockInstance> instances = this._blockCalendarService.getActiveBlocksForRouteInTimeRange(routeAndId, serviceStart = time - 900000L, serviceEnd = time + 3600000L);
        if (instances.isEmpty()) {
            return false;
        }
        for (BlockInstance instance : instances) {
            List<BlockTripEntry> tripsInBlock = instance.getBlock().getTrips();
            if (tripsInBlock.isEmpty()) continue;
            for (BlockTripEntry blockTripEntry : tripsInBlock) {
                TripEntry tripEntry = blockTripEntry.getTrip();
                if (!tripEntry.getRoute().getId().toString().equals(routeId) || tripEntry.getDirectionId() != null && !tripEntry.getDirectionId().equals(directionId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean stopHasUpcomingScheduledService(String stopAgencyId, long time, String stopId, String routeId, String directionId) {
        AgencyAndId stopAndId = null;
        if (stopId != null && stopId.contains("_")) {
            stopAndId = AgencyAndIdLibrary.convertFromString((String)stopId);
        } else if (stopId != null) {
            stopAndId = new AgencyAndId(stopAgencyId, stopId);
        }
        StopEntry stopEntry = this._transitGraphDao.getStopEntryForId(stopAndId);
        if (stopEntry == null) {
            return null;
        }
        Date serviceStart = new Date(time - 900000L);
        Date serviceEnd = new Date(time + 3600000L);
        List<StopTimeInstance> stis = this._stopTimeService.getStopTimeInstancesInTimeRange(stopEntry, serviceStart, serviceEnd, StopTimeService.EFrequencyStopTimeBehavior.INCLUDE_UNSPECIFIED);
        if (stis.isEmpty()) {
            return false;
        }
        for (StopTimeInstance stopTime : stis) {
            BlockTripEntry blockTripEntry = stopTime.getTrip();
            TripEntry tripEntry = blockTripEntry.getTrip();
            if (!tripEntry.getRoute().getId().toString().equals(routeId) || tripEntry.getDirectionId() != null && !tripEntry.getDirectionId().equals(directionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean stopHasRevenueServiceOnRoute(String agencyId, String stopId, String routeId, String directionId) {
        AgencyAndId stopAndId = null;
        if (stopId != null && stopId.contains("_")) {
            stopAndId = AgencyAndIdLibrary.convertFromString((String)stopId);
        } else if (stopId != null) {
            stopAndId = new AgencyAndId(agencyId, stopId);
        }
        StopEntry stopEntry = this._transitGraphDao.getStopEntryForId(stopAndId);
        List<BlockStopTimeIndex> stopTimeIndicesForStop = this._blockIndexService.getStopTimeIndicesForStop(stopEntry);
        for (BlockStopTimeIndex bsti : stopTimeIndicesForStop) {
            List<BlockStopTimeEntry> stopTimes = bsti.getStopTimes();
            for (BlockStopTimeEntry bste : stopTimes) {
                StopTimeEntry stopTime = bste.getStopTime();
                TripEntry theTrip = stopTime.getTrip();
                if (routeId != null && !theTrip.getRoute().getId().toString().equals(routeId) || directionId != null && theTrip.getDirectionId() != null && !theTrip.getDirectionId().equals(directionId) || stopTime.getDropOffType() != 0 && stopTime.getPickupType() != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean stopHasRevenueService(String agencyId, String stopId) {
        return this.stopHasRevenueServiceOnRoute(agencyId, stopId, null, null);
    }

    @Override
    public List<String> getSearchSuggestions(String agencyId, String input) {
        return null;
    }

    @Override
    public List<StopBean> filterRevenueService(AgencyBean agency, StopsBean stops) {
        return stops.getStops();
    }
}

