/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.shapes;

import java.util.Comparator;
import org.onebusaway.geospatial.model.XYPoint;

public class PointAndIndex {
    public static final Comparator<PointAndIndex> DISTANCE_FROM_TARGET_COMPARATOR = new DistanceFromTargetComparator();
    public final XYPoint point;
    public final int index;
    public final double distanceFromTarget;
    public final double distanceAlongShape;

    public PointAndIndex(XYPoint point, int index, double distanceFromTarget, double distanceAlongShape) {
        this.point = point;
        this.index = index;
        this.distanceFromTarget = distanceFromTarget;
        this.distanceAlongShape = distanceAlongShape;
    }

    public String toString() {
        return "xy=" + this.point.toString() + " index=" + this.index + " distanceFromTarget=" + this.distanceFromTarget + " distanceAlongShape=" + this.distanceAlongShape;
    }

    public static class DistanceFromTargetComparator
    implements Comparator<PointAndIndex> {
        @Override
        public int compare(PointAndIndex a, PointAndIndex b) {
            if (a.distanceFromTarget == b.distanceFromTarget) {
                return 0;
            }
            return a.distanceFromTarget < b.distanceFromTarget ? -1 : 1;
        }
    }
}

