/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.shapes;

import java.util.List;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.model.ShapePointsFactory;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.shapes.ShapePointService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShapePointServiceImpl
implements ShapePointService {
    private NarrativeService _narrativeService;

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Override
    public ShapePoints getShapePointsForShapeId(AgencyAndId shapeId) {
        return this._narrativeService.getShapePointsForId(shapeId);
    }

    @Override
    @Cacheable
    public ShapePoints getShapePointsForShapeIds(List<AgencyAndId> shapeIds) {
        ShapePointsFactory factory = new ShapePointsFactory();
        for (AgencyAndId shapeId : shapeIds) {
            ShapePoints shapePoints = this.getShapePointsForShapeId(shapeId);
            factory.addPoints(shapePoints);
        }
        return factory.create();
    }
}

