/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.time;

import java.util.List;

public class GenericBinarySearch {
    public static <T> int search(List<T> elements, double targetValue, ValueAdapter<T> valueAdapter) {
        return GenericBinarySearch.search(elements, targetValue, valueAdapter, 0, elements.size());
    }

    public static <T> int search(T elements, int size, double targetValue, IndexAdapter<T> valueAdapter) {
        return GenericBinarySearch.search(elements, targetValue, valueAdapter, 0, size);
    }

    public static <T> int searchRange(T elements, int indexFrom, int indexTo, double targetValue, IndexAdapter<T> valueAdapter) {
        return GenericBinarySearch.search(elements, targetValue, valueAdapter, indexFrom, indexTo);
    }

    private static <T> int search(List<T> elements, double target, ValueAdapter<T> comparator, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return fromIndex;
        }
        int midIndex = (fromIndex + toIndex) / 2;
        T element = elements.get(midIndex);
        double v = comparator.getValue(element);
        if (target < v) {
            return GenericBinarySearch.search(elements, target, comparator, fromIndex, midIndex);
        }
        if (target > v) {
            return GenericBinarySearch.search(elements, target, comparator, midIndex + 1, toIndex);
        }
        return midIndex;
    }

    private static <T> int search(T elements, double target, IndexAdapter<T> adapter, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return fromIndex;
        }
        int midIndex = (fromIndex + toIndex) / 2;
        double v = adapter.getValue(elements, midIndex);
        if (target < v) {
            return GenericBinarySearch.search(elements, target, adapter, fromIndex, midIndex);
        }
        if (target > v) {
            return GenericBinarySearch.search(elements, target, adapter, midIndex + 1, toIndex);
        }
        return midIndex;
    }

    public static interface IndexAdapter<T> {
        public double getValue(T var1, int var2);
    }

    public static interface ValueAdapter<T> {
        public double getValue(T var1);
    }
}

