/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;

public class BlockStopTimeEntryImpl
implements BlockStopTimeEntry {
    private final StopTimeEntry stopTime;
    private final BlockTripEntry trip;
    private final int blockSequence;
    private final boolean hasNextStop;

    public BlockStopTimeEntryImpl(StopTimeEntry stopTime, int blockSequence, BlockTripEntry trip, boolean hasNextStop) {
        if (stopTime == null) {
            throw new IllegalArgumentException("stopTime is null");
        }
        if (trip == null) {
            throw new IllegalArgumentException("trip is null");
        }
        this.stopTime = stopTime;
        this.trip = trip;
        this.blockSequence = blockSequence;
        this.hasNextStop = hasNextStop;
    }

    @Override
    public StopTimeEntry getStopTime() {
        return this.stopTime;
    }

    @Override
    public BlockTripEntry getTrip() {
        return this.trip;
    }

    @Override
    public int getBlockSequence() {
        return this.blockSequence;
    }

    @Override
    public double getDistanceAlongBlock() {
        return this.trip.getDistanceAlongBlock() + this.stopTime.getShapeDistTraveled();
    }

    @Override
    public int getAccumulatedSlackTime() {
        return this.trip.getAccumulatedSlackTime() + this.stopTime.getAccumulatedSlackTime();
    }

    @Override
    public boolean hasPreviousStop() {
        return this.blockSequence > 0;
    }

    @Override
    public boolean hasNextStop() {
        return this.hasNextStop;
    }

    @Override
    public BlockStopTimeEntry getPreviousStop() {
        return this.trip.getBlockConfiguration().getStopTimes().get(this.blockSequence);
    }

    @Override
    public BlockStopTimeEntry getNextStop() {
        return this.trip.getBlockConfiguration().getStopTimes().get(this.blockSequence + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockSequence;
        result = 31 * result + this.stopTime.hashCode();
        result = 31 * result + this.trip.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStopTimeEntryImpl other = (BlockStopTimeEntryImpl)obj;
        if (this.blockSequence != other.blockSequence) {
            return false;
        }
        if (!this.stopTime.equals(other.stopTime)) {
            return false;
        }
        return this.trip.equals(other.trip);
    }

    public String toString() {
        return "BlockStopTime(stopTime=" + this.stopTime + " blockSeq=" + this.blockSequence + " trip=" + this.trip + ")";
    }
}

