/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.collections.Min;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.Point;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.geospatial.services.UTMLibrary;
import org.onebusaway.geospatial.services.UTMProjection;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndIndex;
import org.onebusaway.transit_data_federation.impl.shapes.ShapePointsLibrary;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DistanceAlongShapeLibrary {
    private static Logger _log = LoggerFactory.getLogger(DistanceAlongShapeLibrary.class);
    private static NumberFormat _errorFormatter = new DecimalFormat("0.00");
    private ShapePointsLibrary _shapePointsLibrary = new ShapePointsLibrary();
    private double _maxDistanceFromStopToShapePoint = 1000.0;
    private int _maximumNumberOfPotentialAssignments = 1000;
    private boolean _lenientStopShapeAssignment = true;
    private Set<AgencyAndId> _shapeIdsWeHavePrinted = new HashSet<AgencyAndId>();

    @ConfigurationParameter
    public void setLocalMinimumThreshold(double localMinimumThreshold) {
        this._shapePointsLibrary.setLocalMinimumThreshold(localMinimumThreshold);
    }

    @ConfigurationParameter
    public void setMaxDistanceFromStopToShapePoint(double maxDistanceFromStopToShapePoint) {
        this._maxDistanceFromStopToShapePoint = maxDistanceFromStopToShapePoint;
    }

    @ConfigurationParameter
    public void setMaximumNumberOfPotentialAssignment(int maximumNumberOfPotentialAssignments) {
        this._maximumNumberOfPotentialAssignments = maximumNumberOfPotentialAssignments;
    }

    @ConfigurationParameter
    public void setLenientStopShapeAssignment(boolean lenient) {
        this._lenientStopShapeAssignment = lenient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointAndIndex[] getDistancesAlongShape(ShapePoints shapePoints, List<StopTimeEntry> stopTimes) throws DistanceAlongShapeException {
        UTMProjection projection;
        PointAndIndex[] stopTimePoints = new PointAndIndex[stopTimes.size()];
        ShapePointsLibrary shapePointsLibrary = this._shapePointsLibrary;
        synchronized (shapePointsLibrary) {
            projection = UTMLibrary.getProjectionForPoint((double)shapePoints.getLats()[0], (double)shapePoints.getLons()[0]);
        }
        List<XYPoint> projectedShapePoints = this._shapePointsLibrary.getProjectedShapePoints(shapePoints, projection);
        double[] shapePointsDistTraveled = shapePoints.getDistTraveled();
        List<List<PointAndIndex>> possibleAssignments = this.computePotentialAssignments(projection, projectedShapePoints, shapePointsDistTraveled, stopTimes);
        this.pruneUnnecessaryAssignments(possibleAssignments);
        this.assignmentSanityCheck(shapePoints, stopTimes, possibleAssignments);
        double maxDistanceTraveled = shapePointsDistTraveled[shapePointsDistTraveled.length - 1];
        List<PointAndIndex> bestAssignment = this.computeBestAssignment(shapePoints, stopTimes, possibleAssignments, projection, projectedShapePoints);
        double last = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < stopTimePoints.length; ++i) {
            PointAndIndex pindex = bestAssignment.get(i);
            if (pindex.distanceAlongShape > maxDistanceTraveled) {
                int index = projectedShapePoints.size() - 1;
                XYPoint point = projectedShapePoints.get(index);
                StopEntry stop = stopTimes.get(i).getStop();
                XYPoint stopPoint = projection.forward(stop.getStopLocation());
                double d = stopPoint.getDistance((Point)point);
                pindex = new PointAndIndex(point, index, d, maxDistanceTraveled);
            }
            if (last > pindex.distanceAlongShape) {
                this.constructError(shapePoints, stopTimes, possibleAssignments, projection);
            }
            last = pindex.distanceAlongShape;
            stopTimePoints[i] = pindex;
        }
        return stopTimePoints;
    }

    private void pruneUnnecessaryAssignments(List<List<PointAndIndex>> possibleAssignments) {
        int i;
        double[] mins = new double[possibleAssignments.size()];
        double[] maxs = new double[possibleAssignments.size()];
        for (i = 0; i < possibleAssignments.size(); ++i) {
            double minScore = Double.POSITIVE_INFINITY;
            double maxScore = Double.NEGATIVE_INFINITY;
            for (PointAndIndex pi : possibleAssignments.get(i)) {
                minScore = Math.min(minScore, pi.distanceAlongShape);
                maxScore = Math.max(maxScore, pi.distanceAlongShape);
            }
            mins[i] = minScore;
            maxs[i] = maxScore;
        }
        for (i = 0; i < possibleAssignments.size(); ++i) {
            double nextMin;
            double prevMax;
            List<PointAndIndex> points = possibleAssignments.get(i);
            if (points.size() == 1) continue;
            double currentMin = mins[i];
            double currentMax = maxs[i];
            if (i > 0 && currentMin < (prevMax = maxs[i - 1]) || i + 1 < possibleAssignments.size() && currentMax > (nextMin = mins[i + 1])) continue;
            Collections.sort(points, PointAndIndex.DISTANCE_FROM_TARGET_COMPARATOR);
            while (points.size() > 1) {
                points.remove(points.size() - 1);
            }
        }
    }

    private void assignmentSanityCheck(ShapePoints shapePoints, List<StopTimeEntry> stopTimes, List<List<PointAndIndex>> possibleAssignments) throws DistanceAlongShapeException {
        int stIndex = 0;
        for (List<PointAndIndex> assignments : possibleAssignments) {
            if (assignments.isEmpty()) {
                StopTimeEntry stopTime = stopTimes.get(stIndex);
                throw new InvalidStopToShapeMappingException(stopTime.getTrip());
            }
            Min m = new Min();
            for (PointAndIndex pindex : assignments) {
                m.add(pindex.distanceFromTarget, (Object)pindex);
            }
            if (m.getMinValue() > this._maxDistanceFromStopToShapePoint) {
                PointAndIndex pindex;
                StopTimeEntry stopTime = stopTimes.get(stIndex);
                pindex = (PointAndIndex)m.getMinElement();
                CoordinatePoint point = shapePoints.getPointForIndex(pindex.index);
                throw new StopIsTooFarFromShapeException(stopTime, pindex, point);
            }
            ++stIndex;
        }
    }

    private List<List<PointAndIndex>> computePotentialAssignments(UTMProjection projection, List<XYPoint> projectedShapePoints, double[] shapePointDistance, List<StopTimeEntry> stopTimes) {
        ArrayList<List<PointAndIndex>> possibleAssignments = new ArrayList<List<PointAndIndex>>();
        for (StopTimeEntry stopTime : stopTimes) {
            StopEntry stop = stopTime.getStop();
            XYPoint stopPoint = projection.forward(stop.getStopLocation());
            List<PointAndIndex> assignments = this._shapePointsLibrary.computePotentialAssignments(projectedShapePoints, shapePointDistance, stopPoint, 0, projectedShapePoints.size());
            possibleAssignments.add(assignments);
        }
        return possibleAssignments;
    }

    private List<PointAndIndex> computeBestAssignment(ShapePoints shapePoints, List<StopTimeEntry> stopTimes, List<List<PointAndIndex>> possibleAssignments, UTMProjection projection, List<XYPoint> projectedShapePoints) throws InvalidStopToShapeMappingException {
        this.checkFirstAndLastStop(stopTimes, possibleAssignments, shapePoints, projection, projectedShapePoints);
        int startIndex = 0;
        int assingmentCount = 1;
        for (int index = 0; index < possibleAssignments.size(); ++index) {
            boolean hasMultipleAssignmentsAndLastPoint;
            List<PointAndIndex> possibleAssignment = possibleAssignments.get(index);
            int count = possibleAssignment.size();
            if (count == 0) {
                this.constructErrorForPotentialAssignmentCount(shapePoints, stopTimes, count);
            }
            boolean hasRegion = index > startIndex;
            boolean hasSingleAssignmentFollowingMultipleAssignments = count == 1 && assingmentCount > 1;
            boolean bl = hasMultipleAssignmentsAndLastPoint = count > 1 && index == possibleAssignments.size() - 1;
            if (hasRegion && (hasSingleAssignmentFollowingMultipleAssignments || hasMultipleAssignmentsAndLastPoint)) {
                ArrayList<PointAndIndex> currentAssignment = new ArrayList<PointAndIndex>(index - startIndex + 1);
                Min bestAssignments = new Min();
                this.recursivelyConstructAssignments(possibleAssignments, currentAssignment, startIndex, startIndex, index + 1, (Min<Assignment>)bestAssignments, 0, stopTimes.get(0).toString());
                if (bestAssignments.isEmpty()) {
                    this.constructError(shapePoints, stopTimes, possibleAssignments, projection);
                } else {
                    List<PointAndIndex> bestAssignment = ((Assignment)bestAssignments.getMinElement()).assigment;
                    for (int bestIndex = 0; bestIndex < bestAssignment.size(); ++bestIndex) {
                        possibleAssignments.set(startIndex + bestIndex, Arrays.asList(bestAssignment.get(bestIndex)));
                    }
                }
            }
            if (count == 1) {
                startIndex = index;
                assingmentCount = 1;
                continue;
            }
            if ((assingmentCount *= count) <= this._maximumNumberOfPotentialAssignments) continue;
            this.constructErrorForPotentialAssignmentCount(shapePoints, stopTimes, assingmentCount);
        }
        ArrayList<PointAndIndex> bestAssignment = new ArrayList<PointAndIndex>();
        for (List<PointAndIndex> possibleAssignment : possibleAssignments) {
            if (possibleAssignment.size() != 1) {
                String msg = "expected just one assignment at this point, found " + possibleAssignment.size() + "; shapePoint=" + shapePoints.getShapeId() + ", \npossibleAssignments=\n";
                for (PointAndIndex pa : possibleAssignment) {
                    msg = msg + "PointAndIndex(index=" + pa.index + ", point=" + pa.point + ", distanceAlongShape=" + pa.distanceAlongShape + ", distanceFromTarget=" + pa.distanceFromTarget + "), ";
                }
                msg = msg + "\nstopTime=\n";
                for (StopTimeEntry st : stopTimes) {
                    msg = msg + "StopTimeEntry(Stop(" + st.getStop().getId() + ":" + st.getStop().getStopLat() + ", " + st.getStop().getStopLon() + "), trip=" + st.getTrip().getId() + "), ";
                }
                _log.error(msg);
                if (!this._lenientStopShapeAssignment) {
                    throw new IllegalStateException(msg);
                }
            }
            bestAssignment.add(possibleAssignment.get(0));
        }
        return bestAssignment;
    }

    private void checkFirstAndLastStop(List<StopTimeEntry> stopTimes, List<List<PointAndIndex>> possibleAssignments, ShapePoints shapePoints, UTMProjection projection, List<XYPoint> projectedShapePoints) {
        if (possibleAssignments.size() >= 2) {
            PointAndIndex first = possibleAssignments.get(0).get(0);
            PointAndIndex second = possibleAssignments.get(1).get(0);
            if (first.distanceAlongShape > second.distanceAlongShape) {
                StopTimeEntry firstStopTime = stopTimes.get(0);
                _log.warn("snapping first stop time id=" + firstStopTime.getId() + " to start of shape");
                XYPoint point = projectedShapePoints.get(0);
                StopEntry stop = firstStopTime.getStop();
                XYPoint stopPoint = projection.forward(stop.getStopLocation());
                double d = stopPoint.getDistance((Point)point);
                possibleAssignments.get(0).add(new PointAndIndex(point, 0, d, 0.0));
            }
            int n = possibleAssignments.size();
            PointAndIndex prev = possibleAssignments.get(n - 2).get(0);
            PointAndIndex last = possibleAssignments.get(n - 1).get(0);
            if (prev.distanceAlongShape > last.distanceAlongShape) {
                // empty if block
            }
        }
        if (possibleAssignments.size() > 0) {
            PointAndIndex lastSnapped = this.getLastStopSnappedToEndOfShape(stopTimes, shapePoints, projection, projectedShapePoints);
            possibleAssignments.get(possibleAssignments.size() - 1).add(lastSnapped);
        }
    }

    private PointAndIndex getLastStopSnappedToEndOfShape(List<StopTimeEntry> stopTimes, ShapePoints shapePoints, UTMProjection projection, List<XYPoint> projectedShapePoints) {
        int i = stopTimes.size() - 1;
        StopTimeEntry lastStopTime = stopTimes.get(i);
        int lastShapePointIndex = projectedShapePoints.size() - 1;
        XYPoint lastShapePoint = projectedShapePoints.get(lastShapePointIndex);
        XYPoint stopLocation = projection.forward(lastStopTime.getStop().getStopLocation());
        double existingDistanceAlongShape = shapePoints.getDistTraveledForIndex(lastShapePointIndex);
        double extraDistanceAlongShape = lastShapePoint.getDistance((Point)stopLocation);
        double distanceAlongShape = existingDistanceAlongShape + extraDistanceAlongShape;
        double d = lastShapePoint.getDistance((Point)stopLocation);
        return new PointAndIndex(lastShapePoint, lastShapePointIndex, d, distanceAlongShape);
    }

    private void recursivelyConstructAssignments(List<List<PointAndIndex>> possibleAssignments, List<PointAndIndex> currentAssignment, int index, int indexFrom, int indexTo, Min<Assignment> best, int depth, String id) {
        if (index == indexTo) {
            double score = 0.0;
            for (PointAndIndex p : currentAssignment) {
                score += p.distanceFromTarget;
            }
            currentAssignment = new ArrayList<PointAndIndex>(currentAssignment);
            Assignment result = new Assignment(currentAssignment, score);
            best.add(score, (Object)result);
            return;
        }
        List<PointAndIndex> possibleAssignmentsForIndex = possibleAssignments.get(index);
        ArrayList<PointAndIndex> validAssignments = new ArrayList<PointAndIndex>();
        double lastDistanceAlongShape = -1.0;
        if (index > indexFrom) {
            PointAndIndex prev = currentAssignment.get(index - 1 - indexFrom);
            lastDistanceAlongShape = prev.distanceAlongShape;
        }
        for (PointAndIndex possibleAssignmentForIndex : possibleAssignmentsForIndex) {
            if (!(possibleAssignmentForIndex.distanceAlongShape >= lastDistanceAlongShape)) continue;
            validAssignments.add(possibleAssignmentForIndex);
        }
        if (validAssignments.isEmpty()) {
            return;
        }
        if (validAssignments.size() > 100) {
            _log.warn("complex assignment with depth {} for {} and {} possible assignments", new Object[]{depth, id, possibleAssignments.size()});
        }
        for (PointAndIndex validAssignment : validAssignments) {
            currentAssignment.add(validAssignment);
            this.recursivelyConstructAssignments(possibleAssignments, currentAssignment, index + 1, indexFrom, indexTo, best, depth + 1, id);
            currentAssignment.remove(currentAssignment.size() - 1);
        }
    }

    private void constructErrorForPotentialAssignmentCount(ShapePoints shapePoints, List<StopTimeEntry> stopTimes, long count) throws InvalidStopToShapeMappingException {
        if (count == 0L) {
            _log.error("We were attempting to compute the distance along a particular trip for each stop time of that trip by snapping them to the shape for that trip.  However, we could not find an assignment for each stop time of the trip, which usually indicates that there is something wrong with the underlying shape data.  For more information on errors of this kind, see:\n  https://github.com/OneBusAway/onebusaway-application-modules/wiki/Stop-to-Shape-Matching");
        } else {
            _log.error("We were attempting to compute the distance along a particular trip for each stop time of that trip by snapping them to the shape for that trip.  However, we found WAY TOO MANY potential assignments, which usually indicates that there is something wrong with the underlying shape data.  For more information on errors of this kind, see:\n  https://github.com/OneBusAway/onebusaway-application-modules/wiki/Stop-to-Shape-Matching");
        }
        StopTimeEntry first = stopTimes.get(0);
        TripEntry trip = first.getTrip();
        StopTimeEntry last = stopTimes.get(stopTimes.size() - 1);
        _log.error("error constructing stop-time distances along shape for trip=" + trip.getId() + " shape=" + trip.getShapeId() + " firstStopTime=" + first.getId() + " lastStopTime=" + last.getId());
        if (this._shapeIdsWeHavePrinted.add(trip.getShapeId())) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < shapePoints.getSize(); ++i) {
                b.append(shapePoints.getLatForIndex(i));
                b.append(' ');
                b.append(shapePoints.getLonForIndex(i));
                b.append(' ');
                b.append(shapePoints.getDistTraveledForIndex(i));
                b.append('\n');
            }
            _log.error("shape points:\n" + b.toString());
        }
        throw new InvalidStopToShapeMappingException(first.getTrip());
    }

    private void constructError(ShapePoints shapePoints, List<StopTimeEntry> stopTimes, List<List<PointAndIndex>> possibleAssignments, UTMProjection projection) throws InvalidStopToShapeMappingException {
        StopTimeEntry first = stopTimes.get(0);
        StopTimeEntry last = stopTimes.get(stopTimes.size() - 1);
        _log.error("We were attempting to compute the distance along a particular trip for each stop time of that trip by snapping them to the shape for that trip.  However, we could not find an assignment for each stop time where the distance traveled along the shape for each stop time was strictly increasing (aka a stop time seemed to travel backwards).  For more information on errors of this kind, see:\n  https://github.com/OneBusAway/onebusaway-application-modules/wiki/Stop-to-Shape-Matching");
        TripEntry trip = first.getTrip();
        _log.error("error constructing stop-time distances along shape for trip=" + trip.getId() + " shape=" + trip.getShapeId() + " firstStopTime=" + first.getId() + " lastStopTime=" + last.getId());
        StringBuilder b = new StringBuilder();
        int index = 0;
        b.append("# potential assignments:\n");
        b.append("# stopLat stopLon stopId\n");
        b.append("#   locationOnShapeLat locationOnShapeLon distanceAlongShape distanceFromShape shapePointIndex\n");
        b.append("#   ...\n");
        double prevMaxDistanceAlongShape = Double.NEGATIVE_INFINITY;
        for (List<PointAndIndex> possible : possibleAssignments) {
            StopTimeEntry stopTime = stopTimes.get(index);
            StopEntry stop = stopTime.getStop();
            b.append(stop.getStopLat());
            b.append(' ');
            b.append(stop.getStopLon());
            b.append(' ');
            b.append(index);
            b.append(' ');
            b.append(stop.getId());
            b.append('\n');
            double maxDistanceAlongShape = Double.NEGATIVE_INFINITY;
            double minDistanceAlongShape = Double.POSITIVE_INFINITY;
            for (PointAndIndex pindex : possible) {
                b.append("  ");
                b.append(projection.reverse(pindex.point));
                b.append(' ');
                b.append(_errorFormatter.format(pindex.distanceAlongShape));
                b.append(' ');
                b.append(_errorFormatter.format(pindex.distanceFromTarget));
                b.append(' ');
                b.append(pindex.index);
                b.append("\n");
                maxDistanceAlongShape = Math.max(maxDistanceAlongShape, pindex.distanceAlongShape);
                minDistanceAlongShape = Math.min(minDistanceAlongShape, pindex.distanceAlongShape);
            }
            if (minDistanceAlongShape < prevMaxDistanceAlongShape) {
                b.append("    ^ potential problem here ^\n");
            }
            prevMaxDistanceAlongShape = maxDistanceAlongShape;
            ++index;
        }
        _log.error(b.toString());
        if (this._shapeIdsWeHavePrinted.add(trip.getShapeId())) {
            b = new StringBuilder();
            index = 0;
            for (int i = 0; i < shapePoints.getSize(); ++i) {
                b.append(shapePoints.getLatForIndex(i));
                b.append(' ');
                b.append(shapePoints.getLonForIndex(i));
                b.append(' ');
                b.append(shapePoints.getDistTraveledForIndex(i));
                b.append('\n');
            }
            _log.error("shape points:\n" + b.toString());
        }
        throw new InvalidStopToShapeMappingException(first.getTrip());
    }

    public static class InvalidStopToShapeMappingException
    extends DistanceAlongShapeException {
        private static final long serialVersionUID = 1L;
        private final TripEntry _trip;

        public InvalidStopToShapeMappingException(TripEntry trip) {
            super("trip=" + trip.getId());
            this._trip = trip;
        }

        public TripEntry getTrip() {
            return this._trip;
        }
    }

    public static class StopIsTooFarFromShapeException
    extends DistanceAlongShapeException {
        private static final long serialVersionUID = 1L;
        private final StopTimeEntry _stopTime;
        private final PointAndIndex _pointAndIndex;
        private final CoordinatePoint _point;

        public StopIsTooFarFromShapeException(StopTimeEntry stopTime, PointAndIndex pointAndIndex, CoordinatePoint point) {
            super("stopTime=" + stopTime + " pointAndIndex=" + pointAndIndex + " point=" + point);
            this._stopTime = stopTime;
            this._pointAndIndex = pointAndIndex;
            this._point = point;
        }

        public StopTimeEntry getStopTime() {
            return this._stopTime;
        }

        public PointAndIndex getPointAndIndex() {
            return this._pointAndIndex;
        }

        public CoordinatePoint getPoint() {
            return this._point;
        }
    }

    public static class DistanceAlongShapeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DistanceAlongShapeException(String message) {
            super(message);
        }
    }

    private static class Assignment
    implements Comparable<Assignment> {
        private final List<PointAndIndex> assigment;
        private final double score;

        public Assignment(List<PointAndIndex> assignment, double score) {
            this.assigment = assignment;
            this.score = score;
        }

        @Override
        public int compareTo(Assignment o) {
            return Double.compare(this.score, o.score);
        }
    }
}

