/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyBlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;

public class FrequencyBlockStopTimeEntryImpl
implements FrequencyBlockStopTimeEntry {
    private final BlockStopTimeEntry _blockStopTime;
    private final FrequencyEntry _frequency;

    public FrequencyBlockStopTimeEntryImpl(BlockStopTimeEntry blockStopTime, FrequencyEntry frequency) {
        if (blockStopTime == null || frequency == null) {
            throw new IllegalArgumentException();
        }
        this._blockStopTime = blockStopTime;
        this._frequency = frequency;
    }

    @Override
    public BlockStopTimeEntry getStopTime() {
        return this._blockStopTime;
    }

    @Override
    public FrequencyEntry getFrequency() {
        return this._frequency;
    }

    @Override
    public int getStopTimeOffset() {
        int d0 = this._blockStopTime.getTrip().getDepartureTimeForIndex(0);
        int d1 = this._blockStopTime.getStopTime().getDepartureTime();
        int delta = d1 - d0;
        int headway = this._frequency.getHeadwaySecs();
        return delta % headway;
    }
}

